/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation;

import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.advice.annotation.Arg;
import org.jboss.aop.advice.annotation.Args;
import org.jboss.aop.advice.annotation.Caller;
import org.jboss.aop.advice.annotation.JoinPoint;
import org.jboss.aop.advice.annotation.Return;
import org.jboss.aop.advice.annotation.Target;
import org.jboss.aop.advice.annotation.Thrown;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.Invocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ParameterAnnotationRule {
    JOIN_POINT(JoinPoint.class, JoinPointInfo.class, -1, 700, false, true){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            return properties.getInfoType();
        }
    }
    ,
    INVOCATION(JoinPoint.class, Invocation.class, -2, 700, false, true){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            return properties.getInvocationType();
        }
    }
    ,
    TARGET(Target.class, null, -3, 300, false, true){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            return properties.getTargetType();
        }

        public boolean lowerRankGrade(AdviceMethodProperties properties) {
            return !properties.isTargetAvailable();
        }
    }
    ,
    CALLER(Caller.class, null, -7, 150, false, true){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            return properties.getCallerType();
        }

        public boolean lowerRankGrade(AdviceMethodProperties properties) {
            return !properties.isCallerAvailable();
        }
    }
    ,
    THROWABLE(Thrown.class, Throwable.class, -5, 50, true, true),
    RETURN(Return.class, null, -4, 50, false, true){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            return properties.getJoinpointReturnType();
        }
    }
    ,
    ARG(Arg.class, null, -8, 2, false, false){

        public Object getAssignableFrom(AdviceMethodProperties properties) {
            return properties.getJoinpointParameters();
        }
    }
    ,
    ARGS(Args.class, Object[].class, -6, 1, false, true){

        public boolean lowerRankGrade(AdviceMethodProperties properties) {
            return properties.getInvocationType() == FieldReadInvocation.class;
        }
    };

    private Class annotation;
    private Class assignableFrom;
    private int rankGrade;
    private boolean mandatory;
    private boolean singleEnforced;
    private int property;

    private ParameterAnnotationRule(Class annotation, Class assignableFrom, int property, int rankGrade, boolean mandatory, boolean singleEnforced) {
        this.annotation = annotation;
        this.assignableFrom = assignableFrom;
        this.property = property;
        this.rankGrade = rankGrade;
        this.mandatory = mandatory;
        this.singleEnforced = singleEnforced;
    }

    public final Class getAnnotation() {
        return this.annotation;
    }

    public Object getAssignableFrom(AdviceMethodProperties properties) {
        return this.assignableFrom;
    }

    public final int getProperty() {
        return this.property;
    }

    public final int getRankGrade() {
        return this.rankGrade;
    }

    public boolean lowerRankGrade(AdviceMethodProperties properties) {
        return false;
    }

    public final boolean isMandatory() {
        return this.mandatory;
    }

    public final boolean isSingleEnforced() {
        return this.singleEnforced;
    }
}

