/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.advice.annotation.AdviceInfo;
import org.jboss.aop.advice.annotation.AdviceMethodFactory;
import org.jboss.aop.advice.annotation.Arg;
import org.jboss.aop.advice.annotation.ParameterAnnotationRule;
import org.jboss.aop.advice.annotation.ParameterAnnotationRuleException;

class AnnotatedParameterAdviceInfo
extends AdviceInfo {
    private ParameterAnnotationType[] paramTypes;
    private ParameterAnnotationType[] contextParamTypes;
    private int[][] mutuallyExclusive;

    public AnnotatedParameterAdviceInfo(AdviceMethodProperties properties, Method method, ParameterAnnotationRule[] rules, ParameterAnnotationRule[] contextRules, int[][] mutuallyExclusive) throws ParameterAnnotationRuleException {
        super(method, 0);
        this.paramTypes = this.createParameterAnnotationTypes(rules);
        this.contextParamTypes = this.createParameterAnnotationTypes(contextRules);
        this.mutuallyExclusive = mutuallyExclusive;
        this.applyRules(properties);
    }

    public boolean validate(AdviceMethodProperties properties, AdviceMethodFactory.ReturnType returnType) {
        for (ParameterAnnotationType paramType : this.paramTypes) {
            if (paramType.validate(properties)) continue;
            return false;
        }
        for (ParameterAnnotationType paramType : this.contextParamTypes) {
            if (paramType.validate(properties)) continue;
            return false;
        }
        switch (returnType) {
            case ANY: {
                if (this.method.getReturnType() == Void.TYPE) break;
            }
            case NOT_VOID: {
                if (properties.getJoinpointReturnType() == Void.TYPE || this.method.getReturnType() == Object.class || properties.getJoinpointReturnType().isAssignableFrom(this.method.getReturnType())) break;
                if (AspectManager.verbose) {
                    AdviceMethodFactory.adviceMatchingMessage.append("\n[warn] - return value of ");
                    AdviceMethodFactory.adviceMatchingMessage.append(this.method);
                    AdviceMethodFactory.adviceMatchingMessage.append(" can not be assigned to type ");
                    AdviceMethodFactory.adviceMatchingMessage.append(properties.getJoinpointReturnType());
                }
                return false;
            }
        }
        for (int i = 0; i < this.mutuallyExclusive.length; ++i) {
            int[] exclusiveParamTypes = this.mutuallyExclusive[i];
            int found = -1;
            for (int j = 0; j < exclusiveParamTypes.length; ++j) {
                if (!this.contextParamTypes[exclusiveParamTypes[j]].isSet()) continue;
                if (found != -1) {
                    if (AspectManager.verbose) {
                        AdviceMethodFactory.adviceMatchingMessage.append("\n[warn] - the use of parameter annotations ");
                        AdviceMethodFactory.adviceMatchingMessage.append(this.contextParamTypes[exclusiveParamTypes[found]].rule.getAnnotation());
                        AdviceMethodFactory.adviceMatchingMessage.append(" and ");
                        AdviceMethodFactory.adviceMatchingMessage.append(this.contextParamTypes[exclusiveParamTypes[j]].rule.getAnnotation());
                        AdviceMethodFactory.adviceMatchingMessage.append(" is mutually exclusive");
                    }
                    return false;
                }
                found = j;
            }
        }
        return true;
    }

    public void resetValidation() {
        int i;
        for (i = 0; i < this.paramTypes.length; ++i) {
            this.paramTypes[i].resetValidation();
        }
        for (i = 0; i < this.contextParamTypes.length; ++i) {
            this.contextParamTypes[i].resetValidation();
        }
    }

    public short getAssignabilityDegree(int annotationIndex, boolean isContextRule, AdviceMethodProperties properties) {
        if (isContextRule) {
            return this.contextParamTypes[annotationIndex].getAssignabilityDegree(properties);
        }
        return this.paramTypes[annotationIndex].getAssignabilityDegree(properties);
    }

    public void assignAdviceInfo(AdviceMethodProperties properties) {
        int i;
        int[] args = new int[this.parameterTypes.length];
        for (i = 0; i < this.paramTypes.length; ++i) {
            this.paramTypes[i].assignParameterInfo(args);
        }
        for (i = 0; i < this.contextParamTypes.length; ++i) {
            this.contextParamTypes[i].assignParameterInfo(args);
        }
        properties.setFoundProperties(this.method, args);
    }

    private final ParameterAnnotationType[] createParameterAnnotationTypes(ParameterAnnotationRule[] rules) {
        ParameterAnnotationType[] types = new ParameterAnnotationType[rules.length];
        for (int i = 0; i < rules.length; ++i) {
            types[i] = rules[i].isSingleEnforced() ? new SingleParameterType(rules[i]) : new MultipleParameterType(rules[i], this.method.getParameterTypes().length);
        }
        return types;
    }

    private void applyRules(AdviceMethodProperties properties) throws ParameterAnnotationRuleException {
        Annotation[][] paramAnnotations = this.method.getParameterAnnotations();
        boolean nullifyRank = false;
        for (int i = 0; i < paramAnnotations.length; ++i) {
            ParameterAnnotationType typeFound = null;
            for (Annotation annotation : paramAnnotations[i]) {
                if (typeFound == null) {
                    typeFound = this.findAnnotationType(annotation, i);
                    continue;
                }
                if (this.findAnnotationType(annotation, i) == null) continue;
                if (AspectManager.verbose) {
                    throw new ParameterAnnotationRuleException("\n[warn] -parameter " + i + " of method " + this.method + " contains more than one valid annotation");
                }
                throw new ParameterAnnotationRuleException(null);
            }
            if (typeFound == null) {
                if (AspectManager.verbose) {
                    if (paramAnnotations[i].length == 0) {
                        throw new ParameterAnnotationRuleException("\n[warn] -parameter " + i + " of method " + this.method + " is not annotated");
                    }
                    throw new ParameterAnnotationRuleException("\n[warn] -parameter " + i + " of method " + this.method + " is not annotated correctly" + "\n[warn]  Expecting one of: " + this.getDescription(this.paramTypes) + this.getDescription(this.contextParamTypes));
                }
                throw new ParameterAnnotationRuleException(null);
            }
            nullifyRank = nullifyRank || typeFound.rule.lowerRankGrade(properties);
        }
        if (nullifyRank) {
            this.rank = 0;
        }
    }

    private String getDescription(ParameterAnnotationType[] types) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 1; i < types.length; ++i) {
            buffer.append("\n          ");
            buffer.append(types[i]);
        }
        return buffer.toString();
    }

    private final ParameterAnnotationType findAnnotationType(Annotation annotation, int i) throws ParameterAnnotationRuleException {
        int j;
        for (j = 0; j < this.paramTypes.length; ++j) {
            if (!this.paramTypes[j].applies(annotation, i)) continue;
            return this.paramTypes[j];
        }
        for (j = 0; j < this.contextParamTypes.length; ++j) {
            if (!this.contextParamTypes[j].applies(annotation, i)) continue;
            return this.contextParamTypes[j];
        }
        return null;
    }

    class MultipleParameterType
    extends ParameterAnnotationType {
        private int[][] indexes;
        private int[] originalIndexValues;
        private int indexesLength;

        public MultipleParameterType(ParameterAnnotationRule rule, int totalParams) {
            super(rule);
            this.indexes = new int[totalParams][2];
            this.indexesLength = 0;
            this.originalIndexValues = new int[totalParams];
        }

        public final void setIndex(int index, Annotation annotation) throws ParameterAnnotationRuleException {
            if (this.indexesLength == this.indexes.length) {
                throw new ParameterAnnotationRuleException("Found more @Arg annotated parameters than the number of parameters available on joinpoint");
            }
            this.indexes[this.indexesLength][0] = index;
            this.originalIndexValues[this.indexesLength] = ((Arg)annotation).index();
            this.indexes[this.indexesLength][1] = this.originalIndexValues[this.indexesLength];
            ++this.indexesLength;
            AnnotatedParameterAdviceInfo.this.rank += this.rule.getRankGrade();
        }

        public final boolean isSet() {
            return this.indexesLength > 0;
        }

        public final boolean internalValidate(AdviceMethodProperties properties) {
            int i;
            Class[] expectedTypes = (Class[])this.rule.getAssignableFrom(properties);
            Class<?>[] adviceTypes = AnnotatedParameterAdviceInfo.this.method.getParameterTypes();
            boolean[] taken = new boolean[expectedTypes.length];
            for (i = 0; i < this.indexesLength; ++i) {
                if (this.indexes[i][1] == -1) continue;
                if (this.indexes[i][1] < 0) {
                    if (AspectManager.verbose) {
                        AdviceMethodFactory.adviceMatchingMessage.append("\n[warn] - Negative joinpoint parameter indexes are not allowed.");
                    }
                    return false;
                }
                if (this.indexes[i][1] >= expectedTypes.length) {
                    if (AspectManager.verbose) {
                        AdviceMethodFactory.adviceMatchingMessage.append("\n[warn] - There is no joinpoint parameter with index ");
                        AdviceMethodFactory.adviceMatchingMessage.append(this.indexes[i][1]);
                        AdviceMethodFactory.adviceMatchingMessage.append(", since there are ");
                        AdviceMethodFactory.adviceMatchingMessage.append(expectedTypes.length == 0 ? "no" : Integer.valueOf(expectedTypes.length));
                        AdviceMethodFactory.adviceMatchingMessage.append("joinpoint parameters available");
                    }
                    return false;
                }
                if (!adviceTypes[this.indexes[i][0]].isAssignableFrom(expectedTypes[this.indexes[i][1]])) {
                    if (AspectManager.verbose) {
                        AdviceMethodFactory.adviceMatchingMessage.append("\n[warn] - Advice parameter ");
                        AdviceMethodFactory.adviceMatchingMessage.append(this.indexes[i][0]);
                        AdviceMethodFactory.adviceMatchingMessage.append(", of type ");
                        AdviceMethodFactory.adviceMatchingMessage.append(adviceTypes[this.indexes[i][0]].getName());
                        AdviceMethodFactory.adviceMatchingMessage.append(", cannot be assigned to the value of joinpoint parameter with index ");
                        AdviceMethodFactory.adviceMatchingMessage.append(this.indexes[i][1]);
                        AdviceMethodFactory.adviceMatchingMessage.append(", whose type is ");
                        AdviceMethodFactory.adviceMatchingMessage.append(expectedTypes[this.indexes[i][1]].getName());
                    }
                    return false;
                }
                if (taken[this.indexes[i][1]]) {
                    if (AspectManager.verbose) {
                        AdviceMethodFactory.adviceMatchingMessage.append("\n[warn] - Joinpoint parameter index '");
                        AdviceMethodFactory.adviceMatchingMessage.append(this.indexes[i][0]);
                        AdviceMethodFactory.adviceMatchingMessage.append("' cannot be assigned to more than one '@Arg' advice parameter");
                    }
                    return false;
                }
                taken[this.indexes[i][1]] = true;
            }
            for (i = 0; i < this.indexesLength; ++i) {
                int j;
                if (this.indexes[i][1] != -1) continue;
                boolean found = false;
                for (j = 0; j < expectedTypes.length; ++j) {
                    if (adviceTypes[this.indexes[i][0]] != expectedTypes[j] || taken[j]) continue;
                    this.indexes[i][1] = j;
                    taken[j] = true;
                    found = true;
                    break;
                }
                if (found) continue;
                for (j = 0; j < expectedTypes.length; ++j) {
                    if (!adviceTypes[this.indexes[i][0]].isAssignableFrom(expectedTypes[j]) || taken[j]) continue;
                    this.indexes[i][1] = j;
                    taken[j] = true;
                    found = true;
                    break;
                }
                if (found) continue;
                if (AspectManager.verbose) {
                    AdviceMethodFactory.adviceMatchingMessage.append("\n[warn] - not found a match for argument ");
                    AdviceMethodFactory.adviceMatchingMessage.append(adviceTypes[this.indexes[i][0]]);
                    AdviceMethodFactory.adviceMatchingMessage.append(" of ");
                    AdviceMethodFactory.adviceMatchingMessage.append(AnnotatedParameterAdviceInfo.this.method);
                    AdviceMethodFactory.adviceMatchingMessage.append("\n[warn]   expected one of types:");
                    for (j = 0; j < expectedTypes.length; ++j) {
                        AdviceMethodFactory.adviceMatchingMessage.append(expectedTypes[j]);
                        AdviceMethodFactory.adviceMatchingMessage.append(" ");
                    }
                }
                return false;
            }
            return true;
        }

        public void resetValidation() {
            for (int i = 0; i < this.indexesLength; ++i) {
                this.indexes[i][1] = this.originalIndexValues[i];
            }
        }

        public short getAssignabilityDegree(AdviceMethodProperties properties) {
            if (this.indexesLength == 0) {
                return -1;
            }
            Class[] expectedTypes = (Class[])this.rule.getAssignableFrom(properties);
            short level = 0;
            for (int i = 0; i < this.indexesLength; ++i) {
                level = (short)(level + AnnotatedParameterAdviceInfo.this.getAssignabilityDegree(expectedTypes[this.indexes[i][1]], AnnotatedParameterAdviceInfo.this.method.getParameterTypes()[this.indexes[i][0]]));
            }
            return level;
        }

        public void assignParameterInfo(int[] args) {
            for (int i = 0; i < this.indexesLength; ++i) {
                args[this.indexes[i][0]] = this.indexes[i][1];
            }
        }
    }

    class SingleParameterType
    extends ParameterAnnotationType {
        int index;

        public SingleParameterType(ParameterAnnotationRule rule) {
            super(rule);
            this.index = -1;
        }

        public final void setIndex(int parameterIndex, Annotation annotation) throws ParameterAnnotationRuleException {
            if (this.index != -1) {
                if (AspectManager.verbose) {
                    throw new ParameterAnnotationRuleException("\n[warn] - found more than one occurence of " + this.rule.getAnnotation().getName() + " on parameters of advice" + AnnotatedParameterAdviceInfo.this.method);
                }
                throw new ParameterAnnotationRuleException(null);
            }
            this.index = parameterIndex;
            AnnotatedParameterAdviceInfo.this.rank += this.rule.getRankGrade();
        }

        public final boolean isSet() {
            return this.index != -1;
        }

        public final boolean internalValidate(AdviceMethodProperties properties) {
            if (this.index != -1 && !AnnotatedParameterAdviceInfo.this.method.getParameterTypes()[this.index].isAssignableFrom((Class)this.rule.getAssignableFrom(properties))) {
                if (AspectManager.verbose) {
                    AdviceMethodFactory.adviceMatchingMessage.append("\n[warn] - parameter annotated with ");
                    AdviceMethodFactory.adviceMatchingMessage.append(this.rule.getAnnotation());
                    AdviceMethodFactory.adviceMatchingMessage.append(" is not assignable from expected type ");
                    AdviceMethodFactory.adviceMatchingMessage.append(this.rule.getAssignableFrom(properties));
                    AdviceMethodFactory.adviceMatchingMessage.append(" on  method ");
                    AdviceMethodFactory.adviceMatchingMessage.append(AnnotatedParameterAdviceInfo.this.method);
                }
                return false;
            }
            return true;
        }

        public final void resetValidation() {
        }

        public final short getAssignabilityDegree(AdviceMethodProperties properties) {
            if (this.index == -1) {
                return -1;
            }
            return AnnotatedParameterAdviceInfo.this.getAssignabilityDegree((Class)this.rule.getAssignableFrom(properties), AnnotatedParameterAdviceInfo.this.method.getParameterTypes()[this.index]);
        }

        public final void assignParameterInfo(int[] args) {
            if (this.index != -1) {
                args[this.index] = this.rule.getProperty();
            }
        }
    }

    abstract class ParameterAnnotationType {
        ParameterAnnotationRule rule;

        public ParameterAnnotationType(ParameterAnnotationRule rule) {
            this.rule = rule;
        }

        public final boolean applies(Annotation parameterAnnotation) {
            return parameterAnnotation.annotationType() == this.rule.getAnnotation();
        }

        public final boolean applies(Annotation parameterAnnotation, int parameterIndex) throws ParameterAnnotationRuleException {
            if (parameterAnnotation.annotationType() == this.rule.getAnnotation()) {
                this.setIndex(parameterIndex, parameterAnnotation);
                return true;
            }
            return false;
        }

        public final boolean validate(AdviceMethodProperties properties) {
            if (this.rule.isMandatory() && !this.isSet()) {
                if (AspectManager.verbose) {
                    AdviceMethodFactory.adviceMatchingMessage.append("\n[warn] - mandatory parameter annotation ");
                    AdviceMethodFactory.adviceMatchingMessage.append(this.rule.getAnnotation());
                    AdviceMethodFactory.adviceMatchingMessage.append(" not found on method ");
                    AdviceMethodFactory.adviceMatchingMessage.append(AnnotatedParameterAdviceInfo.this.method);
                }
                return false;
            }
            return this.internalValidate(properties);
        }

        public String toString() {
            return this.rule.getAnnotation().toString();
        }

        public abstract void setIndex(int var1, Annotation var2) throws ParameterAnnotationRuleException;

        public abstract boolean isSet();

        public abstract boolean internalValidate(AdviceMethodProperties var1);

        public abstract void resetValidation();

        public abstract short getAssignabilityDegree(AdviceMethodProperties var1);

        public abstract void assignParameterInfo(int[] var1);
    }
}

