/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.advice.annotation.AdviceMethodFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AdviceInfo
implements Comparable<AdviceInfo> {
    protected int rank;
    protected Method method;
    protected Class<?>[] parameterTypes;

    protected AdviceInfo(Method method, int rank) {
        this.method = method;
        this.rank = rank;
        this.parameterTypes = method.getParameterTypes();
    }

    protected short getAssignabilityDegree(Class<?> fromType, Class<?> toType) {
        if (fromType == null || toType == null) {
            return 32766;
        }
        if (fromType == toType) {
            return 0;
        }
        if (toType.isInterface()) {
            if (fromType.isInterface()) {
                return this.getInterfaceInheritanceAD(fromType, toType, (short)0);
            }
            return this.getImplementationAD(fromType, toType);
        }
        if (fromType.isInterface()) {
            if (toType.getName() == "java.lang.Object") {
                ArrayList<Class<?>[]> list1 = new ArrayList<Class<?>[]>();
                ArrayList<Class<?>[]> list2 = new ArrayList<Class<?>[]>();
                Class<?>[] fromTypeInterfaces = fromType.getInterfaces();
                if (fromTypeInterfaces.length == 0) {
                    return 1;
                }
                list1.add(fromTypeInterfaces);
                short degree = 2;
                while (true) {
                    for (Class[] classArray : list1) {
                        for (int i = 0; i < classArray.length; ++i) {
                            Class<?>[] superInterfaces = classArray[i].getInterfaces();
                            if (superInterfaces.length == 0) {
                                return degree;
                            }
                            list2.add(superInterfaces);
                        }
                    }
                    degree = (short)(degree + 1);
                    list1.clear();
                    ArrayList<Class<?>[]> temp = list1;
                    list1 = list2;
                    list2 = temp;
                }
            }
            return Short.MAX_VALUE;
        }
        return this.getClassInheritanceAD(fromType.getSuperclass(), toType, (short)1);
    }

    private short getImplementationAD(Class<?> fromClassType, Class<?> toInterfaceType) {
        if (fromClassType == null) {
            return Short.MAX_VALUE;
        }
        Class<?>[] interfaces = fromClassType.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i] != toInterfaceType) continue;
            return 1;
        }
        short currentDegree = Short.MAX_VALUE;
        for (int i = 0; i < interfaces.length; ++i) {
            currentDegree = (short)Math.min(this.getInterfaceInheritanceAD(interfaces[i], toInterfaceType, (short)1), currentDegree);
        }
        if (currentDegree == Short.MAX_VALUE) {
            return this.getImplementationAD(fromClassType.getSuperclass(), toInterfaceType);
        }
        return currentDegree;
    }

    private short getInterfaceInheritanceAD(Class<?> fromInterfaceType, Class<?> toInterfaceType, short currentDegree) {
        Class<?>[] interfaces = fromInterfaceType.getInterfaces();
        currentDegree = (short)(currentDegree + 1);
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i] != toInterfaceType) continue;
            return currentDegree;
        }
        short bestDegree = Short.MAX_VALUE;
        for (int i = 0; i < interfaces.length; ++i) {
            bestDegree = (short)Math.min(this.getInterfaceInheritanceAD(interfaces[i], toInterfaceType, currentDegree), bestDegree);
        }
        return bestDegree;
    }

    private short getClassInheritanceAD(Class<?> fromClassType, Class<?> toClassType, short currentDegree) {
        if (fromClassType == null) {
            return Short.MAX_VALUE;
        }
        if (fromClassType == toClassType) {
            return currentDegree;
        }
        currentDegree = (short)(currentDegree + 1);
        return this.getClassInheritanceAD(fromClassType.getSuperclass(), toClassType, currentDegree);
    }

    public final short getReturnAssignabilityDegree(AdviceMethodProperties properties) {
        Class<?> returnType = this.method.getReturnType();
        if (returnType == Void.TYPE) {
            return Short.MAX_VALUE;
        }
        short degree = this.getAssignabilityDegree(returnType, properties.getJoinpointReturnType());
        if (degree == Short.MAX_VALUE) {
            return 32766;
        }
        return degree;
    }

    public final int getRank() {
        return this.rank;
    }

    @Override
    public int compareTo(AdviceInfo o) {
        return o.rank - this.rank;
    }

    public String toString() {
        return this.method.toString();
    }

    public abstract boolean validate(AdviceMethodProperties var1, AdviceMethodFactory.ReturnType var2);

    public abstract void resetValidation();

    public abstract short getAssignabilityDegree(int var1, boolean var2, AdviceMethodProperties var3);

    public abstract void assignAdviceInfo(AdviceMethodProperties var1);
}

