/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.beans.PropertyEditorManager;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.util.propertyeditor.ClassArrayEditor;
import org.jboss.util.propertyeditor.IntArrayEditor;
import org.jboss.util.propertyeditor.StringArrayEditor;

public class SecurityActions {
    private static void doInitEditors() {
        String[] currentPath = PropertyEditorManager.getEditorSearchPath();
        int length = currentPath != null ? currentPath.length : 0;
        String[] newPath = new String[length + 2];
        System.arraycopy(currentPath, 0, newPath, 2, length);
        newPath[0] = "org.jboss.util.propertyeditor";
        newPath[1] = "org.jboss.mx.util.propertyeditor";
        PropertyEditorManager.setEditorSearchPath(newPath);
        Class<String[]> strArrayType = String[].class;
        PropertyEditorManager.registerEditor(strArrayType, StringArrayEditor.class);
        Class<Class[]> clsArrayType = Class[].class;
        PropertyEditorManager.registerEditor(clsArrayType, ClassArrayEditor.class);
        Class<int[]> intArrayType = int[].class;
        PropertyEditorManager.registerEditor(intArrayType, IntArrayEditor.class);
    }

    static void initEditors() {
        if (System.getSecurityManager() == null) {
            InitPropertyEditorsAction.NON_PRIVILEGED.initEditors();
        } else {
            InitPropertyEditorsAction.PRIVILEGED.initEditors();
        }
    }

    private static interface InitPropertyEditorsAction {
        public static final InitPropertyEditorsAction PRIVILEGED = new InitPropertyEditorsAction(){

            public void initEditors() {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            SecurityActions.doInitEditors();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(e.getException());
                }
            }
        };
        public static final InitPropertyEditorsAction NON_PRIVILEGED = new InitPropertyEditorsAction(){

            public void initEditors() {
                SecurityActions.doInitEditors();
            }
        };

        public void initEditors();
    }
}

