/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.AspectFactoryWithClassLoader;
import org.jboss.aop.advice.AspectFactoryWithClassLoaderSupport;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.util.xml.XmlLoadable;
import org.w3c.dom.Element;

public class AspectFactoryDelegator
extends AspectFactoryWithClassLoaderSupport {
    private AspectFactory factory;
    private String factoryClass;
    private Element element;

    public AspectFactoryDelegator(String factory, Element element) {
        this.factoryClass = factory;
        this.element = element;
    }

    public String getName() {
        return this.factoryClass;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public synchronized AspectFactory getFactory() {
        if (this.factory == null) {
            try {
                Class clazz = super.loadClass(this.factoryClass);
                this.factory = (AspectFactory)clazz.newInstance();
                if (XmlLoadable.class.isAssignableFrom(this.factory.getClass())) {
                    ((XmlLoadable)((Object)this.factory)).importXml(this.element);
                }
                if (AspectFactoryWithClassLoader.class.isAssignableFrom(this.factory.getClass()) && super.getLoader() != null) {
                    ((AspectFactoryWithClassLoader)((Object)this.factory)).setClassLoader(super.getLoader());
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return this.factory;
    }

    public Object createPerVM() {
        Object aspect = this.getFactory().createPerVM();
        return aspect;
    }

    public Object createPerClass(Advisor advisor) {
        Object aspect = this.getFactory().createPerClass(advisor);
        return aspect;
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        Object aspect = this.getFactory().createPerInstance(advisor, instanceAdvisor);
        return aspect;
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        Object aspect = this.getFactory().createPerJoinpoint(advisor, jp);
        return aspect;
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        Object aspect = this.getFactory().createPerJoinpoint(advisor, instanceAdvisor, jp);
        return aspect;
    }
}

