/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.AccessibleObject;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javassist.CtClass;

class SecurityActions {
    SecurityActions() {
    }

    static void setAccessible(AccessibleObject accessibleObject) {
        if (System.getSecurityManager() == null) {
            SetAccessibleAction.NON_PRIVILEGED.setAccessible(accessibleObject);
        } else {
            SetAccessibleAction.PRIVILEGED.setAccessible(accessibleObject);
        }
    }

    static void debugWriteFile(CtClass ctClass) {
        if (System.getSecurityManager() == null) {
            CtClassDebugWriteFileAction.NON_PRIVILEGED.debugWriteFile(ctClass);
        } else {
            CtClassDebugWriteFileAction.PRIVILEGED.debugWriteFile(ctClass);
        }
    }

    static interface CtClassDebugWriteFileAction {
        public static final CtClassDebugWriteFileAction PRIVILEGED = new CtClassDebugWriteFileAction(){

            public void debugWriteFile(final CtClass ctClass) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ctClass.debugWriteFile();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    // empty catch block
                }
            }
        };
        public static final CtClassDebugWriteFileAction NON_PRIVILEGED = new CtClassDebugWriteFileAction(){

            public void debugWriteFile(CtClass ctClass) {
                ctClass.debugWriteFile();
            }
        };

        public void debugWriteFile(CtClass var1);
    }

    static interface SetAccessibleAction {
        public static final SetAccessibleAction PRIVILEGED = new SetAccessibleAction(){

            public void setAccessible(final AccessibleObject accessibleObject) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            accessibleObject.setAccessible(true);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Error setting " + accessibleObject + " as accessible ", e.getException());
                }
            }
        };
        public static final SetAccessibleAction NON_PRIVILEGED = new SetAccessibleAction(){

            public void setAccessible(AccessibleObject accessibleObject) {
                accessibleObject.setAccessible(true);
            }
        };

        public void setAccessible(AccessibleObject var1);
    }
}

