/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.deployers.plugins.attachments.AttachmentsImpl;
import org.jboss.deployers.plugins.structure.MetaDataMatchFilter;
import org.jboss.deployers.plugins.structure.SecurityActions;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.classloader.ClassLoaderFactory;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.deployers.spi.structure.DeploymentContextVisitor;
import org.jboss.deployers.spi.structure.DeploymentState;
import org.jboss.deployers.spi.structure.StructureDetermined;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDeploymentContext
implements DeploymentContext,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Logger log = Logger.getLogger(this.getClass());
    private String name;
    private StructureDetermined structureDetermined = StructureDetermined.NO;
    private DeploymentState state;
    private DeploymentUnit unit;
    private VirtualFile root;
    private VirtualFile metaDataLocation;
    private List<VirtualFile> classPath;
    private transient ClassLoader classLoader;
    private transient ClassLoaderFactory classLoaderFactory;
    private boolean candidate;
    private boolean deployed;
    private DeploymentContext parent;
    private Set<String> deploymentTypes = new CopyOnWriteArraySet<String>();
    private Set<DeploymentContext> children = new CopyOnWriteArraySet<DeploymentContext>();
    private Set<DeploymentContext> components = new CopyOnWriteArraySet<DeploymentContext>();
    private Attachments predeterminedManagedObjects = new AttachmentsImpl();
    private transient Attachments transientAttachments = new AttachmentsImpl();
    private transient Attachments transientManagedObjects = (Attachments)GeneratedAOPProxyFactory.createProxy((Object)new AttachmentsImpl(), Attachments.class);
    private Throwable problem;

    public static String getDeploymentName(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        try {
            URI uri = file.toURI();
            return uri.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("File does not have a valid uri: " + file, e);
        }
    }

    public AbstractDeploymentContext(String name) {
        this(name, false);
    }

    public AbstractDeploymentContext(String name, boolean candidate) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
        this.candidate = candidate;
    }

    public AbstractDeploymentContext(String name, DeploymentContext parent) {
        this(name, false, parent);
    }

    public AbstractDeploymentContext(String name, boolean candidate, DeploymentContext parent) {
        this(name, candidate);
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        this.setParent(parent);
    }

    public AbstractDeploymentContext(VirtualFile root) {
        this(AbstractDeploymentContext.getDeploymentName(root), false);
        this.setRoot(root);
    }

    public AbstractDeploymentContext(VirtualFile root, boolean candidate) {
        this(AbstractDeploymentContext.getDeploymentName(root), candidate);
        this.setRoot(root);
    }

    public AbstractDeploymentContext(VirtualFile root, boolean candidate, DeploymentContext parent) {
        this(AbstractDeploymentContext.getDeploymentName(root), candidate, parent);
        this.setRoot(root);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        VirtualFile unitVF = this.getRoot();
        return unitVF.getName();
    }

    @Override
    public String getRelativePath() {
        VirtualFile unitVF;
        VirtualFile topVF = unitVF = this.getRoot();
        for (DeploymentContext ctx = this.getParent(); ctx != null; ctx = ctx.getParent()) {
            topVF = ctx.getRoot();
        }
        String unitPath = unitVF.getPathName();
        String topPath = topVF.getPathName();
        return unitPath.substring(topPath.length());
    }

    @Override
    public Set<String> getTypes() {
        return this.deploymentTypes;
    }

    @Override
    public StructureDetermined getStructureDetermined() {
        return this.structureDetermined;
    }

    @Override
    public void setStructureDetermined(StructureDetermined determined) {
        if (determined == null) {
            throw new IllegalArgumentException("Null determined");
        }
        this.structureDetermined = determined;
    }

    @Override
    public boolean isCandidate() {
        return this.candidate;
    }

    @Override
    public DeploymentState getState() {
        return this.state;
    }

    @Override
    public void setState(DeploymentState state) {
        this.state = state;
    }

    @Override
    public DeploymentUnit getDeploymentUnit() {
        if (this.unit == null) {
            throw new IllegalStateException("Deployment unit has not been set");
        }
        return this.unit;
    }

    @Override
    public void setDeploymentUnit(DeploymentUnit unit) {
        this.unit = unit;
    }

    @Override
    public VirtualFile getRoot() {
        return this.root;
    }

    public void setRoot(VirtualFile root) {
        this.root = root;
    }

    @Override
    public void setMetaDataPath(String path) {
        if (path == null) {
            this.setMetaDataLocation(null);
        }
        try {
            this.setMetaDataLocation(this.root.findChild(path));
        }
        catch (IOException e) {
            this.log.debug((Object)("Meta data path does not exist: root=" + this.root.getPathName() + " path=" + path));
        }
    }

    @Override
    public VirtualFile getMetaDataLocation() {
        return this.metaDataLocation;
    }

    @Override
    public void setMetaDataLocation(VirtualFile location) {
        this.metaDataLocation = location;
        if (this.log.isTraceEnabled() && location != null) {
            this.log.trace((Object)("MetaData location for " + this.root.getPathName() + " is " + location.getPathName()));
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (classLoader != null) {
            this.log.trace((Object)("ClassLoader for " + this.name + " is " + classLoader));
        }
    }

    @Override
    public boolean createClassLoader(ClassLoaderFactory factory) throws DeploymentException {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        ClassLoader cl = this.getClassLoader();
        if (cl != null) {
            return false;
        }
        try {
            cl = factory.createClassLoader(this);
            if (cl != null) {
                this.setClassLoader(cl);
                this.classLoaderFactory = factory;
            }
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException("Error creating classloader for " + this.getName(), t);
        }
        return true;
    }

    @Override
    public void removeClassLoader() {
        if (this.classLoaderFactory == null) {
            return;
        }
        try {
            this.classLoaderFactory.removeClassLoader(this);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error removing classloader for " + this.getName()), t);
        }
        this.classLoaderFactory = null;
        this.setClassLoader(null);
    }

    @Override
    public List<VirtualFile> getClassPath() {
        return this.classPath;
    }

    @Override
    public void setClassPath(List<VirtualFile> paths) {
        this.classPath = paths;
        if (this.log.isTraceEnabled() && paths != null) {
            this.log.trace((Object)("ClassPath for " + this.root.getPathName() + " is " + VFSUtils.getPathsString(paths)));
        }
    }

    @Override
    public boolean isTopLevel() {
        return this.parent == null;
    }

    @Override
    public DeploymentContext getTopLevel() {
        DeploymentContext result = this;
        for (DeploymentContext parent = this.getParent(); parent != null; parent = parent.getParent()) {
            result = parent;
        }
        return result;
    }

    @Override
    public DeploymentContext getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DeploymentContext parent) {
        if (parent != null && this.parent != null) {
            throw new IllegalStateException("Context already has a parent " + this.getName());
        }
        this.parent = parent;
    }

    @Override
    public Set<DeploymentContext> getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    @Override
    public void addChild(DeploymentContext child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        this.children.add(child);
    }

    @Override
    public boolean removeChild(DeploymentContext child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        return this.children.remove(child);
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public Set<DeploymentContext> getComponents() {
        return Collections.unmodifiableSet(this.components);
    }

    @Override
    public void addComponent(DeploymentContext component) {
        if (component == null) {
            throw new IllegalArgumentException("Null component");
        }
        this.deployed();
        this.components.add(component);
        this.log.debug((Object)("Added component " + component.getName() + " to " + this.getName()));
    }

    @Override
    public boolean removeComponent(DeploymentContext component) {
        boolean result;
        if (component == null) {
            throw new IllegalArgumentException("Null component");
        }
        Set<DeploymentContext> componentComponents = component.getComponents();
        if (!componentComponents.isEmpty()) {
            this.log.warn((Object)("Removing component " + this.name + " which still has components " + componentComponents));
        }
        if (result = this.components.remove(component)) {
            this.log.debug((Object)("Removed component " + component.getName() + " from " + this.getName()));
        }
        return result;
    }

    @Override
    public void visit(DeploymentContextVisitor visitor) throws DeploymentException {
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.visit(this, visitor);
    }

    private void visit(DeploymentContext context, DeploymentContextVisitor visitor) throws DeploymentException {
        visitor.visit(context);
        try {
            Set<DeploymentContext> children = context.getChildren();
            if (children.isEmpty()) {
                return;
            }
            DeploymentContext[] childContexts = children.toArray(new DeploymentContext[children.size()]);
            for (int i = 0; i < childContexts.length; ++i) {
                if (childContexts[i] == null) {
                    throw new IllegalStateException("Null child context for " + context.getName() + " children=" + children);
                }
                try {
                    this.visit(childContexts[i], visitor);
                    continue;
                }
                catch (Throwable t) {
                    for (int j = i - 1; j >= 0; --j) {
                        this.visitError(childContexts[j], visitor, true);
                    }
                    throw DeploymentException.rethrowAsDeploymentException("Error visiting: " + childContexts[i].getName(), t);
                }
            }
        }
        catch (Throwable t) {
            this.visitError(context, visitor, false);
            throw DeploymentException.rethrowAsDeploymentException("Error visiting: " + context.getName(), t);
        }
    }

    private void visitError(DeploymentContext context, DeploymentContextVisitor visitor, boolean visitChildren) throws DeploymentException {
        if (visitChildren) {
            Set<DeploymentContext> children = context.getChildren();
            if (children.isEmpty()) {
                return;
            }
            for (DeploymentContext child : children) {
                try {
                    this.visitError(child, visitor, true);
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Error during visit error: " + child.getName()), t);
                }
            }
        }
        try {
            visitor.error(context);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during visit error: " + context.getName()), t);
        }
    }

    @Override
    public Attachments getPredeterminedManagedObjects() {
        return this.predeterminedManagedObjects;
    }

    @Override
    public void setPredeterminedManagedObjects(Attachments objects) {
        this.predeterminedManagedObjects.clear();
        ((AttachmentsImpl)this.predeterminedManagedObjects).setAttachments(objects.getAttachments());
    }

    @Override
    public Attachments getTransientManagedObjects() {
        return this.transientManagedObjects;
    }

    @Override
    public Attachments getTransientAttachments() {
        return this.transientAttachments;
    }

    @Override
    public Throwable getProblem() {
        return this.problem;
    }

    @Override
    public void setProblem(Throwable problem) {
        this.problem = problem;
    }

    @Override
    public VirtualFile getMetaDataFile(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        try {
            if (this.metaDataLocation == null) {
                String fileName;
                if (this.root != null && SecurityActions.isLeaf(this.root) && (fileName = this.root.getName()).equals(name)) {
                    return this.root;
                }
                return null;
            }
            VirtualFile result = this.metaDataLocation.findChild(name);
            if (result != null) {
                this.deployed();
            }
            return result;
        }
        catch (Exception e) {
            this.log.trace((Object)("Error retrieving meta data: " + name), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<VirtualFile> getMetaDataFiles(String name, String suffix) {
        if (name == null && suffix == null) {
            throw new IllegalArgumentException("Null name and suffix");
        }
        try {
            if (this.metaDataLocation == null) {
                if (this.root != null && this.root.isLeaf()) {
                    String fileName = this.root.getName();
                    if (name != null && fileName.equals(name)) {
                        return Collections.singletonList(this.root);
                    }
                    if (suffix != null && fileName.endsWith(suffix)) {
                        return Collections.singletonList(this.root);
                    }
                }
                return Collections.emptyList();
            }
            List result = this.metaDataLocation.getChildren((VirtualFileFilter)new MetaDataMatchFilter(name, suffix));
            if (result != null && !result.isEmpty()) {
                this.deployed();
            }
            return result;
        }
        catch (Exception e) {
            this.log.debug((Object)("Error retrieving meta data: name=" + name + " suffix=" + suffix), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean isDeployed() {
        return this.deployed;
    }

    @Override
    public void deployed() {
        this.deployed = true;
    }

    @Override
    public void reset() {
        if (this.structureDetermined != StructureDetermined.PREDETERMINED) {
            this.children.clear();
        } else {
            for (DeploymentContext child : this.children) {
                child.reset();
            }
        }
        this.components.clear();
        this.deployed = false;
        this.classLoader = null;
        this.transientManagedObjects.clear();
        this.transientAttachments.clear();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append('@');
        buffer.append(System.identityHashCode(this));
        buffer.append('{').append(this.name).append('}');
        return buffer.toString();
    }
}

