/*
 * JBoss, Home of Professional Open Source
 * Copyright (c) 2010, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.vfs.impl.vfs3;

import java.io.IOException;
import java.io.InputStream;

import org.jboss.ejb3.vfs.spi.VirtualFile;

/**
 * EJB3 VFS3 adapter VirtualFile implementation
 * 
 * @author <a href="cdewolf@redhat.com">Carlo de Wolf</a>
 */
public class VirtualFileWrapper implements VirtualFile
{
   /* VFS3 VirtualFile being wrapped */
   private org.jboss.vfs.VirtualFile delegate;

   /**
    * Constructs a new adapter VirutalFile with a concrete VFS3 VirtualFile instance
    * 
    * @param delegate
    */
   public VirtualFileWrapper(org.jboss.vfs.VirtualFile delegate)
   {
      this.delegate = delegate;
   }
   
   @Override
   public String getName()
   {
      return delegate.getName();
   }

   @Override
   public String getPathName()
   {
      return delegate.getPathName();
   }

   @Override
   public VirtualFile getParent() throws IOException
   {
      return new VirtualFileWrapper(delegate.getParent());
   }

   @Override
   public boolean isLeaf() throws IOException
   {
      return delegate.isFile();
   }

   @Override
   public InputStream openStream() throws IOException
   {
      return delegate.openStream();
   }

   public org.jboss.vfs.VirtualFile getWrapped()
   {
      return delegate;
   }
}
