/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.view.factory;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.ejb3.endpoint.Endpoint;
import org.jboss.ejb3.nointerface.impl.invocationhandler.NoInterfaceViewInvocationHandler;
import org.jboss.ejb3.proxy.javassist.JavassistProxyFactory;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;

public class StatefulNoInterfaceViewFacade {
    private static Logger logger = Logger.getLogger(StatefulNoInterfaceViewFacade.class);
    protected Class<?> beanClass;
    protected KernelControllerContext endpointContext;

    public StatefulNoInterfaceViewFacade(Class<?> beanClass, KernelControllerContext containerContext) {
        this.beanClass = beanClass;
        this.endpointContext = containerContext;
    }

    public Object createNoInterfaceView() throws Exception {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Changing the context " + this.endpointContext.getName() + " to state " + ControllerState.INSTALLED.getStateString() + " from current state " + this.endpointContext.getState().getStateString()));
            }
            this.endpointContext.getController().change((ControllerContext)this.endpointContext, ControllerState.INSTALLED);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not push the context " + this.endpointContext.getName() + " from its current state " + this.endpointContext.getState().getStateString() + " to INSTALLED", t);
        }
        Object target = this.endpointContext.getTarget();
        assert (target instanceof Endpoint) : "Unexpected object type found " + target + " - expected a " + Endpoint.class;
        Endpoint endpoint = (Endpoint)target;
        if (!endpoint.isSessionAware()) {
            throw new IllegalStateException("Endpoint " + endpoint + " is not session aware. Cannot be used for Stateful no-interface view(s)");
        }
        Serializable session = endpoint.getSessionFactory().createSession(null, null);
        logger.debug((Object)("Created session " + session + " for " + this.beanClass));
        NoInterfaceViewInvocationHandler invocationHandler = new NoInterfaceViewInvocationHandler(this.endpointContext, session);
        Object noInterfaceView = new JavassistProxyFactory().createProxy(new Class[]{this.beanClass}, (InvocationHandler)invocationHandler);
        return noInterfaceView;
    }
}

