/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.profiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jboss.dashboard.profiler.CodeBlockTrace;

public class StackTrace {
    protected long creationTimeMillis = System.currentTimeMillis();
    protected StackTraceElement[] stackTrace;
    protected CodeBlockTrace context;

    public StackTrace(StackTraceElement[] stackTrace, CodeBlockTrace context) {
        this.stackTrace = stackTrace;
        this.context = context;
    }

    public boolean equals(StackTrace other) {
        if (other.length() != this.length()) {
            return false;
        }
        for (int i = this.length() - 1; i >= 0; --i) {
            if (this.equals(this.stackTrace[i], other.stackTrace[i])) continue;
            return false;
        }
        return true;
    }

    public CodeBlockTrace getContext() {
        return this.context;
    }

    public void setContext(CodeBlockTrace context) {
        this.context = context;
    }

    public long getCreationTimeMillis() {
        return this.creationTimeMillis;
    }

    public int length() {
        if (this.stackTrace == null) {
            return 0;
        }
        return this.stackTrace.length;
    }

    public StackTraceElement get(int index) {
        if (index >= this.stackTrace.length) {
            return null;
        }
        return this.stackTrace[this.reverseIndex(index)];
    }

    public StackTraceElement last() {
        if (this.stackTrace.length == 0) {
            return null;
        }
        return this.stackTrace[0];
    }

    public StackTraceElement first() {
        if (this.stackTrace.length == 0) {
            return null;
        }
        return this.stackTrace[this.reverseIndex(0)];
    }

    public StackTraceElement[] from(int begin, int length) {
        StackTraceElement[] result = new StackTraceElement[length];
        System.arraycopy(this.stackTrace, this.stackTrace.length - begin - length, result, 0, length);
        return result;
    }

    protected int reverseIndex(int index) {
        return this.stackTrace.length - 1 - index;
    }

    protected StackTrace intersect(StackTrace other) {
        int length;
        int n = length = this.length() < other.length() ? this.length() : other.length();
        if (length == 0) {
            return null;
        }
        int commonLength = 0;
        boolean equals = true;
        for (int i = 0; i < length && equals; ++i) {
            StackTraceElement e2;
            StackTraceElement e1 = this.get(i);
            equals = this.equals(e1, e2 = other.get(i));
            if (!equals) continue;
            ++commonLength;
        }
        if (commonLength == 0) {
            return null;
        }
        StackTraceElement[] result = new StackTraceElement[commonLength];
        System.arraycopy(this.stackTrace, this.stackTrace.length - commonLength, result, 0, commonLength);
        return new StackTrace(result, null);
    }

    protected boolean equals(StackTraceElement e1, StackTraceElement e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1.getLineNumber() != e2.getLineNumber()) {
            return false;
        }
        if (!this.eq(e1.getMethodName(), e2.getMethodName())) {
            return false;
        }
        if (!this.eq(e1.getClassName(), e2.getClassName())) {
            return false;
        }
        return this.eq(e1.getFileName(), e2.getFileName());
    }

    protected boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public String printStackTrace() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(this.stackTrace[0]);
        for (int i = 1; i < this.stackTrace.length; ++i) {
            StackTraceElement trace = this.stackTrace[i];
            pw.println("\tat " + trace);
        }
        return sw.toString();
    }

    public static String printStackElement(StackTraceElement e, int maxLength) {
        String className = e.getClassName();
        if (className.length() > maxLength) {
            className = className.substring(className.length() - maxLength);
        }
        return className + "." + e.getMethodName() + (e.isNativeMethod() ? "(Native Method)" : (e.getFileName() != null && e.getLineNumber() >= 0 ? "(" + e.getFileName() + ":" + e.getLineNumber() + ")" : (e.getFileName() != null ? "(" + e.getFileName() + ")" : "(Unknown Source)")));
    }
}

