/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.text;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Locale;

public class DecimalFormatUtil {
    private DecimalFormatUtil() {
    }

    public static String doubleToStr(double origin, int decimals) {
        return DecimalFormatUtil.getFormat(decimals).format(new Double(origin));
    }

    public static String doubleToStr(Number origin, int decimals) {
        return DecimalFormatUtil.getFormat(decimals).format(origin);
    }

    public static Double strToDouble(String text, int decimals) {
        try {
            return new Double(DecimalFormatUtil.getFormat(decimals).parse(text).doubleValue());
        }
        catch (Exception except) {
            except.printStackTrace();
            return null;
        }
    }

    public static Float strToFloat(String text, int decimals) {
        try {
            return new Float(DecimalFormatUtil.getFormat(decimals).parse(text).floatValue());
        }
        catch (Exception except) {
            except.printStackTrace();
            return null;
        }
    }

    private static DecimalFormat getFormat(int decimals) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.getDefault());
        DecimalFormatSymbols dsym = df.getDecimalFormatSymbols();
        char decimalSeparator = dsym.getDecimalSeparator();
        StringBuffer pattern = new StringBuffer("0");
        pattern.append(decimalSeparator);
        for (int i = 0; i < decimals; ++i) {
            pattern.append("0");
        }
        DecimalFormat numberFormat = new DecimalFormat(pattern.toString());
        DecimalFormatSymbols decimalSymb = numberFormat.getDecimalFormatSymbols();
        numberFormat.setGroupingSize(50);
        decimalSymb.setDecimalSeparator(decimalSeparator);
        numberFormat.setDecimalFormatSymbols(decimalSymb);
        return numberFormat;
    }

    public static boolean isValidDouble(String value, int decimals) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.getDefault());
        DecimalFormatSymbols dsym = df.getDecimalFormatSymbols();
        char decSepar = dsym.getDecimalSeparator();
        if (value == null || value.trim().equals("")) {
            return true;
        }
        if ((value = value.trim()).indexOf(decSepar) != value.lastIndexOf(decSepar)) {
            return false;
        }
        if (value.indexOf(decSepar) != -1 && decimals != -1 && value.length() - value.indexOf(decSepar) - 1 > decimals) {
            return false;
        }
        DecimalFormat numberFormat = DecimalFormatUtil.getFormat(decimals);
        try {
            ParsePosition pos = new ParsePosition(0);
            Number number = numberFormat.parse(value, pos);
            return number != null && pos.getIndex() == value.length();
        }
        catch (Exception except) {
            return false;
        }
    }

    public static boolean isValidFloat(String value, int decimals) {
        return DecimalFormatUtil.isValidDouble(value, decimals);
    }
}

