/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class LazyList
extends ArrayList {
    protected List instanceList;
    protected boolean discardDuplicates;
    protected int fetchSize;

    public LazyList(boolean discardDuplicates) {
        this.discardDuplicates = discardDuplicates;
        this.fetchSize = 10;
        this.instanceList = new ArrayList();
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public LazyList(Collection c, boolean discardDuplicates) {
        this(discardDuplicates);
        this.addAll(c);
    }

    public abstract boolean isInstance(Object var1);

    public abstract String getInstanceId(Object var1);

    public abstract List loadInstances(String[] var1);

    public abstract LazyList createLazyList(Collection var1);

    public String[] getIds() {
        String[] ids = new String[this.size()];
        this.toArray(ids);
        return ids;
    }

    public String getId(int index) {
        return (String)super.get(index);
    }

    public boolean removeId(String id) {
        int index;
        boolean modified = true;
        while ((index = this.indexOf(id)) != -1) {
            this.instanceList.remove(index);
            super.remove(index);
            modified = true;
        }
        return modified;
    }

    @Override
    public Object get(int index) {
        Object instance = this.instanceList.get(index);
        if (instance != null) {
            return instance;
        }
        int fetchFrom = index;
        int fetchTo = fetchFrom + this.fetchSize;
        if (fetchTo > this.size()) {
            fetchTo = this.size();
        }
        LazyList ids = (LazyList)this.subList(fetchFrom, fetchTo);
        List loaded = this.loadInstances(ids.getIds());
        for (int i = fetchFrom; i < fetchTo; ++i) {
            this.instanceList.set(i, loaded.get(i - fetchFrom));
        }
        return this.instanceList.get(index);
    }

    @Override
    public boolean remove(Object o) {
        if (this.isInstance(o)) {
            return this.removeId(this.getInstanceId(o));
        }
        return this.removeId(o.toString());
    }

    @Override
    public boolean contains(Object o) {
        if (this.isInstance(o)) {
            return super.contains(this.getInstanceId(o));
        }
        return super.contains(o.toString());
    }

    @Override
    public int indexOf(Object elem) {
        if (this.isInstance(elem)) {
            return super.indexOf(this.getInstanceId(elem));
        }
        return super.indexOf(elem.toString());
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (this.isInstance(elem)) {
            return super.lastIndexOf(this.getInstanceId(elem));
        }
        return super.lastIndexOf(elem.toString());
    }

    @Override
    public boolean add(Object o) {
        if (this.discardDuplicates && this.contains(o)) {
            return false;
        }
        if (this.isInstance(o)) {
            this.instanceList.add(o);
            return super.add(this.getInstanceId(o));
        }
        this.instanceList.add(null);
        if (o == null) {
            return super.add(o);
        }
        return super.add(o.toString());
    }

    @Override
    public void add(int index, Object o) {
        if (this.discardDuplicates && this.contains(o)) {
            return;
        }
        if (this.isInstance(o)) {
            this.instanceList.add(index, o);
            super.add(index, this.getInstanceId(o));
        }
        this.instanceList.add(index, null);
        if (o == null) {
            super.add(index, null);
        } else {
            super.add(index, o.toString());
        }
    }

    @Override
    public boolean addAll(Collection c) {
        boolean modified = false;
        Object[] elements = c.toArray();
        for (int i = 0; i < elements.length; ++i) {
            modified = this.add(elements[i]);
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean modified = false;
        Object[] elements = c.toArray();
        for (int i = 0; i < elements.length; ++i) {
            modified = this.remove(elements[i]);
        }
        return modified;
    }

    @Override
    public Object set(int index, Object element) {
        if (this.isInstance(element)) {
            this.instanceList.set(index, element);
            return super.set(index, this.getInstanceId(element));
        }
        this.instanceList.set(index, null);
        return super.set(index, element.toString());
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = fromIndex; i < toIndex; ++i) {
            ids.add(this.getId(i));
        }
        return this.createLazyList(ids);
    }
}

