/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard;

import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.dashboard.LocaleManager;
import org.jboss.dashboard.annotation.StartableProcessor;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.commons.io.DirectoriesScanner;

@ApplicationScoped
public class Application {
    @Inject
    protected StartableProcessor startupProcessor;
    @Inject
    protected LocaleManager localeManager;
    protected String libDirectory = null;
    protected String baseCfgDirectory = null;
    protected String baseAppDirectory = null;
    protected transient Set<File> jarFiles = null;

    public static Application lookup() {
        return CDIBeanLocator.getBeanByType(Application.class);
    }

    public String getBaseAppDirectory() {
        return this.baseAppDirectory;
    }

    public String getBaseCfgDirectory() {
        return this.baseCfgDirectory;
    }

    public void setBaseAppDirectory(String newBaseAppDirectory) {
        this.baseAppDirectory = newBaseAppDirectory;
    }

    public void setBaseCfgDirectory(String newBaseCfgDirectory) {
        this.baseCfgDirectory = newBaseCfgDirectory;
    }

    public String getLibDirectory() {
        return this.libDirectory;
    }

    public void setLibDirectory(String libDirectory) {
        this.libDirectory = libDirectory;
    }

    public void start() throws Exception {
        this.startupProcessor.wakeUpStartableBeans();
    }

    public Set<File> getJarFiles() {
        File[] jars;
        if (this.jarFiles != null) {
            return this.jarFiles;
        }
        this.jarFiles = new HashSet<File>();
        File libDir = new File(this.libDirectory);
        for (File jar : jars = new DirectoriesScanner("jar").findFiles(libDir)) {
            String jarName = jar.getName();
            if (!jarName.startsWith("dashboard-")) continue;
            this.jarFiles.add(jar);
        }
        return this.jarFiles;
    }

    public String getCopyright() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        String currentYear = Integer.toString(cal.get(1));
        ResourceBundle i18n = this.localeManager.getBundle("org.jboss.dashboard.messages", LocaleManager.currentLocale());
        return MessageFormat.format(i18n.getString("config.copyright"), currentYear);
    }
}

