/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.mc.server;

import java.io.InputStream;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import java.util.Map;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.bootstrap.api.config.InvalidConfigurationException;
import org.jboss.bootstrap.api.config.ServerConfig;
import org.jboss.bootstrap.api.descriptor.BootstrapDescriptor;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.api.server.Server;
import org.jboss.bootstrap.impl.base.server.AbstractServer;
import org.jboss.bootstrap.impl.mc.deployer.TempBasicXMLDeployer;
import org.jboss.bootstrap.impl.mc.server.MCVersion;
import org.jboss.bootstrap.impl.mc.server.SecurityActions;
import org.jboss.bootstrap.spi.mc.server.MCBasedServerProvider;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.managed.api.annotation.ManagementProperty;

public abstract class AbstractMCServerBase<K extends Server<K, T>, T extends ServerConfig<T>>
extends AbstractServer<K, T>
implements MCBasedServerProvider<K, T> {
    private static final Logger log = Logger.getLogger(AbstractMCServerBase.class);
    private BasicBootstrap bootstrap;
    private TempBasicXMLDeployer kernelDeployer;
    private final MCVersion version = MCVersion.getInstance();

    protected AbstractMCServerBase(Class<K> actualClass) {
        this(actualClass, null);
    }

    protected AbstractMCServerBase(Class<K> actualClass, T config) {
        super(actualClass, config);
    }

    @ManagementProperty(name="config")
    public final T getConfiguration() {
        return (T)super.getConfiguration();
    }

    @ManagementProperty(ignored=true)
    public Kernel getKernel() {
        return this.getBootstrap().getKernel();
    }

    @ManagementProperty(ignored=true)
    public Map<String, KernelDeployment> getDeployments() {
        Map<String, KernelDeployment> deployments = null;
        if (this.kernelDeployer != null) {
            deployments = this.kernelDeployer.getDeployments();
        }
        return deployments;
    }

    protected void doShutdown() throws Exception {
        this.shutdownKernelAndDeployer();
    }

    protected void shutdownKernelAndDeployer() throws Exception {
        try {
            if (this.kernelDeployer != null) {
                this.kernelDeployer.shutdown();
                this.kernelDeployer = null;
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Error stopping xml deployer", t);
        }
        try {
            Kernel tempKernelReference = null;
            if (this.bootstrap != null) {
                tempKernelReference = this.bootstrap.getKernel();
            }
            this.bootstrap = null;
            if (tempKernelReference != null) {
                KernelController controller = tempKernelReference.getController();
                controller.shutdown();
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error stopping " + KernelController.class.getName()), (Throwable)e);
        }
    }

    protected void doInitialize() throws IllegalStateException, InvalidConfigurationException, LifecycleEventException {
        ClassLoader cl = SecurityActions.getThreadContextClassLoader();
        this.setupURLStreamHandlerFactory("org.jboss.net.protocol.URLStreamHandlerFactory", cl);
        this.initializeBootstrap();
        super.doInitialize();
    }

    protected void setupURLStreamHandlerFactory(String className, ClassLoader cl) {
        try {
            Class<?> clazz = cl.loadClass(className);
            URLStreamHandlerFactory ushf = (URLStreamHandlerFactory)clazz.newInstance();
            SecurityActions.setURLStreamHandlerFactory(ushf);
        }
        catch (Throwable t) {
            log.error((Object)("Cannot set URLStreamHandlerFactory: " + t));
        }
    }

    public void start() throws IllegalStateException, Exception {
        BasicBootstrap bootstrap = this.getBootstrap();
        if (bootstrap == null) {
            log.trace((Object)"Re-initializing the underlying bootstrap...");
            this.initializeBootstrap();
            log.debug((Object)"Underlying MC Bootstrap re-initialized.");
        }
        super.start();
    }

    protected void doStart() throws Exception {
        this.bootstrapMcAndDescriptors();
    }

    protected void bootstrapMcAndDescriptors() throws Exception {
        String mcServerBindName = "JBossServer";
        Kernel kernel = this.getKernel();
        if (kernel == null) {
            throw new IllegalStateException("Server cannot be started without the presence of an underlying " + Kernel.class.getName());
        }
        KernelController controller = kernel.getController();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"JBossServer", (String)((Object)((Object)this)).getClass().getName());
        builder.addMethodInstallCallback("addBootstrap");
        builder.addMethodUninstallCallback("removeBootstrap");
        builder.ignoreStart();
        builder.ignoreStop();
        try {
            log.debugf("Installing %s into MC under key: %s", new Object[]{this, "JBossServer"});
            controller.install(builder.getBeanMetaData(), (Object)this);
        }
        catch (Throwable t) {
            throw new Exception("Error in installing JBossServer during startup", t);
        }
        T config = this.getConfiguration();
        List bootstrapDescriptors = config.getBootstrapDescriptors();
        if (bootstrapDescriptors.isEmpty()) {
            log.warn((Object)"No bootstrap descriptors defined");
        }
        log.debugf("Starting Microcontainer, Bootstrap Descriptors: %s", new Object[]{bootstrapDescriptors});
        this.kernelDeployer = new TempBasicXMLDeployer(kernel);
        try {
            for (BootstrapDescriptor bootstrapDescriptor : bootstrapDescriptors) {
                String bootstrapDescriptorName = bootstrapDescriptor.getName();
                InputStream bootstrapDescriptorContent = bootstrapDescriptor.getContent();
                log.debugf("Deploying bootstrap descriptor: %s", new Object[]{bootstrapDescriptorName});
                this.kernelDeployer.deploy(bootstrapDescriptorName, bootstrapDescriptorContent);
            }
            this.kernelDeployer.validate();
        }
        catch (Throwable t) {
            try {
                this.kernelDeployer.shutdown();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw new Exception("Encountered exception in server startup", t);
        }
    }

    protected final BasicBootstrap getBootstrap() {
        return this.bootstrap;
    }

    private void initializeBootstrap() {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        this.bootstrap = bootstrap;
        log.tracef("Created and run: %s", new Object[]{bootstrap});
    }

    public String toString() {
        return "MCServer [" + this.version.toString() + "]";
    }
}

