/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.api.mc.server;

import org.jboss.bootstrap.api.factory.ServerFactory;
import org.jboss.bootstrap.api.mc.config.MCServerConfig;
import org.jboss.bootstrap.api.mc.config.MCServerConfigFactory;
import org.jboss.bootstrap.api.mc.server.MCServer;
import org.jboss.bootstrap.api.mc.server.SecurityActions;
import org.jboss.bootstrap.api.server.Server;

public class MCServerFactory {
    public static final String DEFAULT_MC_SERVER_IMPL_CLASS_NAME = "org.jboss.bootstrap.impl.mc.server.MCServerImpl";

    private MCServerFactory() {
    }

    public static MCServer createServer() {
        return MCServerFactory.createServer(SecurityActions.getTccl());
    }

    public static MCServer createServerWithDefaultConfiguration() {
        return MCServerFactory.createServerWithDefaultConfiguration(SecurityActions.getTccl());
    }

    public static MCServer createServer(ClassLoader cl) throws IllegalArgumentException {
        try {
            return MCServerFactory.createServer(DEFAULT_MC_SERVER_IMPL_CLASS_NAME, cl);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in creating the Server", e);
        }
    }

    public static MCServer createServerWithDefaultConfiguration(ClassLoader cl) throws IllegalArgumentException {
        try {
            return MCServerFactory.createServerWithDefaultConfiguration(DEFAULT_MC_SERVER_IMPL_CLASS_NAME, cl);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in creating the Server", e);
        }
    }

    public static MCServer createServer(String implClassName, ClassLoader cl) throws IllegalArgumentException, Exception {
        if (cl == null) {
            throw new IllegalArgumentException(ClassLoader.class.getSimpleName() + " is required.");
        }
        if (implClassName == null || implClassName.length() == 0) {
            throw new IllegalArgumentException("Implementation class name must be specified");
        }
        Server server = ServerFactory.createServer((String)implClassName, (ClassLoader)cl);
        MCServer mcServer = null;
        try {
            mcServer = (MCServer)MCServer.class.cast(server);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Specified server implementation class, " + implClassName + " must be assignable to " + MCServer.class.getName());
        }
        MCServerConfig config = MCServerConfigFactory.createServerConfig(cl);
        mcServer.setConfiguration(config);
        return mcServer;
    }

    public static MCServer createServerWithDefaultConfiguration(String implClassName, ClassLoader cl) throws IllegalArgumentException, Exception {
        return MCServerFactory.applyDefaultConfiguration(MCServerFactory.createServer(implClassName, cl), cl);
    }

    private static MCServer applyDefaultConfiguration(MCServer server, ClassLoader cl) {
        MCServerConfig config = MCServerConfigFactory.createServerConfig(cl);
        server.setConfiguration(config);
        return server;
    }
}

