/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.auto;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.jboss.auto.CodeGenerator;
import org.jboss.auto.ProcessingException;

@SupportedOptions(value={"debug"})
public abstract class AbstractProcessor
extends javax.annotation.processing.AbstractProcessor {
    private final CodeGenerator generator;
    private int round;
    protected Types typeUtils;
    protected Elements elementUtils;
    protected Filer filer;
    protected Messager messager;

    protected AbstractProcessor(Class resourceLoaderClass, String templates) {
        this.generator = new CodeGenerator(resourceLoaderClass, templates);
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>(Collections.singleton("debug"));
    }

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.round = 0;
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.afterInit(processingEnv);
    }

    protected void afterInit(ProcessingEnvironment processingEnv) {
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean result;
        if (!roundEnv.processingOver()) {
            try {
                result = this.onProcess(annotations, roundEnv);
            }
            catch (ProcessingException e) {
                this.onError(e);
                result = true;
            }
        } else {
            try {
                result = this.onLastRound(roundEnv);
            }
            catch (ProcessingException e) {
                this.onError(e);
                result = true;
            }
        }
        ++this.round;
        return result;
    }

    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return true;
    }

    protected boolean onLastRound(RoundEnvironment roundEnv) {
        return true;
    }

    protected void onError(ProcessingException e) {
        this.error(e);
    }

    protected int round() {
        return this.round;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    protected void code(String template, String packageName, String className, Supplier<Map<String, Object>> context) {
        this.writeCode(packageName, className, this.generator.generate(template, context));
    }

    protected void resource(String template, String packageName, String resourceName, Supplier<Map<String, Object>> context) {
        this.writeResource(packageName, resourceName, this.generator.generate(template, context));
    }

    protected void writeCode(String packageName, String className, StringBuffer code) {
        try {
            JavaFileObject jfo = this.filer.createSourceFile(packageName + "." + className, new Element[0]);
            Writer w = jfo.openWriter();
            BufferedWriter bw = new BufferedWriter(w);
            bw.append(code);
            bw.close();
            w.close();
        }
        catch (IOException e) {
            throw new ProcessingException(String.format("Error writing code for %s.%s: %s", packageName, className, e.getMessage()));
        }
    }

    protected void writeResource(String packageName, String resourceName, StringBuffer content) {
        try {
            FileObject mf = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, packageName, resourceName, new Element[0]);
            Writer w = mf.openWriter();
            BufferedWriter bw = new BufferedWriter(w);
            bw.append(content);
            bw.close();
            w.close();
        }
        catch (IOException e) {
            throw new ProcessingException(String.format("Error writing content for %s.%s: %s", packageName, resourceName, e.getMessage()));
        }
    }

    public void debug(String msg, Object ... args) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
        }
    }

    public void info(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    public void warning(Element element, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args), element);
    }

    public void error(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    public void error(Element element, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), element);
    }

    public void error(ProcessingException processingException) {
        if (processingException.getElement() != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, processingException.getMessage(), processingException.getElement());
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, processingException.getMessage());
        }
    }
}

