/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.File;
import org.jboss.as.process.ProcessMessages;

public class DefaultJvmUtils {
    public static String getCurrentJvmHome() {
        return System.getProperty("java.home");
    }

    public static String findJavaExecutable(String javaHome) {
        File file = new File(javaHome);
        if (!file.exists()) {
            throw ProcessMessages.MESSAGES.invalidJavaHome(file.getAbsolutePath());
        }
        if (!(file = new File(file, "bin")).exists()) {
            throw ProcessMessages.MESSAGES.invalidJavaHomeBin(file.getAbsolutePath(), file.getParentFile().getAbsolutePath());
        }
        File java = new File(file, "java");
        if (!java.exists()) {
            java = new File(file, "java.exe");
        }
        if (!java.exists()) {
            throw ProcessMessages.MESSAGES.cannotFindJavaExe(file.getAbsolutePath());
        }
        return java.getAbsolutePath();
    }
}

