/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.IOException;
import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandler;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.mgmt.HostControllerRegistrationHandler;
import org.jboss.as.host.controller.mgmt.MasterDomainControllerOperationHandlerImpl;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementPongRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.threads.JBossThreadFactory;

public class MasterDomainControllerOperationHandlerService
extends AbstractModelControllerOperationHandlerFactoryService {
    public static final ServiceName SERVICE_NAME = DomainController.SERVICE_NAME.append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
    private final DomainController domainController;
    private final HostControllerRegistrationHandler.OperationExecutor operationExecutor;
    private final ManagementPongRequestHandler pongRequestHandler = new ManagementPongRequestHandler();
    private final ThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("slave-request-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
    private volatile ExecutorService slaveRequestExecutor;

    public MasterDomainControllerOperationHandlerService(DomainController domainController, HostControllerRegistrationHandler.OperationExecutor operationExecutor) {
        this.domainController = domainController;
        this.operationExecutor = operationExecutor;
    }

    protected String getThreadGroupName() {
        return "domain-mgmt-handler-thread";
    }

    public synchronized void start(StartContext context) throws StartException {
        this.pongRequestHandler.resetConnectionId();
        this.slaveRequestExecutor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactory);
        super.start(context);
    }

    public synchronized void stop(StopContext context) {
        this.slaveRequestExecutor.shutdown();
        super.stop(context);
    }

    public HandleableCloseable.Key startReceiving(Channel channel) {
        final ManagementChannelHandler handler = new ManagementChannelHandler(ManagementClientChannelStrategy.create((Channel)channel), this.getExecutor());
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new HostControllerRegistrationHandler(handler, this.domainController, this.operationExecutor, this.slaveRequestExecutor));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new ModelControllerClientOperationHandler(this.getController(), (ManagementChannelAssociation)handler));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new MasterDomainControllerOperationHandlerImpl(this.domainController, this.slaveRequestExecutor));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)this.pongRequestHandler);
        HandleableCloseable.Key key = channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleClose(Channel closed, IOException exception) {
                handler.shutdown();
                boolean interrupted = false;
                try {
                    if (!handler.awaitCompletion((long)CHANNEL_SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS)) {
                        HostControllerLogger.ROOT_LOGGER.gracefulManagementChannelHandlerShutdownTimedOut(CHANNEL_SHUTDOWN_TIMEOUT);
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    HostControllerLogger.ROOT_LOGGER.serviceShutdownIncomplete(e);
                }
                catch (Exception e) {
                    HostControllerLogger.ROOT_LOGGER.serviceShutdownIncomplete(e);
                }
                finally {
                    handler.shutdownNow();
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        channel.receiveMessage(handler.getReceiver());
        return key;
    }
}

