/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.BootContext;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.VaultReader;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.controller.operations.coordination.PrepareStepHandler;
import org.jboss.as.domain.controller.resources.DomainRootDefinition;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.MasterDomainControllerClient;
import org.jboss.as.host.controller.ProcessControllerConnectionService;
import org.jboss.as.host.controller.RemoteDomainConnectionService;
import org.jboss.as.host.controller.SecurityActions;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.ServerInventoryCallbackService;
import org.jboss.as.host.controller.ServerInventoryService;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.mgmt.HostControllerRegistrationHandler;
import org.jboss.as.host.controller.mgmt.MasterDomainControllerOperationHandlerService;
import org.jboss.as.host.controller.mgmt.ServerToHostOperationHandlerFactoryService;
import org.jboss.as.host.controller.mgmt.ServerToHostProtocolHandler;
import org.jboss.as.host.controller.mgmt.SlaveHostPinger;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.repository.LocalFileRepository;
import org.jboss.as.server.BootstrapListener;
import org.jboss.as.server.RuntimeExpressionResolver;
import org.jboss.as.server.controller.resources.VersionModelInitializer;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;

public class DomainModelControllerService
extends AbstractControllerService
implements DomainController,
HostModelUtil.HostModelRegistrar {
    public static final ServiceName SERVICE_NAME = HostControllerService.HC_SERVICE_NAME.append(new String[]{"model", "controller"});
    private static final int PINGER_POOL_SIZE;
    private volatile HostControllerConfigurationPersister hostControllerConfigurationPersister;
    private final HostControllerEnvironment environment;
    private final HostRunningModeControl runningModeControl;
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final HostFileRepository localFileRepository;
    private final RemoteDomainConnectionService.RemoteFileRepository remoteFileRepository;
    private final InjectedValue<ProcessControllerConnectionService> injectedProcessControllerConnection = new InjectedValue();
    private final ConcurrentMap<String, ProxyController> hostProxies;
    private final ConcurrentMap<String, HostRegistration> hostRegistrationMap = new ConcurrentHashMap<String, HostRegistration>();
    private final Map<String, ProxyController> serverProxies;
    private final PrepareStepHandler prepareStepHandler;
    private final BootstrapListener bootstrapListener;
    private ManagementResourceRegistration modelNodeRegistration;
    private final AbstractVaultReader vaultReader;
    private final ContentRepository contentRepository;
    private final ExtensionRegistry extensionRegistry;
    private final ControlledProcessState processState;
    private final IgnoredDomainResourceRegistry ignoredRegistry;
    private final PathManagerService pathManager;
    private final ExpressionResolver expressionResolver;
    private final DelegatingResourceDefinition rootResourceDefinition;
    private volatile ServerInventory serverInventory;
    private volatile ExecutorService proxyExecutor;
    private volatile ScheduledExecutorService pingScheduler;

    public static ServiceController<ModelController> addService(ServiceTarget serviceTarget, HostControllerEnvironment environment, HostRunningModeControl runningModeControl, ControlledProcessState processState, BootstrapListener bootstrapListener, PathManagerService pathManager) {
        ConcurrentHashMap<String, ProxyController> hostProxies = new ConcurrentHashMap<String, ProxyController>();
        ConcurrentHashMap<String, ProxyController> serverProxies = new ConcurrentHashMap<String, ProxyController>();
        LocalHostControllerInfoImpl hostControllerInfo = new LocalHostControllerInfoImpl(processState, environment);
        AbstractVaultReader vaultReader = DomainModelControllerService.service(AbstractVaultReader.class);
        HostControllerLogger.ROOT_LOGGER.debugf("Using VaultReader %s", vaultReader);
        ContentRepository contentRepository = ContentRepository.Factory.create((File)environment.getDomainContentDir());
        IgnoredDomainResourceRegistry ignoredRegistry = new IgnoredDomainResourceRegistry(hostControllerInfo);
        PrepareStepHandler prepareStepHandler = new PrepareStepHandler(hostControllerInfo, contentRepository, hostProxies, serverProxies, ignoredRegistry);
        RuntimeExpressionResolver expressionResolver = new RuntimeExpressionResolver((VaultReader)vaultReader);
        DomainModelControllerService service = new DomainModelControllerService(environment, runningModeControl, processState, hostControllerInfo, contentRepository, hostProxies, serverProxies, prepareStepHandler, vaultReader, ignoredRegistry, bootstrapListener, pathManager, (ExpressionResolver)expressionResolver, new DelegatingResourceDefinition());
        return serviceTarget.addService(SERVICE_NAME, (Service)service).addDependency(HostControllerService.HC_EXECUTOR_SERVICE_NAME, ExecutorService.class, (Injector)service.getExecutorServiceInjector()).addDependency(ProcessControllerConnectionService.SERVICE_NAME, ProcessControllerConnectionService.class, service.injectedProcessControllerConnection).addDependency(PathManagerService.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private DomainModelControllerService(HostControllerEnvironment environment, HostRunningModeControl runningModeControl, ControlledProcessState processState, LocalHostControllerInfoImpl hostControllerInfo, ContentRepository contentRepository, ConcurrentMap<String, ProxyController> hostProxies, Map<String, ProxyController> serverProxies, PrepareStepHandler prepareStepHandler, AbstractVaultReader vaultReader, IgnoredDomainResourceRegistry ignoredRegistry, BootstrapListener bootstrapListener, PathManagerService pathManager, ExpressionResolver expressionResolver, DelegatingResourceDefinition rootResourceDefinition) {
        super(ProcessType.HOST_CONTROLLER, (RunningModeControl)runningModeControl, null, processState, (ResourceDefinition)rootResourceDefinition, (OperationStepHandler)prepareStepHandler, (ExpressionResolver)new RuntimeExpressionResolver((VaultReader)vaultReader));
        this.environment = environment;
        this.runningModeControl = runningModeControl;
        this.processState = processState;
        this.hostControllerInfo = hostControllerInfo;
        this.localFileRepository = new LocalFileRepository(environment.getDomainBaseDir(), environment.getDomainContentDir(), environment.getDomainConfigurationDir());
        this.remoteFileRepository = new RemoteDomainConnectionService.RemoteFileRepository(this.localFileRepository);
        this.contentRepository = contentRepository;
        this.hostProxies = hostProxies;
        this.serverProxies = serverProxies;
        this.prepareStepHandler = prepareStepHandler;
        this.vaultReader = vaultReader;
        this.ignoredRegistry = ignoredRegistry;
        this.bootstrapListener = bootstrapListener;
        this.extensionRegistry = new ExtensionRegistry(ProcessType.HOST_CONTROLLER, (RunningModeControl)runningModeControl);
        this.pathManager = pathManager;
        this.expressionResolver = expressionResolver;
        this.rootResourceDefinition = rootResourceDefinition;
    }

    @Override
    public RunningMode getCurrentRunningMode() {
        return this.runningModeControl.getRunningMode();
    }

    @Override
    public LocalHostControllerInfo getLocalHostInfo() {
        return this.hostControllerInfo;
    }

    @Override
    public void registerRemoteHost(String hostName, ManagementChannelHandler handler, Transformers transformers, Long remoteConnectionId) throws SlaveRegistrationException {
        if (!this.hostControllerInfo.isMasterDomainController()) {
            throw SlaveRegistrationException.forHostIsNotMaster();
        }
        if (this.runningModeControl.getRunningMode() == RunningMode.ADMIN_ONLY) {
            throw SlaveRegistrationException.forMasterInAdminOnlyMode(this.runningModeControl.getRunningMode());
        }
        PathElement pe = PathElement.pathElement((String)"host", (String)hostName);
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{pe});
        ProxyController existingController = this.modelNodeRegistration.getProxyController(addr);
        if (existingController != null || this.hostControllerInfo.getLocalHostName().equals(pe.getValue())) {
            throw SlaveRegistrationException.forHostAlreadyExists(pe.getValue());
        }
        SlaveHostPinger pinger = remoteConnectionId == null ? null : new SlaveHostPinger(hostName, handler, this.pingScheduler, remoteConnectionId);
        this.hostRegistrationMap.put(hostName, new HostRegistration(remoteConnectionId, handler, pinger));
        TransformingProxyController hostControllerClient = TransformingProxyController.Factory.create((ManagementChannelHandler)handler, (Transformers)transformers, (PathAddress)addr, (ProxyOperationAddressTranslator)ProxyOperationAddressTranslator.HOST);
        this.modelNodeRegistration.registerProxyController(pe, (ProxyController)hostControllerClient);
        this.hostProxies.put(hostName, (ProxyController)hostControllerClient);
    }

    @Override
    public boolean isHostRegistered(String id) {
        return this.hostControllerInfo.getLocalHostName().equals(id) || this.hostRegistrationMap.containsKey(id);
    }

    @Override
    public void unregisterRemoteHost(String id, Long remoteConnectionId) {
        HostRegistration hostRegistration = (HostRegistration)this.hostRegistrationMap.get(id);
        if (hostRegistration != null && (remoteConnectionId == null || remoteConnectionId.equals(hostRegistration.remoteConnectionId)) && this.hostRegistrationMap.remove(id, hostRegistration)) {
            if (hostRegistration.pinger != null) {
                hostRegistration.pinger.cancel();
            }
            this.hostProxies.remove(id);
            this.modelNodeRegistration.unregisterProxyController(PathElement.pathElement((String)"host", (String)id));
            HostControllerLogger.DOMAIN_LOGGER.unregisteredRemoteSlaveHost(id);
        }
    }

    @Override
    public void pingRemoteHost(String id) {
        HostRegistration reg = (HostRegistration)this.hostRegistrationMap.get(id);
        if (reg != null && reg.pinger != null && !reg.pinger.isCancelled()) {
            reg.pinger.schedulePing(10000L, 0L);
        }
    }

    @Override
    public void registerRunningServer(ProxyController serverControllerClient) {
        PathAddress pa = serverControllerClient.getProxyNodeAddress();
        PathElement pe = pa.getElement(1);
        if (this.modelNodeRegistration.getProxyController(pa) != null) {
            throw HostControllerMessages.MESSAGES.serverNameAlreadyRegistered(pe.getValue());
        }
        HostControllerLogger.ROOT_LOGGER.registeringServer(pe.getValue());
        ManagementResourceRegistration hostRegistration = this.modelNodeRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.hostControllerInfo.getLocalHostName())}));
        hostRegistration.registerProxyController(pe, serverControllerClient);
        this.serverProxies.put(pe.getValue(), serverControllerClient);
    }

    @Override
    public void unregisterRunningServer(String serverName) {
        PathAddress pa = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.hostControllerInfo.getLocalHostName())});
        PathElement pe = PathElement.pathElement((String)"server", (String)serverName);
        HostControllerLogger.ROOT_LOGGER.unregisteringServer(serverName);
        ManagementResourceRegistration hostRegistration = this.modelNodeRegistration.getSubModel(pa);
        hostRegistration.unregisterProxyController(pe);
        this.serverProxies.remove(serverName);
    }

    @Override
    public ModelNode getProfileOperations(String profileName) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("describe");
        operation.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"profile", (String)profileName)}).toModelNode());
        ModelNode rsp = this.getValue().execute(operation, null, null, null);
        if (!rsp.hasDefined("outcome") || !"success".equals(rsp.get("outcome").asString())) {
            ModelNode msgNode = rsp.get("failure-description");
            String msg = msgNode.isDefined() ? msgNode.toString() : HostControllerMessages.MESSAGES.failedProfileOperationsRetrieval();
            throw new RuntimeException(msg);
        }
        return rsp.require("result");
    }

    @Override
    public HostFileRepository getLocalFileRepository() {
        return this.localFileRepository;
    }

    @Override
    public HostFileRepository getRemoteFileRepository() {
        if (this.hostControllerInfo.isMasterDomainController()) {
            throw HostControllerMessages.MESSAGES.cannotAccessRemoteFileRepository();
        }
        return this.remoteFileRepository;
    }

    public void start(StartContext context) throws StartException {
        ExecutorService executorService = (ExecutorService)this.getExecutorServiceInjector().getValue();
        this.hostControllerConfigurationPersister = new HostControllerConfigurationPersister(this.environment, this.hostControllerInfo, executorService, this.extensionRegistry);
        this.setConfigurationPersister((ConfigurationPersister)this.hostControllerConfigurationPersister);
        this.prepareStepHandler.setExecutorService(executorService);
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("proxy-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
        this.proxyExecutor = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
        JBossThreadFactory pingerThreadFactory = new JBossThreadFactory(new ThreadGroup("proxy-pinger-threads"), Boolean.TRUE, null, "%G - %t", null, null, AccessController.getContext());
        this.pingScheduler = Executors.newScheduledThreadPool(PINGER_POOL_SIZE, (ThreadFactory)pingerThreadFactory);
        super.start(context);
    }

    protected void initModel(Resource rootResource, ManagementResourceRegistration rootRegistration) {
        HostModelUtil.createRootRegistry(rootRegistration, this.environment, this.ignoredRegistry, this, this.processType);
        VersionModelInitializer.registerRootResource((Resource)rootResource, this.environment != null ? this.environment.getProductConfig() : null);
        this.modelNodeRegistration = rootRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void boot(BootContext context) throws ConfigurationPersistenceException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        boolean ok = false;
        boolean reachedServers = false;
        try {
            ServerInventoryCallbackService.install(serviceTarget);
            List<ModelNode> hostBootOps = this.hostControllerConfigurationPersister.load();
            ModelNode addHostOp = hostBootOps.remove(0);
            ok = this.boot(Collections.singletonList(addHostOp), true);
            ok = ok && this.boot(hostBootOps, true);
            RunningMode currentRunningMode = this.runningModeControl.getRunningMode();
            if (ok) {
                Future<ServerInventory> inventoryFuture = ServerInventoryService.install(serviceTarget, this, this.runningModeControl, this.environment, this.extensionRegistry, this.hostControllerInfo.getNativeManagementInterface(), this.hostControllerInfo.getNativeManagementPort());
                if (!this.hostControllerInfo.isMasterDomainController() && !this.environment.isUseCachedDc()) {
                    this.serverInventory = this.getFuture(inventoryFuture);
                    if (this.hostControllerInfo.getRemoteDomainControllerHost() != null) {
                        Future<MasterDomainControllerClient> clientFuture = RemoteDomainConnectionService.install(serviceTarget, this.getValue(), this.extensionRegistry, this.hostControllerInfo, this.environment.getProductConfig(), this.hostControllerInfo.getRemoteDomainControllerSecurityRealm(), this.remoteFileRepository, this.ignoredRegistry);
                        MasterDomainControllerClient masterDomainControllerClient = this.getFuture(clientFuture);
                        try {
                            masterDomainControllerClient.register();
                        }
                        catch (Exception e) {
                            HostControllerLogger.ROOT_LOGGER.cannotConnectToMaster(e);
                            System.exit(99);
                        }
                    } else if (currentRunningMode != RunningMode.ADMIN_ONLY) {
                        HostControllerLogger.ROOT_LOGGER.noDomainControllerConfigurationProvided(currentRunningMode, "--admin-only", RunningMode.ADMIN_ONLY);
                        System.exit(99);
                    }
                } else {
                    ExtensibleConfigurationPersister domainPersister;
                    if (this.environment.isUseCachedDc()) {
                        this.remoteFileRepository.setRemoteFileRepositoryExecutor(new RemoteDomainConnectionService.RemoteFileRepositoryExecutor(){

                            @Override
                            public File getFile(String relativePath, byte repoId, HostFileRepository localFileRepository) {
                                return localFileRepository.getFile(relativePath);
                            }
                        });
                    }
                    if (!(ok = this.boot((domainPersister = this.hostControllerConfigurationPersister.getDomainPersister()).load(), false)) && this.runningModeControl.getRunningMode().equals((Object)RunningMode.ADMIN_ONLY)) {
                        HostControllerLogger.ROOT_LOGGER.reportAdminOnlyDomainXmlFailure();
                        ok = true;
                    }
                    if (ok) {
                        ManagementRemotingServices.installManagementChannelServices((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (AbstractModelControllerOperationHandlerFactoryService)new MasterDomainControllerOperationHandlerService(this, new HostControllerRegistrationHandler.OperationExecutor(){

                            @Override
                            public ModelNode execute(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments, OperationStepHandler step) {
                                return DomainModelControllerService.this.internalExecute(operation, handler, control, attachments, step);
                            }
                        }), (ServiceName)SERVICE_NAME, (String)"domain", null, null);
                        this.serverInventory = this.getFuture(inventoryFuture);
                    }
                }
            }
            if (ok) {
                ServerToHostOperationHandlerFactoryService.install(serviceTarget, ServerInventoryService.SERVICE_NAME, this.proxyExecutor, new ServerToHostProtocolHandler.OperationExecutor(){

                    @Override
                    public ModelNode execute(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments, OperationStepHandler step) {
                        return DomainModelControllerService.this.internalExecute(operation, handler, control, attachments, step);
                    }
                }, this, this.expressionResolver);
                serviceTarget.addService(ServiceName.JBOSS.append(new String[]{"native-mgmt-startup"}), Service.NULL).addDependency(ManagementRemotingServices.channelServiceName((ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (String)"server")).setInitialMode(ServiceController.Mode.ACTIVE).install();
                serviceTarget.addService(ServiceName.JBOSS.append(new String[]{"http-mgmt-startup"}), Service.NULL).addDependency(ServiceBuilder.DependencyType.OPTIONAL, HttpManagementService.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE).install();
                reachedServers = true;
                if (currentRunningMode == RunningMode.NORMAL) {
                    this.startServers();
                }
            }
        }
        catch (Exception e) {
            HostControllerLogger.ROOT_LOGGER.caughtExceptionDuringBoot(e);
            if (!reachedServers) {
                ok = false;
            }
        }
        finally {
            if (ok) {
                try {
                    this.finishBoot();
                }
                finally {
                    this.bootstrapListener.tick();
                }
            } else {
                HostControllerLogger.ROOT_LOGGER.unsuccessfulBoot();
                System.exit(99);
            }
        }
    }

    private <T> T getFuture(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void startServers() {
        ModelNode addr = new ModelNode();
        addr.add("host", this.hostControllerInfo.getLocalHostName());
        ModelNode op = Util.getEmptyOperation((String)"start-servers", (ModelNode)addr);
        this.getValue().execute(op, null, null, null);
    }

    public void stop(final StopContext context) {
        this.serverInventory = null;
        this.extensionRegistry.clear();
        super.stop(context);
        context.asynchronous();
        Thread executorShutdown = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DomainModelControllerService.this.pingScheduler.shutdownNow();
                }
                finally {
                    try {
                        DomainModelControllerService.this.proxyExecutor.shutdown();
                    }
                    finally {
                        context.complete();
                    }
                }
            }
        }, DomainModelControllerService.class.getSimpleName() + " ExecutorService Shutdown Thread");
        executorShutdown.start();
    }

    @Override
    public void stopLocalHost() {
        this.stopLocalHost(0);
    }

    @Override
    public void stopLocalHost(int exitCode) {
        ProcessControllerClient client = ((ProcessControllerConnectionService)this.injectedProcessControllerConnection.getValue()).getClient();
        this.processState.setStopping();
        try {
            client.shutdown(exitCode);
        }
        catch (IOException e) {
            throw HostControllerMessages.MESSAGES.errorClosingDownHost(e);
        }
    }

    @Override
    public void registerHostModel(String hostName, ManagementResourceRegistration root) {
        HostModelUtil.createHostRegistry(hostName, root, this.hostControllerConfigurationPersister, this.environment, this.runningModeControl, this.localFileRepository, this.hostControllerInfo, new DelegatingServerInventory(), this.remoteFileRepository, this.contentRepository, this, this.extensionRegistry, this.vaultReader, this.ignoredRegistry, this.processState, this.pathManager);
    }

    @Override
    public void initializeMasterDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepository, HostFileRepository fileRepository, ExtensionRegistry extensionRegistry, PathManagerService pathManager) {
        this.initializeDomainResource(root, configurationPersister, contentRepository, fileRepository, true, this.hostControllerInfo, extensionRegistry, null, pathManager);
    }

    @Override
    public void initializeSlaveDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepository, HostFileRepository fileRepository, LocalHostControllerInfo hostControllerInfo, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, PathManagerService pathManager) {
        this.initializeDomainResource(root, configurationPersister, contentRepository, fileRepository, false, hostControllerInfo, extensionRegistry, ignoredDomainResourceRegistry, pathManager);
    }

    private void initializeDomainResource(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepo, HostFileRepository fileRepository, boolean isMaster, LocalHostControllerInfo hostControllerInfo, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, PathManagerService pathManager) {
        DomainRootDefinition domainRootDefinition = new DomainRootDefinition(this.environment, configurationPersister, contentRepo, fileRepository, isMaster, hostControllerInfo, extensionRegistry, ignoredDomainResourceRegistry, pathManager);
        this.rootResourceDefinition.setDelegate(domainRootDefinition, root);
    }

    private static <S> S service(Class<S> service) {
        ServiceLoader<S> serviceLoader = ServiceLoader.load(service);
        Iterator<S> it = serviceLoader.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    @Override
    public ExpressionResolver getExpressionResolver() {
        return this.expressionResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        int poolSize = -1;
        try {
            poolSize = Integer.parseInt(SecurityActions.getSystemProperty("jboss.as.domain.ping.pool.size", "5"));
            PINGER_POOL_SIZE = poolSize > 0 ? poolSize : 5;
        }
        catch (Exception exception) {
            PINGER_POOL_SIZE = poolSize > 0 ? poolSize : 5;
            catch (Throwable throwable) {
                PINGER_POOL_SIZE = poolSize > 0 ? poolSize : 5;
                throw throwable;
            }
        }
    }

    private static class DelegatingResourceDefinition
    implements ResourceDefinition {
        private volatile ResourceDefinition delegate;

        private DelegatingResourceDefinition() {
        }

        void setDelegate(DomainRootDefinition delegate, ManagementResourceRegistration root) {
            this.delegate = delegate;
            delegate.initialize(root);
        }

        public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        }

        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        }

        public PathElement getPathElement() {
            return this.delegate.getPathElement();
        }

        public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration resourceRegistration) {
            return this.delegate.getDescriptionProvider(resourceRegistration);
        }
    }

    private class DelegatingServerInventory
    implements ServerInventory {
        private DelegatingServerInventory() {
        }

        @Override
        public ProxyController serverCommunicationRegistered(String serverProcessName, ManagementChannelHandler channelHandler) {
            return DomainModelControllerService.this.serverInventory.serverCommunicationRegistered(serverProcessName, channelHandler);
        }

        @Override
        public boolean serverReconnected(String serverProcessName, ManagementChannelHandler channelHandler) {
            return DomainModelControllerService.this.serverInventory.serverReconnected(serverProcessName, channelHandler);
        }

        @Override
        public void serverProcessAdded(String serverProcessName) {
            DomainModelControllerService.this.serverInventory.serverProcessAdded(serverProcessName);
        }

        @Override
        public void serverStartFailed(String serverProcessName) {
            DomainModelControllerService.this.serverInventory.serverStartFailed(serverProcessName);
        }

        @Override
        public void serverStarted(String serverProcessName) {
            DomainModelControllerService.this.serverInventory.serverStarted(serverProcessName);
        }

        @Override
        public void serverProcessStopped(String serverProcessName) {
            DomainModelControllerService.this.serverInventory.serverProcessStopped(serverProcessName);
        }

        @Override
        public String getServerProcessName(String serverName) {
            return DomainModelControllerService.this.serverInventory.getServerProcessName(serverName);
        }

        @Override
        public String getProcessServerName(String processName) {
            return DomainModelControllerService.this.serverInventory.getProcessServerName(processName);
        }

        @Override
        public void processInventory(Map<String, ProcessInfo> processInfos) {
            DomainModelControllerService.this.serverInventory.processInventory(processInfos);
        }

        @Override
        public Map<String, ProcessInfo> determineRunningProcesses() {
            return DomainModelControllerService.this.serverInventory.determineRunningProcesses();
        }

        @Override
        public Map<String, ProcessInfo> determineRunningProcesses(boolean serversOnly) {
            return DomainModelControllerService.this.serverInventory.determineRunningProcesses(serversOnly);
        }

        @Override
        public ServerStatus determineServerStatus(String serverName) {
            return DomainModelControllerService.this.serverInventory.determineServerStatus(serverName);
        }

        @Override
        public ServerStatus startServer(String serverName, ModelNode domainModel) {
            return DomainModelControllerService.this.serverInventory.startServer(serverName, domainModel);
        }

        @Override
        public ServerStatus startServer(String serverName, ModelNode domainModel, boolean blocking) {
            return DomainModelControllerService.this.serverInventory.startServer(serverName, domainModel, blocking);
        }

        @Override
        public void reconnectServer(String serverName, ModelNode domainModel, byte[] authKey, boolean running, boolean stopping) {
            DomainModelControllerService.this.serverInventory.reconnectServer(serverName, domainModel, authKey, running, stopping);
        }

        @Override
        public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel) {
            return DomainModelControllerService.this.serverInventory.restartServer(serverName, gracefulTimeout, domainModel);
        }

        @Override
        public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel, boolean blocking) {
            return DomainModelControllerService.this.serverInventory.restartServer(serverName, gracefulTimeout, domainModel, blocking);
        }

        @Override
        public ServerStatus stopServer(String serverName, int gracefulTimeout) {
            return DomainModelControllerService.this.serverInventory.stopServer(serverName, gracefulTimeout);
        }

        @Override
        public ServerStatus stopServer(String serverName, int gracefulTimeout, boolean blocking) {
            return DomainModelControllerService.this.serverInventory.stopServer(serverName, gracefulTimeout, blocking);
        }

        @Override
        public CallbackHandler getServerCallbackHandler() {
            return DomainModelControllerService.this.serverInventory.getServerCallbackHandler();
        }

        @Override
        public void stopServers(int gracefulTimeout) {
            DomainModelControllerService.this.serverInventory.stopServers(gracefulTimeout);
        }

        @Override
        public void connectionFinished() {
            DomainModelControllerService.this.serverInventory.connectionFinished();
        }

        @Override
        public void serverProcessStarted(String processName) {
            DomainModelControllerService.this.serverInventory.serverProcessStarted(processName);
        }

        @Override
        public void serverProcessRemoved(String processName) {
            DomainModelControllerService.this.serverInventory.serverProcessRemoved(processName);
        }

        @Override
        public void operationFailed(String processName, ProcessMessageHandler.OperationType type) {
            DomainModelControllerService.this.serverInventory.operationFailed(processName, type);
        }
    }

    private static class HostRegistration {
        private final Long remoteConnectionId;
        private final ManagementChannelHandler channelHandler;
        private final SlaveHostPinger pinger;

        private HostRegistration(Long remoteConnectionId, ManagementChannelHandler channelHandler, SlaveHostPinger pinger) {
            this.remoteConnectionId = remoteConnectionId;
            this.channelHandler = channelHandler;
            this.pinger = pinger;
        }

        public int hashCode() {
            return this.remoteConnectionId == null ? Integer.MIN_VALUE : this.channelHandler.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof HostRegistration && HostRegistration.safeEquals(this.remoteConnectionId, ((HostRegistration)obj).remoteConnectionId);
        }

        private static boolean safeEquals(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }
    }
}

