/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.mgmt.SecurityActions;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementPingRequest;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.remoting3.Channel;
import org.jboss.threads.AsyncFuture;

public class SlaveHostPinger {
    public static final long STD_INTERVAL;
    public static final long STD_TIMEOUT;
    public static final long SHORT_TIMEOUT = 10000L;
    private final String hostName;
    private final ManagementChannelHandler channelHandler;
    private final ScheduledExecutorService scheduler;
    private volatile Long remoteConnectionID;
    private volatile boolean cancelled;

    public SlaveHostPinger(String hostName, ManagementChannelHandler channelHandler, ScheduledExecutorService scheduler, long remoteConnectionID) {
        this.hostName = hostName;
        this.channelHandler = channelHandler;
        this.scheduler = scheduler;
        this.remoteConnectionID = remoteConnectionID;
    }

    public void schedulePing(long timeout, long delay) {
        PingTask task = new PingTask(timeout, delay);
        this.scheduler.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        long interval = -1L;
        try {
            interval = Long.parseLong(SecurityActions.getSystemProperty("jboss.as.domain.ping.interval", "15000"));
            STD_INTERVAL = interval > 0L ? interval + 500L : 15500L;
        }
        catch (Exception e) {
            STD_INTERVAL = interval > 0L ? interval + 500L : 15500L;
            catch (Throwable throwable) {
                STD_INTERVAL = interval > 0L ? interval + 500L : 15500L;
                throw throwable;
            }
        }
        long timeout = -1L;
        try {
            timeout = Long.parseLong(SecurityActions.getSystemProperty("jboss.as.domain.ping.timeout", "30000"));
            STD_TIMEOUT = timeout > 0L ? timeout : 30000L;
        }
        catch (Exception e) {
            STD_TIMEOUT = timeout > 0L ? timeout : 30000L;
            catch (Throwable throwable) {
                STD_TIMEOUT = timeout > 0L ? timeout : 30000L;
                throw throwable;
            }
        }
    }

    private class PingTask
    implements Runnable {
        private final long timeout;
        private final long interval;

        private PingTask(long timeout, long interval) {
            this.timeout = timeout;
            this.interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!SlaveHostPinger.this.cancelled) {
                boolean fail = false;
                AsyncFuture future = null;
                try {
                    if (this.interval < 1L || System.currentTimeMillis() - SlaveHostPinger.this.channelHandler.getLastMessageReceivedTime() > this.interval) {
                        future = SlaveHostPinger.this.channelHandler.executeRequest((ManagementRequest)ManagementPingRequest.INSTANCE, null).getResult();
                        Long id = (Long)future.get(this.timeout, TimeUnit.MILLISECONDS);
                        if (!SlaveHostPinger.this.cancelled && SlaveHostPinger.this.remoteConnectionID != null && !SlaveHostPinger.this.remoteConnectionID.equals(id)) {
                            HostControllerLogger.DOMAIN_LOGGER.slaveHostControllerChanged(SlaveHostPinger.this.hostName);
                            fail = true;
                        } else {
                            SlaveHostPinger.this.remoteConnectionID = id;
                        }
                    }
                }
                catch (IOException e) {
                    HostControllerLogger.DOMAIN_LOGGER.debug("Caught exception sending ping request", e);
                }
                catch (InterruptedException e) {
                    this.safeCancel((Future<?>)future);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    HostControllerLogger.DOMAIN_LOGGER.debug("Caught exception sending ping request", e);
                }
                catch (TimeoutException e) {
                    if (!SlaveHostPinger.this.cancelled) {
                        fail = true;
                        HostControllerLogger.DOMAIN_LOGGER.slaveHostControllerUnreachable(SlaveHostPinger.this.hostName, this.timeout);
                    }
                    this.safeCancel((Future<?>)future);
                }
                finally {
                    if (fail) {
                        Channel channel = null;
                        try {
                            channel = SlaveHostPinger.this.channelHandler.getChannel();
                        }
                        catch (IOException e) {}
                        StreamUtils.safeClose(channel);
                    } else if (!SlaveHostPinger.this.cancelled && this.interval > 0L) {
                        SlaveHostPinger.this.scheduler.schedule(this, this.interval, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }

        void safeCancel(Future<?> future) {
            if (future != null) {
                future.cancel(true);
            }
        }
    }
}

