/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.descriptions;

import java.util.Locale;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.descriptions.common.ProfileDescription;
import org.jboss.as.domain.controller.descriptions.DomainRootDescription;
import org.jboss.as.domain.controller.descriptions.ServerGroupDescription;
import org.jboss.dmr.ModelNode;

public final class DomainDescriptionProviders {
    public static final DescriptionProvider ROOT_PROVIDER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return DomainRootDescription.getDescription(locale);
        }
    };
    public static final DescriptionProvider SYSTEM_PROPERTY_PROVIDER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return DomainRootDescription.getSystemPropertiesDescription(locale);
        }
    };
    public static final DescriptionProvider PROFILE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return ProfileDescription.getProfileWithIncludesDescription((Locale)locale);
        }
    };
    public static final DescriptionProvider DEPLOYMENT_PROVIDER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return DeploymentDescription.getDeploymentDescription((Locale)locale, (boolean)false, (boolean)true, (boolean)false);
        }
    };
    public static final DescriptionProvider SERVER_GROUP = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return ServerGroupDescription.getServerGroupDescription(locale);
        }
    };
    public static final DescriptionProvider SERVER_GROUP_DEPLOYMENT = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return DeploymentDescription.getDeploymentDescription((Locale)locale, (boolean)true, (boolean)false, (boolean)false);
        }
    };
    public static final DescriptionProvider SERVER_GROUP_SYSTEM_PROPERTY_PROVIDER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return ServerGroupDescription.getSystemPropertiesDescription(locale);
        }
    };

    private DomainDescriptionProviders() {
    }
}

