/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.coordination.DomainOperationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DomainFinalResultHandler
implements OperationStepHandler {
    private final DomainOperationContext domainOperationContext;

    public DomainFinalResultHandler(DomainOperationContext domainOperationContext) {
        this.domainOperationContext = domainOperationContext;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.completeStep();
        boolean isDomain = this.isDomainOperation(operation);
        boolean shouldContinue = this.collectDomainFailure(context, isDomain);
        shouldContinue = shouldContinue && this.collectContextFailure(context, isDomain);
        boolean bl = shouldContinue = shouldContinue && this.collectHostFailures(context, isDomain);
        if (shouldContinue) {
            ModelNode contextResult = context.getResult();
            contextResult.setEmptyObject();
            contextResult.set(this.getDomainResults(operation, new String[0]));
            if (this.domainOperationContext.getServerResults().size() > 0) {
                this.populateServerGroupResults(context);
            } else {
                context.getServerResults();
            }
        }
    }

    private boolean collectDomainFailure(OperationContext context, boolean isDomain) {
        ModelNode coordinator = this.domainOperationContext.getCoordinatorResult();
        ModelNode domainFailure = null;
        if (isDomain && coordinator != null && coordinator.has("failure-description")) {
            ModelNode modelNode = domainFailure = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode(DomainControllerMessages.MESSAGES.unexplainedFailure());
        }
        if (domainFailure != null) {
            context.getFailureDescription().get("domain-failure-description").set(domainFailure);
            return false;
        }
        return true;
    }

    private boolean collectContextFailure(OperationContext context, boolean isDomain) {
        if (!this.domainOperationContext.isFailureReported() && context.hasFailureDescription()) {
            ModelNode formattedFailure = new ModelNode();
            if (isDomain) {
                ModelNode failure = context.getFailureDescription();
                if (failure.isDefined()) {
                    formattedFailure.get("domain-failure-description").set(failure);
                } else {
                    formattedFailure.get("domain-failure-description").set(DomainControllerMessages.MESSAGES.unexplainedFailure());
                }
            } else {
                ModelNode hostFailureProperty = new ModelNode();
                ModelNode contextFailure = context.getFailureDescription();
                ModelNode hostFailure = contextFailure.isDefined() ? contextFailure : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
                hostFailureProperty.add(this.domainOperationContext.getLocalHostInfo().getLocalHostName(), hostFailure);
                formattedFailure.get("host-failure-descriptions").set(hostFailureProperty);
            }
            context.getFailureDescription().set(formattedFailure);
            return false;
        }
        return true;
    }

    private boolean collectHostFailures(OperationContext context, boolean isDomain) {
        ModelNode hostFailureResults = null;
        for (Map.Entry<String, ModelNode> entry : this.domainOperationContext.getHostControllerResults().entrySet()) {
            ModelNode hostResult = entry.getValue();
            if (!hostResult.has("failure-description")) continue;
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = hostResult.hasDefined("failure-description") ? hostResult.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
            hostFailureResults.add(entry.getKey(), desc);
        }
        ModelNode coordinator = this.domainOperationContext.getCoordinatorResult();
        if (!isDomain && coordinator != null && coordinator.has("failure-description")) {
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
            hostFailureResults.add(this.domainOperationContext.getLocalHostInfo().getLocalHostName(), desc);
        }
        if (hostFailureResults != null) {
            if (!context.getFailureDescription().isDefined() || context.getFailureDescription().getType() == ModelType.OBJECT) {
                context.getFailureDescription().get("host-failure-descriptions").set(hostFailureResults);
            } else {
                DomainControllerLogger.CONTROLLER_LOGGER.debugf("Failure description is not of type OBJECT '%s'", context.getFailureDescription());
            }
            return false;
        }
        return true;
    }

    private ModelNode getDomainResults(ModelNode operation, String ... stepLabels) {
        ModelNode result;
        ResponseProvider provider = new ResponseProvider(operation, this.domainOperationContext.getLocalHostInfo().getLocalHostName());
        if (!provider.isLeaf()) {
            result = new ModelNode();
            String[] nextStepLabels = new String[stepLabels.length + 1];
            System.arraycopy(stepLabels, 0, nextStepLabels, 0, stepLabels.length);
            int i = 1;
            for (ModelNode step : provider.getChildren()) {
                String childStepLabel;
                nextStepLabels[stepLabels.length] = childStepLabel = "step-" + i++;
                result.get(childStepLabel).set(this.getDomainResults(step, nextStepLabels));
            }
        } else if (provider.getServer() == null) {
            String hostName = provider.getHost();
            boolean forMaster = hostName.equals(this.domainOperationContext.getLocalHostInfo().getLocalHostName());
            ModelNode hostResponse = forMaster ? this.domainOperationContext.getCoordinatorResult() : this.domainOperationContext.getHostControllerResults().get(hostName);
            result = this.getHostControllerResult(hostResponse, stepLabels);
        } else {
            result = this.domainOperationContext.getServerResult(provider.getHost(), provider.getServer(), stepLabels);
        }
        return result == null ? new ModelNode() : result;
    }

    private ModelNode getHostControllerResult(ModelNode fullResult, String ... stepLabels) {
        ModelNode domainResults;
        ModelNode result = null;
        if (fullResult != null && fullResult.hasDefined("result") && fullResult.get("result").hasDefined("domain-results") && (result = (domainResults = fullResult.get(new String[]{"result", "domain-results"})).get(stepLabels)).has("outcome") && !result.hasDefined("outcome")) {
            if (result.hasDefined("failure-description")) {
                result.get("outcome").set("failed");
            } else {
                result.get("outcome").set("success");
            }
        }
        return result;
    }

    private void populateServerGroupResults(OperationContext context) {
        TreeSet<String> groupNames = new TreeSet<String>();
        HashMap groupToServerMap = new HashMap();
        for (Map.Entry<ServerIdentity, ModelNode> entry : this.domainOperationContext.getServerResults().entrySet()) {
            String serverGroup = entry.getKey().getServerGroupName();
            groupNames.add(serverGroup);
            String hostName = entry.getKey().getHostName();
            String serverName = entry.getKey().getServerName();
            if (!groupToServerMap.containsKey(serverGroup)) {
                groupToServerMap.put(serverGroup, new TreeSet());
            }
            ((Set)groupToServerMap.get(serverGroup)).add(new HostServer(hostName, serverName, entry.getValue()));
        }
        boolean serverGroupSuccess = false;
        for (String groupName : groupNames) {
            ModelNode groupNode = new ModelNode();
            if (!this.domainOperationContext.isServerGroupRollback(groupName)) {
                serverGroupSuccess = true;
            }
            for (HostServer hostServer : (Set)groupToServerMap.get(groupName)) {
                groupNode.get(new String[]{"host", hostServer.hostName, hostServer.serverName, "response"}).set(hostServer.result);
            }
            context.getServerResults().get(groupName).set(groupNode);
        }
        if (!serverGroupSuccess) {
            context.getFailureDescription().set(DomainControllerMessages.MESSAGES.operationFailedOrRolledBack());
        }
    }

    private boolean isDomainOperation(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return address.size() == 0 || !address.getElement(0).getKey().equals("host");
    }

    private static class ResponseProvider {
        private final String host;
        private final String server;
        private final List<ModelNode> children;

        private ResponseProvider(ModelNode operation, String localHostName) {
            boolean composite = "composite".equals(operation.require("operation").asString());
            PathAddress opAddr = PathAddress.pathAddress((ModelNode)operation.get("address"));
            int addrSize = opAddr.size();
            if (addrSize == 0) {
                this.host = localHostName;
                this.server = null;
            } else if ("host".equals(opAddr.getElement(0).getKey())) {
                this.host = opAddr.getElement(0).getValue();
                if (addrSize > 1 && "server".equals(opAddr.getElement(1).getKey())) {
                    this.server = opAddr.getElement(1).getValue();
                    composite = composite && addrSize == 2;
                } else {
                    this.server = null;
                }
            } else {
                this.host = localHostName;
                this.server = null;
                composite = false;
            }
            this.children = composite ? (operation.hasDefined("steps") ? new ArrayList<ModelNode>(operation.require("steps").asList()) : Collections.emptyList()) : null;
        }

        private String getHost() {
            return this.host;
        }

        private String getServer() {
            return this.server;
        }

        private List<ModelNode> getChildren() {
            return this.children;
        }

        private boolean isLeaf() {
            return this.children == null;
        }
    }

    private static class HostServer
    implements Comparable<HostServer> {
        private final String hostName;
        private final String serverName;
        private final ModelNode result;

        private HostServer(String hostName, String serverName, ModelNode result) {
            this.hostName = hostName;
            this.serverName = serverName;
            this.result = result;
        }

        @Override
        public int compareTo(HostServer hostServer) {
            int hostCompare = this.hostName.compareTo(hostServer.hostName);
            if (hostCompare != 0) {
                return hostCompare;
            }
            return this.serverName.compareTo(hostServer.serverName);
        }
    }
}

