/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.ReconnectPolicy;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.xnio.OptionMap;

class RemoteDomainConnection
extends ManagementClientChannelStrategy {
    private static final String CHANNEL_SERVICE_TYPE = "domain";
    private static final ReconnectPolicy reconnectPolicy = ReconnectPolicy.RECONNECT;
    private final String localHostName;
    private final ModelNode localHostInfo;
    private final SecurityRealm realm;
    private final ProtocolChannelClient.Configuration configuration;
    private final ManagementChannelHandler channelHandler;
    private final ExecutorService executorService;
    private final HostRegistrationCallback callback;
    private final AtomicBoolean reconnect = new AtomicBoolean();
    private volatile Connection connection;
    private volatile Channel channel;
    private volatile int reconnectionCount;

    RemoteDomainConnection(String localHostName, ModelNode localHostInfo, ProtocolChannelClient.Configuration configuration, SecurityRealm realm, ExecutorService executorService, HostRegistrationCallback callback) {
        this.callback = callback;
        this.localHostName = localHostName;
        this.localHostInfo = localHostInfo;
        this.configuration = configuration;
        this.realm = realm;
        this.executorService = executorService;
        this.channelHandler = new ManagementChannelHandler((ManagementClientChannelStrategy)this, executorService);
    }

    protected RegistrationResult connect() throws IOException {
        RegistrationResult result = this.connectSync();
        if (result.ok) {
            this.reconnect.set(true);
            HostControllerLogger.ROOT_LOGGER.registeredAtRemoteHostController();
        }
        return result;
    }

    protected ManagementChannelHandler getHandler() {
        return this.channelHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel() throws IOException {
        Channel channel = this.channel;
        if (channel == null) {
            RemoteDomainConnection remoteDomainConnection = this;
            synchronized (remoteDomainConnection) {
                if (this.channel == null) {
                    throw ProtocolMessages.MESSAGES.channelClosed();
                }
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.reconnect.compareAndSet(true, false)) {
            try {
                this.channelHandler.executeRequest((ManagementRequest)new UnregisterModelControllerRequest(), null).getResult().await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                StreamUtils.safeClose((Closeable)this.channel);
                StreamUtils.safeClose((Closeable)this.connection);
            }
        }
    }

    protected boolean isConnected() {
        if (this.reconnect.get()) {
            return this.channel != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized RegistrationResult connectSync() throws IOException {
        boolean ok = false;
        try {
            RegistrationResult result;
            ProtocolChannelClient client = ProtocolChannelClient.create((ProtocolChannelClient.Configuration)this.configuration);
            CallbackHandler callbackHandler = null;
            SSLContext sslContext = null;
            if (this.realm != null) {
                sslContext = this.realm.getSSLContext();
                CallbackHandlerFactory handlerFactory = this.realm.getSecretCallbackHandlerFactory();
                if (handlerFactory != null) {
                    callbackHandler = handlerFactory.getCallbackHandler(this.localHostName);
                }
            }
            this.connection = client.connectSync(callbackHandler, Collections.emptyMap(), sslContext);
            this.connection.addCloseHandler((CloseHandler)new CloseHandler<Connection>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleClose(Connection closed, IOException exception) {
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        if (RemoteDomainConnection.this.connection == closed) {
                            RemoteDomainConnection.this.connection = null;
                            RemoteDomainConnection.this.connectionClosed();
                        }
                    }
                }
            });
            this.channel = (Channel)this.connection.openChannel(CHANNEL_SERVICE_TYPE, OptionMap.EMPTY).get();
            this.channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleClose(Channel closed, IOException exception) {
                    RemoteDomainConnection.this.channelHandler.handleChannelClosed(closed, exception);
                    2 var3_3 = this;
                    synchronized (var3_3) {
                        if (RemoteDomainConnection.this.channel == closed) {
                            RemoteDomainConnection.this.channel = null;
                            RemoteDomainConnection.this.connectionClosed();
                        }
                    }
                }
            });
            this.channel.receiveMessage(this.channelHandler.getReceiver());
            try {
                result = (RegistrationResult)this.channelHandler.executeRequest((ManagementRequest)new RegisterHostControllerRequest(), null).getResult().get();
            }
            catch (Exception e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
            ok = true;
            this.reconnectionCount = 0;
            RegistrationResult registrationResult = result;
            return registrationResult;
        }
        finally {
            if (!ok) {
                StreamUtils.safeClose((Closeable)this.connection);
                StreamUtils.safeClose((Closeable)this.channel);
            }
        }
    }

    private void connectionClosed() {
        if (!this.reconnect.get()) {
            return;
        }
        Connection connection = this.connection;
        if (connection != null) {
            if (this.channel == null) {
                connection.closeAsync();
            }
        } else {
            HostControllerLogger.ROOT_LOGGER.lostRemoteDomainConnection();
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    ReconnectPolicy policy = reconnectPolicy;
                    while (true) {
                        try {
                            RegistrationResult result;
                            do {
                                policy.wait(RemoteDomainConnection.this.reconnectionCount++);
                                if (!RemoteDomainConnection.this.reconnect.get()) {
                                    return;
                                }
                                HostControllerLogger.ROOT_LOGGER.debugf("trying to reconnect to remote host-controller", new Object[0]);
                            } while (!(result = RemoteDomainConnection.this.connectSync()).isOK());
                            HostControllerLogger.ROOT_LOGGER.reconnectedToMaster();
                            return;
                        }
                        catch (IOException e) {
                            HostControllerLogger.ROOT_LOGGER.debugf(e, "failed to reconnect to the remote host-controller", new Object[0]);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                        break;
                    }
                }
            });
        }
    }

    protected void reconfigure(URI connectionURI) {
        this.configuration.setUri(connectionURI);
        Connection connection = this.connection;
        if (connection != null) {
            connection.closeAsync();
        }
    }

    boolean applyDomainModel(ModelNode result) {
        if (!result.hasDefined("result")) {
            return false;
        }
        List bootOperations = result.get("result").asList();
        return this.callback.applyDomainModel(bootOperations);
    }

    void registered() {
        this.callback.registrationComplete(this.channelHandler);
    }

    private class UnregisterModelControllerRequest
    extends AbstractManagementRequest<Void, Void> {
        private UnregisterModelControllerRequest() {
        }

        public byte getOperationType() {
            return 83;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnection.this.localHostName);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
            HostControllerLogger.ROOT_LOGGER.unregisteredAtRemoteHostController();
            resultHandler.done(null);
        }
    }

    private class CompleteRegistrationRequest
    extends AbstractManagementRequest<RegistrationResult, Void> {
        private final byte outcome;
        private final String message = "yay!";

        private CompleteRegistrationRequest(byte outcome) {
            this.outcome = outcome;
        }

        public byte getOperationType() {
            return 88;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<RegistrationResult> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.writeByte((int)this.outcome);
            output.writeUTF("yay!");
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<RegistrationResult> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
            byte param = input.readByte();
            if (param != 33) {
                byte errorCode = input.readByte();
                String message = input.readUTF();
                resultHandler.done((Object)new RegistrationResult(errorCode, message));
                return;
            }
            resultHandler.done((Object)new RegistrationResult());
        }
    }

    private class RegisterHostControllerRequest
    extends AbstractManagementRequest<RegistrationResult, Void> {
        private RegisterHostControllerRequest() {
        }

        public byte getOperationType() {
            return 81;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<RegistrationResult> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnection.this.localHostName);
            RemoteDomainConnection.this.localHostInfo.writeExternal((DataOutput)output);
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<RegistrationResult> resultHandler, final ManagementRequestContext<Void> context) throws IOException {
            byte param = input.readByte();
            if (param != 33) {
                byte errorCode = input.readByte();
                String message = input.readUTF();
                resultHandler.done((Object)new RegistrationResult(errorCode, message));
                return;
            }
            final ModelNode domainModel = new ModelNode();
            domainModel.readExternal(input);
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                public void execute(ManagementRequestContext<Void> voidManagementRequestContext) throws Exception {
                    boolean success = RemoteDomainConnection.this.applyDomainModel(domainModel);
                    if (success) {
                        RemoteDomainConnection.this.channelHandler.executeRequest(context.getOperationId(), (ManagementRequest)new CompleteRegistrationRequest(33));
                    } else {
                        RemoteDomainConnection.this.channelHandler.executeRequest(context.getOperationId(), (ManagementRequest)new CompleteRegistrationRequest(34));
                        resultHandler.done((Object)new RegistrationResult(SlaveRegistrationException.ErrorCode.UNKNOWN, ""));
                    }
                }
            });
        }
    }

    static interface HostRegistrationCallback {
        public boolean applyDomainModel(List<ModelNode> var1);

        public void registrationComplete(ManagementChannelHandler var1);
    }

    static class RegistrationResult {
        boolean ok;
        String message;
        SlaveRegistrationException.ErrorCode code;

        RegistrationResult(byte code, String message) {
            this(SlaveRegistrationException.ErrorCode.parseCode(code), message);
        }

        RegistrationResult(SlaveRegistrationException.ErrorCode code, String message) {
            this.message = message;
            this.code = code;
        }

        RegistrationResult() {
            this.ok = true;
        }

        public boolean isOK() {
            return this.ok;
        }

        public String getMessage() {
            return this.message;
        }

        public SlaveRegistrationException.ErrorCode getCode() {
            return this.code;
        }
    }
}

