/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.JvmElement;
import org.jboss.as.host.controller.JvmType;

class JvmOptionsBuilderFactory {
    private static final JvmOptionsBuilderFactory INSTANCE = new JvmOptionsBuilderFactory();
    private static final Map<JvmType, JvmOptionsBuilder> BUILDERS;

    private JvmOptionsBuilderFactory() {
    }

    static JvmOptionsBuilderFactory getInstance() {
        return INSTANCE;
    }

    void addOptions(JvmElement jvmElement, List<String> command) {
        if (jvmElement == null) {
            throw HostControllerMessages.MESSAGES.nullVar("jvm");
        }
        if (command == null) {
            throw HostControllerMessages.MESSAGES.nullVar("command");
        }
        JvmOptionsBuilder builder = BUILDERS.get((Object)jvmElement.getJvmType());
        if (builder == null) {
            throw HostControllerMessages.MESSAGES.unknown("jvm", (Object)jvmElement.getJvmType());
        }
        builder.addToOptions(jvmElement, command);
    }

    static {
        HashMap<JvmType, JvmOptionsBuilder> map = new HashMap<JvmType, JvmOptionsBuilder>();
        map.put(JvmType.SUN, new SunJvmOptionsBuilder(JvmType.SUN));
        map.put(JvmType.IBM, new IbmJvmOptionsBuilder(JvmType.IBM));
        BUILDERS = Collections.unmodifiableMap(map);
    }

    private static class IbmJvmOptionsBuilder
    extends JvmOptionsBuilder {
        public IbmJvmOptionsBuilder(JvmType type) {
            super(type);
        }

        @Override
        void addPermGen(JvmElement jvmElement, List<String> command) {
            if (jvmElement.getPermgenSize() != null || jvmElement.getMaxPermgen() != null) {
                HostControllerLogger.ROOT_LOGGER.ignoringPermGen(this.type, jvmElement.getName());
            }
        }
    }

    private static class SunJvmOptionsBuilder
    extends JvmOptionsBuilder {
        public SunJvmOptionsBuilder(JvmType type) {
            super(type);
        }

        @Override
        void addPermGen(JvmElement jvmElement, List<String> command) {
            String permgen = jvmElement.getPermgenSize();
            String maxPermgen = jvmElement.getMaxPermgen();
            if (maxPermgen == null && permgen != null) {
                maxPermgen = permgen;
            }
            if (permgen == null && maxPermgen != null) {
                permgen = maxPermgen;
            }
            if (permgen != null) {
                command.add("-XX:PermSize=" + permgen);
            }
            if (maxPermgen != null) {
                command.add("-XX:MaxPermSize=" + maxPermgen);
            }
        }
    }

    private static abstract class JvmOptionsBuilder {
        final JvmType type;

        JvmOptionsBuilder(JvmType type) {
            this.type = type;
        }

        void addToOptions(JvmElement jvmElement, List<String> command) {
            List<String> options;
            String debugOptions;
            String heap = jvmElement.getHeapSize();
            String maxHeap = jvmElement.getMaxHeap();
            if (maxHeap == null && heap != null) {
                maxHeap = heap;
            }
            if (heap == null && maxHeap != null) {
                heap = maxHeap;
            }
            this.addPermGen(jvmElement, command);
            if (heap != null) {
                command.add("-Xms" + heap);
            }
            if (maxHeap != null) {
                command.add("-Xmx" + maxHeap);
            }
            if (jvmElement.getStack() != null) {
                command.add("-Xss" + jvmElement.getStack());
            }
            if (jvmElement.getAgentPath() != null) {
                command.add("-agentpath:" + jvmElement.getAgentPath());
            }
            if (jvmElement.getAgentLib() != null) {
                command.add("-agentlib:" + jvmElement.getAgentLib());
            }
            if (jvmElement.getJavaagent() != null) {
                command.add("-javaagent:" + jvmElement.getJavaagent());
            }
            if (jvmElement.isDebugEnabled() != null && jvmElement.isDebugEnabled().booleanValue() && jvmElement.getDebugOptions() != null && (debugOptions = jvmElement.getDebugOptions()) != null) {
                if (!debugOptions.startsWith("-X")) {
                    debugOptions = "-X" + debugOptions;
                }
                command.add(debugOptions);
            }
            if ((options = jvmElement.getJvmOptions().getOptions()).size() > 0) {
                String jvmName = jvmElement.getName();
                for (String option : options) {
                    if (!this.checkOption(heap != null && option.startsWith("-Xms"), jvmName, option, Element.HEAP.toString()) || !this.checkOption(maxHeap != null && option.startsWith("-Xmx"), jvmName, option, Element.HEAP.toString()) || !this.checkOption(jvmElement.getStack() != null && option.startsWith("-Xss"), jvmName, option, Element.STACK.toString()) || !this.checkOption(jvmElement.getAgentPath() != null && option.startsWith("-agentpath:"), jvmName, option, Element.AGENT_PATH.toString()) || !this.checkOption(jvmElement.getAgentLib() != null && option.startsWith("-agentlib:"), jvmName, option, Element.AGENT_LIB.toString()) || !this.checkOption(jvmElement.getAgentLib() != null && option.startsWith("-javaagent:"), jvmName, option, Element.AGENT_LIB.toString()) || !this.checkOption(jvmElement.getJavaagent() != null && option.startsWith("-Xmx"), jvmName, option, Element.JAVA_AGENT.toString()) || !this.checkOption(jvmElement.getJavaagent() != null && option.startsWith("-XX:PermSize"), jvmName, option, Element.PERMGEN.toString()) || !this.checkOption(jvmElement.getJavaagent() != null && option.startsWith("-XX:MaxPermSize"), jvmName, option, Element.PERMGEN.toString()) || !this.checkOption(jvmElement.isDebugEnabled() != null && jvmElement.isDebugEnabled() != false && jvmElement.getDebugOptions() != null && option.startsWith("-Xrunjdwp"), jvmName, option, Attribute.DEBUG_OPTIONS.toString())) continue;
                    command.add(option);
                }
            }
        }

        boolean checkOption(boolean condition, String jvm, String option, String schemaElement) {
            if (condition) {
                HostControllerLogger.ROOT_LOGGER.optionAlreadySet(option, jvm, schemaElement);
                return false;
            }
            return true;
        }

        abstract void addPermGen(JvmElement var1, List<String> var2);
    }
}

