/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.coordination.HostControllerExecutionSupport;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.dmr.ModelNode;

public class ServerOperationsResolverHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "server-operation-resolver";
    private static final HostControllerExecutionSupport.ServerOperationProvider NO_OP_PROVIDER = new HostControllerExecutionSupport.ServerOperationProvider(){

        @Override
        public Map<Set<ServerIdentity>, ModelNode> getServerOperations(ModelNode domainOp, PathAddress address) {
            return Collections.emptyMap();
        }
    };
    private final ServerOperationResolver resolver;
    private final HostControllerExecutionSupport hostControllerExecutionSupport;
    private final PathAddress originalAddress;
    private final ImmutableManagementResourceRegistration originalRegistration;
    private final ModelNode localResponse;

    ServerOperationsResolverHandler(ServerOperationResolver resolver, HostControllerExecutionSupport hostControllerExecutionSupport, PathAddress originalAddress, ImmutableManagementResourceRegistration originalRegistration, ModelNode response) {
        this.resolver = resolver;
        this.hostControllerExecutionSupport = hostControllerExecutionSupport;
        this.originalAddress = originalAddress;
        this.originalRegistration = originalRegistration;
        this.localResponse = response;
    }

    public void execute(final OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.hasFailureDescription()) {
            this.localResponse.get("failure-description").set(context.getFailureDescription());
            context.setRollbackOnly();
        } else {
            boolean nullDomainOp = this.hostControllerExecutionSupport.getDomainOperation() == null;
            HostControllerExecutionSupport.ServerOperationProvider provider = nullDomainOp ? NO_OP_PROVIDER : new HostControllerExecutionSupport.ServerOperationProvider(){

                @Override
                public Map<Set<ServerIdentity>, ModelNode> getServerOperations(ModelNode domainOp, PathAddress address) {
                    Map ops = ServerOperationsResolverHandler.this.getServerOperations(context, domainOp, address);
                    for (Map.Entry entry : ops.entrySet()) {
                        ModelNode op = (ModelNode)entry.getValue();
                        if (!op.hasDefined("operation-headers") || !op.get("operation-headers").hasDefined("caller-type") || !op.get(new String[]{"operation-headers", "caller-type"}).asString().equals("user")) continue;
                        op.get("operation-headers").remove("caller-type");
                    }
                    return ops;
                }
            };
            Map<ServerIdentity, ModelNode> serverOps = this.hostControllerExecutionSupport.getServerOps(provider);
            ModelNode domainOpResult = nullDomainOp ? new ModelNode("ignored-by-unaffected-host-controller") : (context.hasResult() ? context.getResult() : new ModelNode());
            ModelNode overallResult = this.localResponse == null ? context.getResult() : this.localResponse.get("result");
            this.createOverallResult(serverOps, domainOpResult, overallResult);
            if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("%s responseNode is %s", this.getClass().getSimpleName(), overallResult);
            }
        }
        context.completeStep();
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerOperations(OperationContext context, ModelNode domainOp, PathAddress domainOpAddress) {
        Map<Object, Object> result = null;
        PathAddress relativeAddress = domainOpAddress.subAddress(this.originalAddress.size());
        Set flags = this.originalRegistration.getOperationFlags(relativeAddress, domainOp.require("operation").asString());
        if (flags.contains(OperationEntry.Flag.READ_ONLY) && !flags.contains(OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS)) {
            result = Collections.emptyMap();
        }
        if (result == null) {
            result = this.resolver.getServerOperations(context, domainOp, domainOpAddress);
        }
        return result;
    }

    private void createOverallResult(Map<ServerIdentity, ModelNode> serverOps, ModelNode localResult, ModelNode overallResult) {
        ModelNode domainResult = this.hostControllerExecutionSupport.getFormattedDomainResult(localResult);
        overallResult.get("domain-results").set(domainResult);
        ModelNode serverOpsNode = overallResult.get("server-operations");
        HashMap<ModelNode, HashSet<ServerIdentity>> bundled = new HashMap<ModelNode, HashSet<ServerIdentity>>();
        for (Map.Entry<ServerIdentity, ModelNode> entry : serverOps.entrySet()) {
            HashSet<ServerIdentity> idSet = (HashSet<ServerIdentity>)bundled.get(entry.getValue());
            if (idSet == null) {
                idSet = new HashSet<ServerIdentity>();
                bundled.put(entry.getValue(), idSet);
            }
            idSet.add(entry.getKey());
        }
        for (Map.Entry<ServerIdentity, Object> entry : bundled.entrySet()) {
            ModelNode setNode = serverOpsNode.add();
            ModelNode serverNode = setNode.get("servers");
            serverNode.setEmptyList();
            for (ServerIdentity server : (Set)entry.getValue()) {
                serverNode.add(server.getServerName(), server.getServerGroupName());
            }
            setNode.get("operation").set((ModelNode)entry.getKey());
        }
    }
}

