/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.Set;
import javax.xml.stream.Location;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="JBAS")
public interface DomainControllerLogger
extends BasicLogger {
    public static final DomainControllerLogger ROOT_LOGGER = (DomainControllerLogger)Logger.getMessageLogger(DomainControllerLogger.class, (String)DomainControllerLogger.class.getPackage().getName());
    public static final DomainControllerLogger CONTROLLER_LOGGER = (DomainControllerLogger)Logger.getMessageLogger(DomainControllerLogger.class, (String)"org.jboss.as.controller");
    public static final DomainControllerLogger DEPLOYMENT_LOGGER = (DomainControllerLogger)Logger.getMessageLogger(DomainControllerLogger.class, (String)"org.jboss.as.deployment");
    public static final DomainControllerLogger DOMAIN_DEPLOYMENT_LOGGER = (DomainControllerLogger)Logger.getMessageLogger(DomainControllerLogger.class, (String)"org.jboss.as.domain.deployment");
    public static final DomainControllerLogger HOST_CONTROLLER_LOGGER = (DomainControllerLogger)Logger.getMessageLogger(DomainControllerLogger.class, (String)"org.jboss.as.host.controller");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10800, value="Ignoring 'include' child of 'socket-binding-group' %s")
    public void warnIgnoringSocketBindingGroupInclude(Location var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10801, value="Ignoring 'include' child of 'profile' %s")
    public void warnIgnoringProfileInclude(Location var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10802, value="Interrupted awaiting final response from server %s on host %s")
    public void interruptedAwaitingFinalResponse(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10803, value="Caught exception awaiting final response from server %s on host %s")
    public void caughtExceptionAwaitingFinalResponse(@Cause Throwable var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10804, value="Interrupted awaiting final response from host %s")
    public void interruptedAwaitingFinalResponse(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10805, value="Caught exception awaiting final response from host %s")
    public void caughtExceptionAwaitingFinalResponse(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10806, value="Caught exception closing input stream")
    public void caughtExceptionClosingInputStream(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10807, value="Domain model has changed on re-connect. The following servers will need to be restarted for changes to take affect: %s")
    public void domainModelChangedOnReConnect(Set<ServerIdentity> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10808, value="%s caught %s waiting for task %s")
    public void caughtExceptionWaitingForTask(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10809, value="%s caught %s waiting for task %s; returning")
    public void caughtExceptionWaitingForTaskReturning(String var1, String var2, String var3);
}

