/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.descriptions.HostServerDescription;
import org.jboss.dmr.ModelNode;

public class ServerRemoveHandler
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "remove";
    public static final ServerRemoveHandler INSTANCE = new ServerRemoveHandler();

    protected ServerRemoveHandler() {
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performRemove(context, operation, model);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        final String serverName = address.getLastElement().getValue();
        ModelNode verifyOp = new ModelNode();
        verifyOp.get("operation").set("verify-running-server");
        verifyOp.get("address").add("host", address.getElement(0).getValue());
        context.addStep(context.getResult(), verifyOp, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress serverAddress = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"server", (String)serverName)});
                ProxyController controller = context.getResourceRegistration().getProxyController(serverAddress);
                if (!context.getResourceRegistration().getChildNames(PathAddress.EMPTY_ADDRESS).contains("server")) {
                    throw new OperationFailedException(new ModelNode().set(context.getResourceRegistration().getChildNames(PathAddress.EMPTY_ADDRESS).toString()));
                }
                if (controller != null) {
                    context.getFailureDescription().set(HostControllerMessages.MESSAGES.serverStillRunning(serverName));
                }
                context.completeStep();
            }
        }, OperationContext.Stage.IMMEDIATE);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostServerDescription.getServerRemoveOperation(locale);
    }
}

