/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.RootPlatformMBeanResource;
import org.jboss.dmr.ModelNode;

public class LocalHostAddHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add-host";
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public static LocalHostAddHandler getInstance(LocalHostControllerInfoImpl hostControllerInfo) {
        return new LocalHostAddHandler(hostControllerInfo);
    }

    private LocalHostAddHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        this.hostControllerInfo = hostControllerInfo;
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }

    public void execute(OperationContext context, ModelNode operation) {
        if (!context.isBooting()) {
            throw HostControllerMessages.MESSAGES.invocationNotAllowedAfterBoot(OPERATION_NAME);
        }
        Resource rootResource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = rootResource.getModel();
        HostModelUtil.initCoreModel(model);
        context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management")}));
        rootResource.registerChild(PlatformMBeanConstants.ROOT_PATH, (Resource)new RootPlatformMBeanResource());
        String localHostName = operation.require("name").asString();
        model.get("name").set(localHostName);
        this.hostControllerInfo.setLocalHostName(localHostName);
        context.completeStep();
    }
}

