/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.host.controller.HostCommunicationServices;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.server.DomainServerMain;
import org.jboss.as.server.ServerStartTask;
import org.jboss.as.server.ServerState;
import org.jboss.dmr.ModelNode;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.remoting3.Channel;

class ManagedServer {
    private static final MarshallerFactory MARSHALLER_FACTORY;
    private static final MarshallingConfiguration CONFIG;
    public static String SERVER_PROCESS_NAME_PREFIX;
    private final String hostControllerName;
    private final String serverName;
    private final String serverProcessName;
    private final Object lock = new Object();
    private final ProcessControllerClient processControllerClient;
    private final AtomicInteger respawnCount = new AtomicInteger();
    private final InetSocketAddress managementSocket;
    private final ManagedServerBootConfiguration bootConfiguration;
    private final byte[] authKey;
    private volatile ServerState state;
    private volatile Channel serverManagementChannel;

    public static String getServerProcessName(String serverName) {
        return SERVER_PROCESS_NAME_PREFIX + serverName;
    }

    public static boolean isServerProcess(String serverProcessName) {
        return serverProcessName.startsWith(SERVER_PROCESS_NAME_PREFIX);
    }

    public static String getServerName(String serverProcessName) {
        return serverProcessName.substring(SERVER_PROCESS_NAME_PREFIX.length());
    }

    public ManagedServer(String hostControllerName, String serverName, ProcessControllerClient processControllerClient, InetSocketAddress managementSocket, ManagedServerBootConfiguration bootConfiguration) {
        assert (hostControllerName != null) : "hostControllerName is null";
        assert (serverName != null) : "serverName is null";
        assert (processControllerClient != null) : "processControllerSlave is null";
        assert (managementSocket != null) : "managementSocket is null";
        this.hostControllerName = hostControllerName;
        this.serverName = serverName;
        this.serverProcessName = ManagedServer.getServerProcessName(serverName);
        this.processControllerClient = processControllerClient;
        this.managementSocket = managementSocket;
        this.bootConfiguration = bootConfiguration;
        byte[] authKey = new byte[16];
        new Random().nextBytes(authKey);
        this.authKey = authKey;
        this.state = ServerState.STOPPED;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerProcessName() {
        return this.serverProcessName;
    }

    Channel getServerManagementChannel() {
        return this.serverManagementChannel;
    }

    public ServerState getState() {
        return this.state;
    }

    public void setState(ServerState state) {
        this.state = state;
    }

    void setServerManagementChannel(Channel serverManagementChannel) {
        this.serverManagementChannel = serverManagementChannel;
    }

    int incrementAndGetRespawnCount() {
        return this.respawnCount.incrementAndGet();
    }

    void resetRespawnCount() {
        this.respawnCount.set(0);
    }

    byte[] getAuthKey() {
        return this.authKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createServerProcess() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            List<String> command = this.bootConfiguration.getServerLaunchCommand();
            Map<String, String> env = this.bootConfiguration.getServerLaunchEnvironment();
            HostControllerEnvironment environment = this.bootConfiguration.getHostControllerEnvironment();
            this.processControllerClient.addProcess(this.serverProcessName, this.authKey, command.toArray(new String[command.size()]), environment.getHomeDir().getAbsolutePath(), env);
            this.state = ServerState.BOOTING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startServerProcess() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.setState(ServerState.BOOTING);
            List<ModelNode> bootUpdates = this.bootConfiguration.getBootUpdates();
            this.processControllerClient.startProcess(this.serverProcessName);
            DomainServerMain.HostControllerCommunicationActivator hostControllerCommActivator = HostCommunicationServices.createServerCommuncationActivator(this.managementSocket, this.serverName, this.serverProcessName, this.authKey, this.bootConfiguration.isManagementSubsystemEndpoint());
            ServerStartTask startTask = new ServerStartTask(this.hostControllerName, this.serverName, 0, Collections.singletonList(hostControllerCommActivator), bootUpdates);
            Marshaller marshaller = MARSHALLER_FACTORY.createMarshaller(CONFIG);
            OutputStream os = this.processControllerClient.sendStdin(this.serverProcessName);
            marshaller.start(Marshalling.createByteOutput((OutputStream)os));
            marshaller.writeObject((Object)startTask);
            marshaller.finish();
            marshaller.close();
            os.close();
            this.setState(ServerState.STARTING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnectServerProcess() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.processControllerClient.reconnectProcess(this.serverProcessName, this.managementSocket.getAddress().getHostName(), this.managementSocket.getPort(), this.bootConfiguration.isManagementSubsystemEndpoint(), this.authKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopServerProcess() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.processControllerClient.stopProcess(this.serverProcessName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServerProcess() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.processControllerClient.removeProcess(this.serverProcessName);
        }
    }

    static {
        try {
            MARSHALLER_FACTORY = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Module.getModuleFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)"org.jboss.marshalling.river")).getClassLoader());
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException(e);
        }
        ClassLoader cl = ManagedServer.class.getClassLoader();
        MarshallingConfiguration config = new MarshallingConfiguration();
        config.setVersion(2);
        config.setClassResolver((ClassResolver)new SimpleClassResolver(cl));
        CONFIG = config;
        SERVER_PROCESS_NAME_PREFIX = "Server:";
    }

    public static interface ManagedServerBootConfiguration {
        public List<ModelNode> getBootUpdates();

        public Map<String, String> getServerLaunchEnvironment();

        public List<String> getServerLaunchCommand();

        public HostControllerEnvironment getHostControllerEnvironment();

        public boolean isManagementSubsystemEndpoint();
    }
}

