/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.descriptions.DomainRootDescription;
import org.jboss.as.domain.controller.descriptions.ServerGroupDescription;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.process.ProcessInfo;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DomainServerLifecycleHandlers {
    public static final String RESTART_SERVERS_NAME = "restart-servers";
    public static final String START_SERVERS_NAME = "start-servers";
    public static final String STOP_SERVERS_NAME = "stop-servers";
    private static final int TIMEOUT = 10000;

    public static void initializeServerInventory(ServerInventory serverInventory) {
        StopServersLifecycleHandler.DOMAIN_INSTANCE.setServerInventory(serverInventory);
        StartServersLifecycleHandler.DOMAIN_INSTANCE.setServerInventory(serverInventory);
        RestartServersLifecycleHandler.DOMAIN_INSTANCE.setServerInventory(serverInventory);
        StopServersLifecycleHandler.SERVER_GROUP_INSTANCE.setServerInventory(serverInventory);
        StartServersLifecycleHandler.SERVER_GROUP_INSTANCE.setServerInventory(serverInventory);
        RestartServersLifecycleHandler.SERVER_GROUP_INSTANCE.setServerInventory(serverInventory);
    }

    public static void registerDomainHandlers(ManagementResourceRegistration registration) {
        registration.registerOperationHandler(STOP_SERVERS_NAME, (OperationStepHandler)StopServersLifecycleHandler.DOMAIN_INSTANCE, (DescriptionProvider)StopServersLifecycleHandler.DOMAIN_INSTANCE);
        registration.registerOperationHandler(START_SERVERS_NAME, (OperationStepHandler)StartServersLifecycleHandler.DOMAIN_INSTANCE, (DescriptionProvider)StartServersLifecycleHandler.DOMAIN_INSTANCE);
        registration.registerOperationHandler(RESTART_SERVERS_NAME, (OperationStepHandler)RestartServersLifecycleHandler.DOMAIN_INSTANCE, (DescriptionProvider)RestartServersLifecycleHandler.DOMAIN_INSTANCE);
    }

    public static void registerServerGroupHandlers(ManagementResourceRegistration registration) {
        registration.registerOperationHandler(STOP_SERVERS_NAME, (OperationStepHandler)StopServersLifecycleHandler.SERVER_GROUP_INSTANCE, (DescriptionProvider)StopServersLifecycleHandler.SERVER_GROUP_INSTANCE);
        registration.registerOperationHandler(START_SERVERS_NAME, (OperationStepHandler)StartServersLifecycleHandler.SERVER_GROUP_INSTANCE, (DescriptionProvider)StartServersLifecycleHandler.SERVER_GROUP_INSTANCE);
        registration.registerOperationHandler(RESTART_SERVERS_NAME, (OperationStepHandler)RestartServersLifecycleHandler.SERVER_GROUP_INSTANCE, (DescriptionProvider)RestartServersLifecycleHandler.SERVER_GROUP_INSTANCE);
    }

    private static class RestartServersLifecycleHandler
    extends AbstractHackLifecyleHandler {
        static final String OPERATION_NAME = "restart-servers";
        static final RestartServersLifecycleHandler DOMAIN_INSTANCE = new RestartServersLifecycleHandler(true);
        static final RestartServersLifecycleHandler SERVER_GROUP_INSTANCE = new RestartServersLifecycleHandler(false);

        public RestartServersLifecycleHandler(boolean domain) {
            super(domain);
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final ModelNode model = Resource.Tools.readModel((Resource)context.getRootResource());
                    final String group = RestartServersLifecycleHandler.this.getServerGroupName(operation);
                    context.addStep(new OperationStepHandler(){

                        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                            Map<String, ProcessInfo> processes = RestartServersLifecycleHandler.this.serverInventory.determineRunningProcesses(true);
                            Set<String> serversInGroup = RestartServersLifecycleHandler.this.getServersForGroup(model, group);
                            for (String serverName : processes.keySet()) {
                                String serverModelName = RestartServersLifecycleHandler.this.serverInventory.getProcessServerName(serverName);
                                if (group != null && !serversInGroup.contains(serverModelName)) continue;
                                RestartServersLifecycleHandler.this.serverInventory.restartServer(serverModelName, 10000, model);
                            }
                            context.completeStep();
                        }
                    }, OperationContext.Stage.RUNTIME);
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            if (this.domain) {
                return DomainRootDescription.getRestartServersOperation(locale);
            }
            return ServerGroupDescription.getRestartServersOperation(locale);
        }
    }

    private static class StartServersLifecycleHandler
    extends AbstractHackLifecyleHandler {
        static final String OPERATION_NAME = "start-servers";
        static final StartServersLifecycleHandler DOMAIN_INSTANCE = new StartServersLifecycleHandler(true);
        static final StartServersLifecycleHandler SERVER_GROUP_INSTANCE = new StartServersLifecycleHandler(false);

        public StartServersLifecycleHandler(boolean domain) {
            super(domain);
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final ModelNode model = Resource.Tools.readModel((Resource)context.getRootResource());
            final String group = this.getServerGroupName(operation);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    String hostName = (String)model.get("host").keys().iterator().next();
                    ModelNode serverConfig = model.get(new String[]{"host", hostName}).get("server-config");
                    Set<String> serversInGroup = StartServersLifecycleHandler.this.getServersForGroup(model, group);
                    for (Property config : serverConfig.asPropertyList()) {
                        ServerStatus status = StartServersLifecycleHandler.this.serverInventory.determineServerStatus(config.getName());
                        if (status == ServerStatus.STARTING || status == ServerStatus.STARTED || group != null && !serversInGroup.contains(config.getName())) continue;
                        if (status != ServerStatus.STOPPED) {
                            StartServersLifecycleHandler.this.serverInventory.stopServer(config.getName(), 10000);
                        }
                        StartServersLifecycleHandler.this.serverInventory.startServer(config.getName(), model);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            if (this.domain) {
                return DomainRootDescription.getStartServersOperation(locale);
            }
            return ServerGroupDescription.getStartServersOperation(locale);
        }
    }

    private static class StopServersLifecycleHandler
    extends AbstractHackLifecyleHandler {
        static final String OPERATION_NAME = "stop-servers";
        static final StopServersLifecycleHandler DOMAIN_INSTANCE = new StopServersLifecycleHandler(true);
        static final StopServersLifecycleHandler SERVER_GROUP_INSTANCE = new StopServersLifecycleHandler(false);

        public StopServersLifecycleHandler(boolean domain) {
            super(domain);
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final String group = this.getServerGroupName(operation);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    if (group != null) {
                        ModelNode model = Resource.Tools.readModel((Resource)context.getRootResource());
                        for (String server : StopServersLifecycleHandler.this.getServersForGroup(model, group)) {
                            StopServersLifecycleHandler.this.serverInventory.stopServer(server, 10000);
                        }
                    } else {
                        StopServersLifecycleHandler.this.serverInventory.stopServers(10000);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            if (this.domain) {
                return DomainRootDescription.getStopServersOperation(locale);
            }
            return ServerGroupDescription.getStopServersOperation(locale);
        }
    }

    private static abstract class AbstractHackLifecyleHandler
    implements OperationStepHandler,
    DescriptionProvider {
        volatile ServerInventory serverInventory;
        final boolean domain;

        protected AbstractHackLifecyleHandler(boolean domain) {
            this.domain = domain;
        }

        void setServerInventory(ServerInventory serverInventory) {
            this.serverInventory = serverInventory;
        }

        String getServerGroupName(ModelNode operation) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            if (address.size() == 0) {
                return null;
            }
            return address.getLastElement().getValue();
        }

        Set<String> getServersForGroup(ModelNode model, String groupName) {
            if (groupName == null) {
                return Collections.emptySet();
            }
            String hostName = (String)model.get("host").keys().iterator().next();
            ModelNode serverConfig = model.get(new String[]{"host", hostName}).get("server-config");
            HashSet<String> servers = new HashSet<String>();
            for (Property config : serverConfig.asPropertyList()) {
                if (!groupName.equals(config.getValue().get("group").asString())) continue;
                servers.add(config.getName());
            }
            return servers;
        }
    }
}

