/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.List;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;

@MessageBundle(projectCode="JBAS")
public interface DomainControllerMessages {
    public static final DomainControllerMessages MESSAGES = (DomainControllerMessages)Messages.getBundle(DomainControllerMessages.class);

    @Message(id=15830, value="Registration of remote hosts is not supported on slave host controllers")
    public String slaveControllerCannotAcceptOtherSlaves();

    @Message(id=15831, value="The master host controller cannot register slave host controllers as it's current running mode is '%s'")
    public String adminOnlyModeCannotAcceptSlaves(RunningMode var1);

    @Message(id=15832, value="There is already a registered host named '%s'")
    public String slaveAlreadyRegistered(String var1);

    @Message(id=15833, value="%s is missing %s: %s")
    public String requiredChildIsMissing(String var1, String var2, String var3);

    @Message(id=15834, value="%s recognizes only %s as children: %s")
    public String unrecognizedChildren(String var1, String var2, String var3);

    @Message(id=15835, value="in-series is missing groups: %s")
    public String inSeriesIsMissingGroups(String var1);

    @Message(id=15836, value="server-group expects one and only one child: %s")
    public String serverGroupExpectsSingleChild(String var1);

    @Message(id=15837, value="One of the groups does not define neither server-group nor concurrent-groups: %s")
    public String unexpectedInSeriesGroup(String var1);

    @Message(id=15838, value="Unexplained failure")
    public String unexplainedFailure();

    @Message(id=15839, value="Operation failed or was rolled back on all servers.")
    public String operationFailedOrRolledBack();

    @Message(id=15840, value="Interrupted waiting for result from server %s")
    public String interruptedAwaitingResultFromServer(ServerIdentity var1);

    @Message(id=15841, value="Exception getting result from server %s: %s")
    public String exceptionAwaitingResultFromServer(ServerIdentity var1, String var2);

    @Message(id=15842, value="Invalid rollout plan. %s is not a valid child of node %s")
    public String invalidRolloutPlan(ModelNode var1, String var2);

    @Message(id=15843, value="Invalid rollout plan. Plan operations affect server groups %s that are not reflected in the rollout plan")
    public String invalidRolloutPlan(Set<String> var1);

    @Message(id=15844, value="Invalid rollout plan. Server group %s appears more than once in the plan.")
    public String invalidRolloutPlanGroupAlreadyExists(String var1);

    @Message(id=15845, value="Invalid rollout plan. Server group %s has a %s value of %s; must be between 0 and 100.")
    public String invalidRolloutPlanRange(String var1, String var2, int var3);

    @Message(id=15846, value="Invalid rollout plan. Server group %s has a %s value of %s; cannot be less than 0.")
    public String invalidRolloutPlanLess(String var1, String var2, int var3);

    @Message(id=15847, value="Interrupted waiting for result from host %s")
    public String interruptedAwaitingResultFromHost(String var1);

    @Message(id=15848, value="Exception getting result from host %s: %s")
    public String exceptionAwaitingResultFromHost(String var1, String var2);

    @Message(id=15849, value="Operation %s for address %s can only be handled by the master Domain Controller; this host is not the master Domain Controller")
    public String masterDomainControllerOnlyOperation(String var1, PathAddress var2);

    @Message(id=15850, value="No handler for operation %s at address %s")
    public String noHandlerForOperation(String var1, PathAddress var2);

    @Message(id=15851, value="Operation targets host %s but that host is not registered")
    public String invalidOperationTargetHost(String var1);

    @Message(id=15852, value="Caught %s storing deployment content -- %s")
    public String caughtExceptionStoringDeploymentContent(String var1, Throwable var2);

    @Message(id=15853, value="Unexpected initial path key %s")
    public IllegalStateException unexpectedInitialPathKey(String var1);

    @Message(id=15854, value="Null stream at index %d")
    public String nullStream(int var1);

    @Message(id=15855, value="Invalid byte stream.")
    public String invalidByteStream();

    @Message(id=15856, value="Invalid url stream.")
    public String invalidUrlStream();

    @Message(id=15857, value="Only 1 piece of content is currently supported (AS7-431)")
    public String as7431();

    @Message(id=15858, value="No deployment content with hash %s is available in the deployment content repository.")
    public String noDeploymentContentWithHash(String var1);

    @Message(id=15859, value="A slave domain controller cannot accept deployment content uploads")
    public String slaveCannotAcceptUploads();

    @Message(id=15860, value="No deployment with name %s found")
    public String noDeploymentContentWithName(String var1);

    @Message(id=15861, value="Cannot remove deployment %s from the domain as it is still used by server groups %s")
    public String cannotRemoveDeploymentInUse(String var1, List<String> var2);

    @Message(id=15862, value="Invalid '%s' value: %d, the maximum index is %d")
    public String invalidValue(String var1, int var2, int var3);

    @Message(id=15863, value="%s is not a valid URL -- %s")
    public String invalidUrl(String var1, String var2);

    @Message(id=15864, value="Error obtaining input stream from URL %s -- %s")
    public String errorObtainingUrlStream(String var1, String var2);

    @Message(id=15865, value="Invalid content declaration")
    public String invalidContentDeclaration();

    @Message(id=15866, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=15867, value="Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.")
    public String cannotUseSameValueForParameters(String var1, String var2, String var3, String var4, String var5);

    @Message(id=15868, value="Deployment %s is already started")
    public String deploymentAlreadyStarted(String var1);

    @Message(id=15869, value="Unknown %s %s")
    public String unknown(String var1, String var2);

    @Message(id=15870, value="Unknown server group %s")
    public IllegalStateException unknownServerGroup(String var1);

    @Message(id=15871, value="Unknown server %s")
    public IllegalStateException unknownServer(ServerIdentity var1);

    @Message(id=15872, value="Invalid code %d")
    public IllegalArgumentException invalidCode(int var1);
}

