/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.EnumSet;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ExtensionContextImpl;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.operations.common.ExtensionRemoveHandler;
import org.jboss.as.controller.operations.common.InterfaceCriteriaWriteHandler;
import org.jboss.as.controller.operations.common.JVMHandlers;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.common.PathAddHandler;
import org.jboss.as.controller.operations.common.PathRemoveHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationRemoveHandler;
import org.jboss.as.controller.operations.common.SnapshotDeleteHandler;
import org.jboss.as.controller.operations.common.SnapshotListHandler;
import org.jboss.as.controller.operations.common.SnapshotTakeHandler;
import org.jboss.as.controller.operations.common.SystemPropertyAddHandler;
import org.jboss.as.controller.operations.common.SystemPropertyRemoveHandler;
import org.jboss.as.controller.operations.common.SystemPropertyValueWriteAttributeHandler;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.UnregisteredHostChannelRegistry;
import org.jboss.as.domain.management.operations.ConnectionAddHandler;
import org.jboss.as.domain.management.operations.SecurityRealmAddHandler;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.RemoteDomainConnectionService;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostDescriptionProviders;
import org.jboss.as.host.controller.operations.HostShutdownHandler;
import org.jboss.as.host.controller.operations.HostSpecifiedInterfaceAddHandler;
import org.jboss.as.host.controller.operations.HostSpecifiedInterfaceRemoveHandler;
import org.jboss.as.host.controller.operations.HostXmlMarshallingHandler;
import org.jboss.as.host.controller.operations.HttpManagementAddHandler;
import org.jboss.as.host.controller.operations.HttpManagementAttributeHandlers;
import org.jboss.as.host.controller.operations.IsMasterHandler;
import org.jboss.as.host.controller.operations.LocalDomainControllerAddHandler;
import org.jboss.as.host.controller.operations.LocalDomainControllerRemoveHandler;
import org.jboss.as.host.controller.operations.LocalHostAddHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.operations.NativeManagementAddHandler;
import org.jboss.as.host.controller.operations.NativeManagementAttributeHandlers;
import org.jboss.as.host.controller.operations.RemoteDomainControllerAddHandler;
import org.jboss.as.host.controller.operations.RemoteDomainControllerRemoveHandler;
import org.jboss.as.host.controller.operations.ServerAddHandler;
import org.jboss.as.host.controller.operations.ServerRemoveHandler;
import org.jboss.as.host.controller.operations.ServerRestartHandler;
import org.jboss.as.host.controller.operations.ServerStartHandler;
import org.jboss.as.host.controller.operations.ServerStatusHandler;
import org.jboss.as.host.controller.operations.ServerStopHandler;
import org.jboss.as.host.controller.operations.StartServersHandler;
import org.jboss.as.server.operations.ExtensionAddHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceAddHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceRemoveHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HostModelUtil {
    public static void initCoreModel(ModelNode root) {
        root.get("name");
        root.get("namespaces").setEmptyList();
        root.get("schema-locations").setEmptyList();
        root.get("extension");
        root.get("system-property");
        root.get("path");
        root.get("core-service");
        root.get("server-config");
        root.get("domain-controller");
        root.get("interface");
        root.get("jvm");
        root.get("server");
    }

    public static void createHostRegistry(ManagementResourceRegistration root, HostControllerConfigurationPersister configurationPersister, HostControllerEnvironment environment, FileRepository localFileRepository, LocalHostControllerInfoImpl hostControllerInfo, ServerInventory serverInventory, RemoteDomainConnectionService.RemoteFileRepository remoteFileRepository, DomainController domainController, UnregisteredHostChannelRegistry registry) {
        ManagementResourceRegistration hostRegistration = root.registerSubModel(PathElement.pathElement((String)"host"), HostDescriptionProviders.HOST_ROOT_PROVIDER);
        LocalHostAddHandler handler = LocalHostAddHandler.getInstance(hostControllerInfo);
        hostRegistration.registerOperationHandler("add-host", (OperationStepHandler)handler, (DescriptionProvider)handler, false, OperationEntry.EntryType.PRIVATE);
        EnumSet<OperationEntry.Flag> flags = EnumSet.of(OperationEntry.Flag.READ_ONLY);
        root.registerOperationHandler("read-resource", GlobalOperationHandlers.READ_RESOURCE, CommonProviders.READ_RESOURCE_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-attribute", GlobalOperationHandlers.READ_ATTRIBUTE, CommonProviders.READ_ATTRIBUTE_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-resource-description", GlobalOperationHandlers.READ_RESOURCE_DESCRIPTION, CommonProviders.READ_RESOURCE_DESCRIPTION_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-children-names", GlobalOperationHandlers.READ_CHILDREN_NAMES, CommonProviders.READ_CHILDREN_NAMES_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-children-types", GlobalOperationHandlers.READ_CHILDREN_TYPES, CommonProviders.READ_CHILDREN_TYPES_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-children-resources", GlobalOperationHandlers.READ_CHILDREN_RESOURCES, CommonProviders.READ_CHILDREN_RESOURCES_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-operation-names", GlobalOperationHandlers.READ_OPERATION_NAMES, CommonProviders.READ_OPERATION_NAMES_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("read-operation-description", GlobalOperationHandlers.READ_OPERATION_DESCRIPTION, CommonProviders.READ_OPERATION_PROVIDER, true, OperationEntry.EntryType.PUBLIC, flags);
        root.registerOperationHandler("write-attribute", GlobalOperationHandlers.WRITE_ATTRIBUTE, CommonProviders.WRITE_ATTRIBUTE_PROVIDER, true);
        HostXmlMarshallingHandler xmh = new HostXmlMarshallingHandler((ConfigurationPersister)configurationPersister.getHostPersister(), hostControllerInfo);
        hostRegistration.registerOperationHandler("read-config-as-xml", (OperationStepHandler)xmh, (DescriptionProvider)xmh, false, OperationEntry.EntryType.PUBLIC, flags);
        hostRegistration.registerOperationHandler("add-namespace", (OperationStepHandler)NamespaceAddHandler.INSTANCE, (DescriptionProvider)NamespaceAddHandler.INSTANCE, false);
        hostRegistration.registerOperationHandler("remove-namespace", (OperationStepHandler)NamespaceRemoveHandler.INSTANCE, (DescriptionProvider)NamespaceRemoveHandler.INSTANCE, false);
        hostRegistration.registerOperationHandler("add-schema-location", (OperationStepHandler)SchemaLocationAddHandler.INSTANCE, (DescriptionProvider)SchemaLocationAddHandler.INSTANCE, false);
        hostRegistration.registerOperationHandler("remove-schema-location", (OperationStepHandler)SchemaLocationRemoveHandler.INSTANCE, (DescriptionProvider)SchemaLocationRemoveHandler.INSTANCE, false);
        hostRegistration.registerReadWriteAttribute("name", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        hostRegistration.registerReadOnlyAttribute("master", (OperationStepHandler)IsMasterHandler.INSTANCE, AttributeAccess.Storage.RUNTIME);
        StartServersHandler ssh = new StartServersHandler(environment, serverInventory);
        hostRegistration.registerOperationHandler("start-servers", (OperationStepHandler)ssh, (DescriptionProvider)ssh, false, OperationEntry.EntryType.PRIVATE);
        HostShutdownHandler hsh = new HostShutdownHandler(domainController);
        hostRegistration.registerOperationHandler("shutdown", (OperationStepHandler)hsh, (DescriptionProvider)hsh);
        ManagementResourceRegistration sysProps = hostRegistration.registerSubModel(PathElement.pathElement((String)"system-property"), HostDescriptionProviders.SYSTEM_PROPERTIES_PROVIDER);
        sysProps.registerOperationHandler("add", (OperationStepHandler)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, false);
        sysProps.registerOperationHandler("remove", (OperationStepHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        sysProps.registerReadWriteAttribute("value", null, (OperationStepHandler)SystemPropertyValueWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        sysProps.registerReadWriteAttribute("boot-time", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration management = hostRegistration.registerSubModel(PathElement.pathElement((String)"core-service", (String)"management"), CommonProviders.MANAGEMENT_WITH_INTERFACES_PROVIDER);
        ManagementResourceRegistration securityRealm = management.registerSubModel(PathElement.pathElement((String)"security-realm"), CommonProviders.MANAGEMENT_SECURITY_REALM_PROVIDER);
        securityRealm.registerOperationHandler("add", (OperationStepHandler)SecurityRealmAddHandler.INSTANCE, (DescriptionProvider)SecurityRealmAddHandler.INSTANCE, false);
        ManagementResourceRegistration connection = management.registerSubModel(PathElement.pathElement((String)"outbound-connection"), CommonProviders.MANAGEMENT_OUTBOUND_CONNECTION_PROVIDER);
        connection.registerOperationHandler("add", (OperationStepHandler)ConnectionAddHandler.INSTANCE, (DescriptionProvider)ConnectionAddHandler.INSTANCE, false);
        ManagementResourceRegistration managementNative = management.registerSubModel(PathElement.pathElement((String)"management-interface", (String)"native-interface"), CommonProviders.NATIVE_MANAGEMENT_PROVIDER);
        NativeManagementAddHandler nmah = new NativeManagementAddHandler(hostControllerInfo);
        managementNative.registerOperationHandler("add", (OperationStepHandler)nmah, (DescriptionProvider)nmah, false);
        managementNative.registerReadWriteAttribute("security-realm", null, (OperationStepHandler)new NativeManagementAttributeHandlers.NativeManagementAttributeHandler(hostControllerInfo), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration managementHttp = management.registerSubModel(PathElement.pathElement((String)"management-interface", (String)"http-interface"), CommonProviders.HTTP_MANAGEMENT_PROVIDER);
        HttpManagementAddHandler httpAddHandler = HttpManagementAddHandler.getInstance(hostControllerInfo);
        managementHttp.registerOperationHandler("add", (OperationStepHandler)httpAddHandler, (DescriptionProvider)httpAddHandler, false);
        managementHttp.registerReadWriteAttribute("security-realm", null, (OperationStepHandler)new HttpManagementAttributeHandlers.HttpManagementAttributeHandler(hostControllerInfo, environment), AttributeAccess.Storage.CONFIGURATION);
        LocalDomainControllerAddHandler localDcAddHandler = LocalDomainControllerAddHandler.getInstance(root, hostControllerInfo, environment, configurationPersister, localFileRepository, domainController, registry);
        hostRegistration.registerOperationHandler("write-local-domain-controller", (OperationStepHandler)localDcAddHandler, (DescriptionProvider)localDcAddHandler, false);
        hostRegistration.registerOperationHandler("remove-local-domain-controller", (OperationStepHandler)LocalDomainControllerRemoveHandler.INSTANCE, (DescriptionProvider)LocalDomainControllerRemoveHandler.INSTANCE, false);
        RemoteDomainControllerAddHandler remoteDcAddHandler = RemoteDomainControllerAddHandler.getInstance(root, hostControllerInfo, configurationPersister, remoteFileRepository);
        hostRegistration.registerOperationHandler("write-remote-domain-controller", (OperationStepHandler)remoteDcAddHandler, (DescriptionProvider)remoteDcAddHandler, false);
        hostRegistration.registerOperationHandler("remove-remote-domain-controller", (OperationStepHandler)RemoteDomainControllerRemoveHandler.INSTANCE, (DescriptionProvider)RemoteDomainControllerRemoveHandler.INSTANCE, false);
        SnapshotDeleteHandler snapshotDelete = new SnapshotDeleteHandler((ConfigurationPersister)configurationPersister.getHostPersister());
        hostRegistration.registerOperationHandler("delete-snapshot", (OperationStepHandler)snapshotDelete, (DescriptionProvider)snapshotDelete, false);
        SnapshotListHandler snapshotList = new SnapshotListHandler((ConfigurationPersister)configurationPersister.getHostPersister());
        hostRegistration.registerOperationHandler("list-snapshots", (OperationStepHandler)snapshotList, (DescriptionProvider)snapshotList, false);
        SnapshotTakeHandler snapshotTake = new SnapshotTakeHandler((ConfigurationPersister)configurationPersister.getHostPersister());
        hostRegistration.registerOperationHandler("take-snapshot", (OperationStepHandler)snapshotTake, (DescriptionProvider)snapshotTake, false);
        ManagementResourceRegistration extensions = hostRegistration.registerSubModel(PathElement.pathElement((String)"extension"), CommonProviders.EXTENSION_PROVIDER);
        ExtensionContextImpl extensionContext = new ExtensionContextImpl(hostRegistration, null, (SubsystemXmlWriterRegistry)configurationPersister);
        ExtensionAddHandler addExtensionHandler = new ExtensionAddHandler((ExtensionContext)extensionContext);
        extensions.registerOperationHandler("add", (OperationStepHandler)addExtensionHandler, (DescriptionProvider)addExtensionHandler, false);
        extensions.registerOperationHandler("remove", (OperationStepHandler)ExtensionRemoveHandler.INSTANCE, (DescriptionProvider)ExtensionRemoveHandler.INSTANCE, false);
        ManagementResourceRegistration jvms = hostRegistration.registerSubModel(PathElement.pathElement((String)"jvm"), CommonProviders.JVM_PROVIDER);
        JVMHandlers.register((ManagementResourceRegistration)jvms);
        ManagementResourceRegistration paths = hostRegistration.registerSubModel(PathElement.pathElement((String)"path"), CommonProviders.SPECIFIED_PATH_PROVIDER);
        paths.registerOperationHandler("add", (OperationStepHandler)PathAddHandler.SPECIFIED_INSTANCE, (DescriptionProvider)PathAddHandler.SPECIFIED_INSTANCE, false);
        paths.registerOperationHandler("remove", (OperationStepHandler)PathRemoveHandler.INSTANCE, (DescriptionProvider)PathRemoveHandler.INSTANCE, false);
        ManagementResourceRegistration interfaces = hostRegistration.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        HostSpecifiedInterfaceAddHandler hsiah = new HostSpecifiedInterfaceAddHandler(hostControllerInfo);
        interfaces.registerOperationHandler("add", (OperationStepHandler)hsiah, (DescriptionProvider)hsiah, false);
        HostSpecifiedInterfaceRemoveHandler sirh = new HostSpecifiedInterfaceRemoveHandler(hostControllerInfo);
        interfaces.registerOperationHandler("remove", (OperationStepHandler)sirh, (DescriptionProvider)sirh, false);
        interfaces.registerReadWriteAttribute("criteria", null, InterfaceCriteriaWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration servers = hostRegistration.registerSubModel(PathElement.pathElement((String)"server-config"), HostDescriptionProviders.SERVER_PROVIDER);
        servers.registerOperationHandler("add", (OperationStepHandler)ServerAddHandler.INSTANCE, (DescriptionProvider)ServerAddHandler.INSTANCE, false);
        servers.registerOperationHandler("remove", (OperationStepHandler)ServerRemoveHandler.INSTANCE, (DescriptionProvider)ServerRemoveHandler.INSTANCE, false);
        servers.registerReadWriteAttribute("auto-start", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("socket-binding-group", null, (OperationStepHandler)WriteAttributeHandlers.WriteAttributeOperationHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("socket-binding-port-offset", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0), AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("priority", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0), AttributeAccess.Storage.CONFIGURATION);
        servers.registerReadWriteAttribute("cpu-affinity", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        servers.registerMetric("status", (OperationStepHandler)new ServerStatusHandler(serverInventory));
        ServerStartHandler startHandler = new ServerStartHandler(serverInventory);
        servers.registerOperationHandler("start", (OperationStepHandler)startHandler, (DescriptionProvider)startHandler, false);
        ServerRestartHandler restartHandler = new ServerRestartHandler(serverInventory);
        servers.registerOperationHandler("restart", (OperationStepHandler)restartHandler, (DescriptionProvider)restartHandler, false);
        ServerStopHandler stopHandler = new ServerStopHandler(serverInventory);
        servers.registerOperationHandler("stop", (OperationStepHandler)stopHandler, (DescriptionProvider)stopHandler, false);
        ManagementResourceRegistration serverPaths = servers.registerSubModel(PathElement.pathElement((String)"path"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        serverPaths.registerOperationHandler("add", (OperationStepHandler)PathAddHandler.SPECIFIED_INSTANCE, (DescriptionProvider)PathAddHandler.SPECIFIED_INSTANCE, false);
        serverPaths.registerOperationHandler("remove", (OperationStepHandler)PathRemoveHandler.INSTANCE, (DescriptionProvider)PathRemoveHandler.INSTANCE, false);
        ManagementResourceRegistration serverInterfaces = servers.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.SPECIFIED_INTERFACE_PROVIDER);
        serverInterfaces.registerOperationHandler("add", (OperationStepHandler)SpecifiedInterfaceAddHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceAddHandler.INSTANCE, false);
        serverInterfaces.registerOperationHandler("remove", (OperationStepHandler)SpecifiedInterfaceRemoveHandler.INSTANCE, (DescriptionProvider)SpecifiedInterfaceRemoveHandler.INSTANCE, false);
        serverInterfaces.registerReadWriteAttribute("criteria", null, InterfaceCriteriaWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration serverSysProps = servers.registerSubModel(PathElement.pathElement((String)"system-property"), HostDescriptionProviders.SERVER_SYSTEM_PROPERTIES_PROVIDER);
        serverSysProps.registerOperationHandler("add", (OperationStepHandler)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, false);
        serverSysProps.registerOperationHandler("remove", (OperationStepHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        serverSysProps.registerReadWriteAttribute("value", null, (OperationStepHandler)SystemPropertyValueWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        serverSysProps.registerReadWriteAttribute("boot-time", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration serverVMs = servers.registerSubModel(PathElement.pathElement((String)"jvm"), JVMHandlers.SERVER_MODEL_PROVIDER);
        JVMHandlers.register((ManagementResourceRegistration)serverVMs, (boolean)true);
    }

    public static void registerServerInventory(ServerInventory serverInventory) {
    }
}

