/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.parsing.JvmType;
import org.jboss.as.host.controller.JvmOptionsElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class JvmElement {
    private static final long serialVersionUID = 4963103173530602991L;
    private final String name;
    private JvmType type = JvmType.SUN;
    private String javaHome;
    private Boolean debugEnabled;
    private String debugOptions;
    private Boolean envClasspathIgnored;
    private String heapSize;
    private String maxHeap;
    private String permgenSize;
    private String maxPermgen;
    private String agentPath;
    private String agentLib;
    private String javaagent;
    private String stack;
    private final JvmOptionsElement jvmOptionsElement = new JvmOptionsElement();
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    private Map<String, String> systemProperties = new HashMap<String, String>();

    public JvmElement(String name) {
        this.name = name;
    }

    public JvmElement(String name, ModelNode ... toCombine) {
        this.name = name;
        for (ModelNode node : toCombine) {
            if (node == null) continue;
            if (node.hasDefined("agent-lib")) {
                this.agentLib = node.get("agent-lib").asString();
            }
            if (node.hasDefined("agent-path")) {
                this.agentPath = node.get("agent-path").asString();
            }
            if (node.hasDefined("debug-enabled")) {
                this.debugEnabled = node.get("debug-enabled").asBoolean();
            }
            if (node.hasDefined("debug-options")) {
                this.debugOptions = node.get("debug-options").asString();
            }
            if (node.hasDefined("env-classpath-ignored")) {
                this.envClasspathIgnored = node.get("env-classpath-ignored").asBoolean();
            }
            if (node.hasDefined("environment-variables")) {
                for (Property property : node.get("environment-variables").asPropertyList()) {
                    this.environmentVariables.put(property.getName(), property.getValue().asString());
                }
            }
            if (node.hasDefined("heap")) {
                ModelNode heap = node.get("heap");
                if (heap.hasDefined("size")) {
                    this.heapSize = heap.get("size").asString();
                }
                if (heap.hasDefined("max-size")) {
                    this.maxHeap = heap.get("max-size").asString();
                }
            }
            if (node.hasDefined("javaagent")) {
                this.javaagent = node.get("javaagent").asString();
            }
            if (node.hasDefined("java-home")) {
                this.javaHome = node.get("java-home").asString();
            }
            if (node.hasDefined("jvm-options")) {
                for (ModelNode option : node.get("jvm-options").asList()) {
                    this.jvmOptionsElement.addOption(option.asString());
                }
            }
            if (node.hasDefined("permgen")) {
                ModelNode permGen = node.get("permgen");
                if (permGen.hasDefined("size")) {
                    this.permgenSize = permGen.get("size").asString();
                }
                if (permGen.hasDefined("max-size")) {
                    this.maxPermgen = permGen.get("max-size").asString();
                }
            }
            if (node.hasDefined("stack-size")) {
                this.stack = node.get("stack-size").asString();
            }
            if (!node.hasDefined("system-properties")) continue;
            for (Property property : node.get("system-properties").asPropertyList()) {
                ModelNode value = property.getValue();
                this.systemProperties.put(property.getName(), JvmElement.isDefined(value) ? value.asString() : "true");
            }
        }
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public JvmType getJvmType() {
        return this.type;
    }

    void setJvmType(JvmType type) {
        this.type = type;
    }

    public String getPermgenSize() {
        return this.permgenSize;
    }

    void setPermgenSize(String permgenSize) {
        this.permgenSize = permgenSize;
    }

    public String getMaxPermgen() {
        return this.maxPermgen;
    }

    void setMaxPermgen(String maxPermgen) {
        this.maxPermgen = maxPermgen;
    }

    public String getHeapSize() {
        return this.heapSize;
    }

    void setHeapSize(String heapSize) {
        this.heapSize = heapSize;
    }

    public String getMaxHeap() {
        return this.maxHeap;
    }

    void setMaxHeap(String maxHeap) {
        this.maxHeap = maxHeap;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    void setDebugEnabled(Boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public String getDebugOptions() {
        return this.debugOptions;
    }

    void setDebugOptions(String debugOptions) {
        this.debugOptions = debugOptions;
    }

    public String getStack() {
        return this.stack;
    }

    void setStack(String stack) {
        this.stack = stack;
    }

    public Boolean isEnvClasspathIgnored() {
        return this.envClasspathIgnored;
    }

    void setEnvClasspathIgnored(Boolean envClasspathIgnored) {
        this.envClasspathIgnored = envClasspathIgnored;
    }

    public JvmOptionsElement getJvmOptions() {
        return this.jvmOptionsElement;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public String getAgentPath() {
        return this.agentPath;
    }

    void setAgentPath(String agentPath) {
        if (this.agentLib != null) {
            throw new IllegalArgumentException("Attempting to set 'agent-path' when 'agent-lib' was already set");
        }
        this.agentPath = agentPath;
    }

    public String getAgentLib() {
        return this.agentLib;
    }

    void setAgentLib(String agentLib) {
        if (this.agentPath != null) {
            throw new IllegalArgumentException("Attempting to set 'agent-lib' when 'agent-path' was already set");
        }
        this.agentLib = agentLib;
    }

    public String getJavaagent() {
        return this.javaagent;
    }

    void setJavaagent(String javaagent) {
        this.javaagent = javaagent;
    }

    static boolean isDefined(ModelNode node) {
        return node.getType() != ModelType.UNDEFINED;
    }
}

