/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.SubsystemInformation;
import org.jboss.as.controller.registry.OperationTransformerRegistry;
import org.jboss.as.controller.transform.CompositeOperationTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.dmr.ModelNode;

public class TransformationTargetImpl
implements TransformationTarget {
    private final ModelVersion version;
    private final ExtensionRegistry extensionRegistry;
    private final TransformerRegistry transformerRegistry;
    private final Map<String, ModelVersion> subsystemVersions = Collections.synchronizedMap(new HashMap());
    private final OperationTransformerRegistry operationTransformers;
    private final TransformationTarget.TransformationTargetType type;

    private TransformationTargetImpl(TransformerRegistry transformerRegistry, ModelVersion version, Map<PathAddress, ModelVersion> subsystemVersions, OperationTransformerRegistry transformers, TransformationTarget.TransformationTargetType type) {
        this.version = version;
        this.transformerRegistry = transformerRegistry;
        this.extensionRegistry = transformerRegistry.getExtensionRegistry();
        for (Map.Entry<PathAddress, ModelVersion> p : subsystemVersions.entrySet()) {
            String name = p.getKey().getLastElement().getValue();
            this.subsystemVersions.put(name, p.getValue());
        }
        this.operationTransformers = transformers;
        this.type = type;
    }

    public static TransformationTargetImpl create(TransformerRegistry transformerRegistry, ModelVersion version, ModelNode subsystems, TransformationTarget.TransformationTargetType type) {
        return TransformationTargetImpl.create(transformerRegistry, version, TransformerRegistry.resolveVersions(subsystems), type);
    }

    public static TransformationTargetImpl create(TransformerRegistry transformerRegistry, ModelVersion version, Map<PathAddress, ModelVersion> subsystems, TransformationTarget.TransformationTargetType type) {
        OperationTransformerRegistry registry;
        switch (type) {
            case SERVER: {
                registry = transformerRegistry.resolveServer(version, subsystems);
                break;
            }
            default: {
                registry = transformerRegistry.resolveHost(version, subsystems);
            }
        }
        return new TransformationTargetImpl(transformerRegistry, version, subsystems, registry, type);
    }

    @Deprecated
    public static TransformationTargetImpl create(TransformerRegistry transformerRegistry, int majorManagementVersion, int minorManagementVersion, int microManagementVersion, ModelNode subsystemVersions) {
        return TransformationTargetImpl.create(transformerRegistry, ModelVersion.create(majorManagementVersion, minorManagementVersion, microManagementVersion), subsystemVersions, TransformationTarget.TransformationTargetType.HOST);
    }

    @Override
    public ModelVersion getVersion() {
        return this.version;
    }

    @Override
    public ModelVersion getSubsystemVersion(String subsystemName) {
        return this.subsystemVersions.get(subsystemName);
    }

    public SubsystemInformation getSubsystemInformation(String subsystemName) {
        return this.extensionRegistry.getSubsystemInfo(subsystemName);
    }

    @Override
    public ResourceTransformer resolveTransformer(PathAddress address) {
        OperationTransformerRegistry.ResourceTransformerEntry entry = this.operationTransformers.resolveResourceTransformer(address);
        if (entry == null) {
            return ResourceTransformer.DEFAULT;
        }
        return entry.getTransformer();
    }

    @Override
    public OperationTransformer resolveTransformer(PathAddress address, String operationName) {
        if (address.size() == 0 && "composite".equals(operationName)) {
            return new CompositeOperationTransformer();
        }
        OperationTransformerRegistry.OperationTransformerEntry entry = this.operationTransformers.resolveOperationTransformer(address, operationName);
        return entry.getTransformer();
    }

    @Override
    public void addSubsystemVersion(String subsystemName, int majorVersion, int minorVersion) {
        this.addSubsystemVersion(subsystemName, ModelVersion.create(majorVersion, minorVersion));
    }

    @Override
    public void addSubsystemVersion(String subsystemName, ModelVersion version) {
        this.subsystemVersions.put(subsystemName, version);
        this.transformerRegistry.addSubsystem(this.operationTransformers, subsystemName, version);
    }

    @Override
    public TransformationTarget.TransformationTargetType getTargetType() {
        return this.type;
    }

    @Override
    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }
}

