/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationStepHandler;

public final class AttributeAccess {
    private final AccessType access;
    private final Storage storage;
    private final OperationStepHandler readHandler;
    private final OperationStepHandler writeHandler;
    private final EnumSet<Flag> flags;
    private final AttributeDefinition definition;

    AttributeAccess(AccessType access, Storage storage, OperationStepHandler readHandler, OperationStepHandler writeHandler, AttributeDefinition definition, EnumSet<Flag> flags) {
        assert (access != null) : ControllerMessages.MESSAGES.nullVar("access").getLocalizedMessage();
        assert (storage != null) : ControllerMessages.MESSAGES.nullVar("storage").getLocalizedMessage();
        this.access = access;
        this.readHandler = readHandler;
        this.writeHandler = writeHandler;
        this.storage = storage;
        this.definition = definition;
        if (access == AccessType.READ_WRITE && writeHandler == null) {
            throw ControllerMessages.MESSAGES.nullVar("writeHandler");
        }
        this.flags = flags == null ? EnumSet.noneOf(Flag.class) : EnumSet.copyOf(flags);
        switch (storage) {
            case CONFIGURATION: {
                this.flags.add(Flag.STORAGE_CONFIGURATION);
                this.flags.remove((Object)Flag.STORAGE_RUNTIME);
                break;
            }
            case RUNTIME: {
                this.flags.add(Flag.STORAGE_RUNTIME);
                this.flags.remove((Object)Flag.STORAGE_CONFIGURATION);
                break;
            }
            default: {
                throw ControllerMessages.MESSAGES.unexpectedStorage(storage);
            }
        }
    }

    public AccessType getAccessType() {
        return this.access;
    }

    public Storage getStorageType() {
        return this.storage;
    }

    public OperationStepHandler getReadHandler() {
        return this.readHandler;
    }

    public OperationStepHandler getWriteHandler() {
        return this.writeHandler;
    }

    public AttributeDefinition getAttributeDefinition() {
        return this.definition;
    }

    public Set<Flag> getFlags() {
        return EnumSet.copyOf(this.flags);
    }

    public static enum Flag {
        RESTART_NONE,
        RESTART_JVM,
        RESTART_ALL_SERVICES,
        RESTART_RESOURCE_SERVICES,
        STORAGE_CONFIGURATION,
        STORAGE_RUNTIME;

    }

    public static enum Storage {
        CONFIGURATION("configuration"),
        RUNTIME("runtime");

        private final String label;

        private Storage(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum AccessType {
        READ_ONLY("read-only"),
        READ_WRITE("read-write"),
        METRIC("metric");

        private final String label;

        private AccessType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

