/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class NamespaceRemoveHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove-namespace";
    public static final NamespaceRemoveHandler INSTANCE = new NamespaceRemoveHandler();
    private final ParameterValidator typeValidator = new ModelTypeValidator(ModelType.STRING);

    public static ModelNode getRemoveNamespaceOperation(ModelNode address, String prefix) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        op.get("namespace").set(prefix);
        return op;
    }

    private NamespaceRemoveHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode param = operation.get("namespace");
        this.typeValidator.validateParameter("namespace", param);
        ModelNode namespaces = model.get("namespaces");
        Property toRemove = null;
        ModelNode newList = new ModelNode().setEmptyList();
        String prefix = param.asString();
        if (namespaces.isDefined()) {
            for (Property namespace : namespaces.asPropertyList()) {
                if (prefix.equals(namespace.getName())) {
                    toRemove = namespace;
                    continue;
                }
                newList.add(namespace.getName(), namespace.getValue());
            }
        }
        if (toRemove == null) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.namespaceNotFound(prefix)));
        }
        namespaces.set(newList);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getRemoveNamespaceOperation(locale);
    }
}

