/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentDescription {
    private static final String RESOURCE_NAME = DeploymentDescription.class.getPackage().getName() + ".LocalDescriptions";

    private DeploymentDescription() {
    }

    public static final ModelNode getDeploymentDescription(Locale locale, boolean includeEnabled, boolean includeContent, boolean includeRuntime) {
        ResourceBundle bundle2 = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("deployment"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        root.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "name", "description"}).set(bundle2.getString("deployment.name"));
        root.get(new String[]{"attributes", "name", "required"}).set(true);
        root.get(new String[]{"attributes", "name", "min-length"}).set(1);
        root.get(new String[]{"attributes", "name", "nillable"}).set(false);
        root.get(new String[]{"attributes", "runtime-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "runtime-name", "description"}).set(bundle2.getString("deployment.runtime-name"));
        root.get(new String[]{"attributes", "runtime-name", "required"}).set(true);
        root.get(new String[]{"attributes", "runtime-name", "min-length"}).set(1);
        root.get(new String[]{"attributes", "runtime-name", "nillable"}).set(false);
        if (includeContent) {
            root.get(new String[]{"attributes", "content", "type"}).set(ModelType.LIST);
            root.get(new String[]{"attributes", "content", "description"}).set(bundle2.getString("deployment.content"));
            root.get(new String[]{"attributes", "content", "required"}).set(true);
            root.get(new String[]{"attributes", "content", "min-length"}).set(1);
            root.get(new String[]{"attributes", "content", "value-type", "input-stream-index", "type"}).set(ModelType.INT);
            root.get(new String[]{"attributes", "content", "value-type", "input-stream-index", "description"}).set(bundle2.getString("deployment.inputstream"));
            root.get(new String[]{"attributes", "content", "value-type", "input-stream-index", "required"}).set(false);
            root.get(new String[]{"attributes", "content", "value-type", "input-stream-index", "min"}).set(0);
            root.get(new String[]{"attributes", "content", "value-type", "input-stream-index", "nillable"}).set(true);
            root.get(new String[]{"attributes", "content", "value-type", "hash", "type"}).set(ModelType.BYTES);
            root.get(new String[]{"attributes", "content", "value-type", "hash", "description"}).set(bundle2.getString("deployment.hash"));
            root.get(new String[]{"attributes", "content", "value-type", "hash", "required"}).set(false);
            root.get(new String[]{"attributes", "content", "value-type", "hash", "min-length"}).set(20);
            root.get(new String[]{"attributes", "content", "value-type", "hash", "max-length"}).set(20);
            root.get(new String[]{"attributes", "content", "value-type", "hash", "nillable"}).set(true);
            root.get(new String[]{"attributes", "content", "value-type", "bytes", "type"}).set(ModelType.BYTES);
            root.get(new String[]{"attributes", "content", "value-type", "bytes", "description"}).set(bundle2.getString("deployment.bytes"));
            root.get(new String[]{"attributes", "content", "value-type", "bytes", "required"}).set(false);
            root.get(new String[]{"attributes", "content", "value-type", "bytes", "min-length"}).set(1);
            root.get(new String[]{"attributes", "content", "value-type", "bytes", "nillable"}).set(true);
            root.get(new String[]{"attributes", "content", "value-type", "url", "type"}).set(ModelType.STRING);
            root.get(new String[]{"attributes", "content", "value-type", "url", "description"}).set(bundle2.getString("deployment.url"));
            root.get(new String[]{"attributes", "content", "value-type", "url", "required"}).set(false);
            root.get(new String[]{"attributes", "content", "value-type", "url", "min-length"}).set(1);
            root.get(new String[]{"attributes", "content", "value-type", "url", "nillable"}).set(true);
            root.get(new String[]{"attributes", "content", "value-type", "path", "type"}).set(ModelType.STRING);
            root.get(new String[]{"attributes", "content", "value-type", "path", "description"}).set(bundle2.getString("deployment.path"));
            root.get(new String[]{"attributes", "content", "value-type", "path", "required"}).set(false);
            root.get(new String[]{"attributes", "content", "value-type", "path", "min-length"}).set(1);
            root.get(new String[]{"attributes", "content", "value-type", "path", "nillable"}).set(false);
            root.get(new String[]{"attributes", "content", "value-type", "relative-to", "type"}).set(ModelType.STRING);
            root.get(new String[]{"attributes", "content", "value-type", "relative-to", "description"}).set(bundle2.getString("deployment.relative-to"));
            root.get(new String[]{"attributes", "content", "value-type", "relative-to", "required"}).set(false);
            root.get(new String[]{"attributes", "content", "value-type", "relative-to", "min-length"}).set(1);
            root.get(new String[]{"attributes", "content", "value-type", "relative-to", "nillable"}).set(true);
            root.get(new String[]{"attributes", "content", "value-type", "archive", "type"}).set(ModelType.BOOLEAN);
            root.get(new String[]{"attributes", "content", "value-type", "archive", "description"}).set(bundle2.getString("deployment.archive"));
            root.get(new String[]{"attributes", "content", "value-type", "archive", "required"}).set(false);
        }
        if (includeEnabled) {
            root.get(new String[]{"attributes", "enabled", "type"}).set(ModelType.BOOLEAN);
            root.get(new String[]{"attributes", "enabled", "description"}).set(bundle2.getString("deployment.enabled"));
            root.get(new String[]{"attributes", "enabled", "required"}).set(true);
            if (includeContent) {
                root.get(new String[]{"attributes", "persistent", "type"}).set(ModelType.BOOLEAN);
                root.get(new String[]{"attributes", "persistent", "description"}).set(bundle2.getString("deployment.persistent"));
                root.get(new String[]{"attributes", "persistent", "required"}).set(true);
                root.get(new String[]{"attributes", "status", "type"}).set(ModelType.STRING);
                root.get(new String[]{"attributes", "status", "description"}).set(bundle2.getString("deployment.status"));
                root.get(new String[]{"attributes", "status", "required"}).set(false);
            }
        }
        root.get("operations");
        if (includeRuntime) {
            root.get(new String[]{"children", "subsystem", "description"}).set(bundle2.getString("deployment.subsystem"));
            root.get(new String[]{"children", "subsystem", "min-occurs"}).set(0);
            root.get(new String[]{"children", "subsystem", "model-description"});
            root.get(new String[]{"children", "subdeployment", "description"}).set(bundle2.getString("deployment.subdeployment"));
            root.get(new String[]{"children", "subdeployment", "min-occurs"}).set(0);
            root.get(new String[]{"children", "subdeployment", "model-description"});
        } else {
            root.get("children").setEmptyObject();
        }
        return root;
    }

    public static ModelNode getSubDeploymentDescription(Locale locale) {
        ResourceBundle bundle2 = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("deployment.subdeployment"));
        root.get("attributes").setEmptyObject();
        root.get("operations");
        root.get(new String[]{"children", "subsystem", "description"}).set(bundle2.getString("deployment.subsystem"));
        root.get(new String[]{"children", "subsystem", "min-occurs"}).set(0);
        root.get(new String[]{"children", "subsystem", "model-description"});
        return root;
    }

    public static final ModelNode getUploadDeploymentBytesOperation(Locale locale) {
        ResourceBundle bundle2 = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("upload-deployment-bytes");
        root.get("description").set(bundle2.getString("deployment.upload-bytes"));
        root.get(new String[]{"request-properties", "bytes", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"request-properties", "bytes", "description"}).set(bundle2.getString("deployment.bytes"));
        root.get(new String[]{"request-properties", "bytes", "required"}).set(true);
        root.get(new String[]{"request-properties", "bytes", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "bytes", "nillable"}).set(false);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("deployment.hash"));
        root.get(new String[]{"reply-properties", "min-length"}).set(20);
        root.get(new String[]{"reply-properties", "max-length"}).set(20);
        root.get(new String[]{"reply-properties", "nillable"}).set(false);
        return root;
    }

    public static final ModelNode getUploadDeploymentURLOperation(Locale locale) {
        ResourceBundle bundle2 = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("upload-deployment-url");
        root.get("description").set(bundle2.getString("deployment.upload-url"));
        root.get(new String[]{"request-properties", "url", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "url", "description"}).set(bundle2.getString("deployment.url"));
        root.get(new String[]{"request-properties", "url", "required"}).set(true);
        root.get(new String[]{"request-properties", "url", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "url", "nillable"}).set(false);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("deployment.hash"));
        root.get(new String[]{"reply-properties", "min-length"}).set(20);
        root.get(new String[]{"reply-properties", "max-length"}).set(20);
        root.get(new String[]{"reply-properties", "nillable"}).set(false);
        return root;
    }

    public static final ModelNode getUploadDeploymentStreamAttachmentOperation(Locale locale) {
        ResourceBundle bundle2 = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("upload-deployment-stream");
        root.get("description").set(bundle2.getString("deployment.upload-stream"));
        root.get(new String[]{"request-properties", "input-stream-index", "type"}).set(ModelType.INT);
        root.get(new String[]{"request-properties", "input-stream-index", "description"}).set(bundle2.getString("deployment.inputstream"));
        root.get(new String[]{"request-properties", "input-stream-index", "required"}).set(true);
        root.get(new String[]{"request-properties", "input-stream-index", "min"}).set(0);
        root.get(new String[]{"request-properties", "input-stream-index", "nillable"}).set(false);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("deployment.hash"));
        root.get(new String[]{"reply-properties", "min-length"}).set(20);
        root.get(new String[]{"reply-properties", "max-length"}).set(20);
        root.get(new String[]{"reply-properties", "nillable"}).set(false);
        return root;
    }

    public static final ModelNode getAddDeploymentOperation(Locale locale, boolean includeEnabled) {
        ResourceBundle bundle2 = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle2.getString("deployment.add"));
        root.get(new String[]{"request-properties", "runtime-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "runtime-name", "description"}).set(bundle2.getString("deployment.runtime-name"));
        root.get(new String[]{"request-properties", "runtime-name", "required"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "runtime-name", "nillable"}).set(true);
        DeploymentDescription.getDeploymentContentParamDescription(root, bundle2);
        if (includeEnabled) {
            root.get(new String[]{"request-properties", "enabled", "type"}).set(ModelType.BOOLEAN);
            root.get(new String[]{"request-properties", "enabled", "description"}).set(bundle2.getString("deployment.enabled"));
            root.get(new String[]{"request-properties", "enabled", "required"}).set(false);
        }
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getDeployDeploymentOperation(Locale locale) {
        ResourceBundle bundle2 = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("deploy");
        root.get("description").set(bundle2.getString("deployment.deploy"));
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getReplaceDeploymentOperation(Locale locale) {
        ResourceBundle bundle2 = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("replace-deployment");
        root.get("description").set(bundle2.getString("deployment.replace"));
        root.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("deployment.replace.name"));
        root.get(new String[]{"request-properties", "name", "required"}).set(true);
        root.get(new String[]{"request-properties", "name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        root.get(new String[]{"request-properties", "to-replace", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "to-replace", "description"}).set(bundle2.getString("deployment.replace.to-replace"));
        root.get(new String[]{"request-properties", "to-replace", "required"}).set(true);
        root.get(new String[]{"request-properties", "to-replace", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "to-replace", "nillable"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "runtime-name", "description"}).set(bundle2.getString("deployment.runtime-name"));
        root.get(new String[]{"request-properties", "runtime-name", "required"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "runtime-name", "nillable"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getFullReplaceDeploymentOperation(Locale locale) {
        ResourceBundle bundle2 = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("full-replace-deployment");
        root.get("description").set(bundle2.getString("deployment.full-replace"));
        root.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("deployment.name"));
        root.get(new String[]{"request-properties", "name", "required"}).set(true);
        root.get(new String[]{"request-properties", "name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "runtime-name", "description"}).set(bundle2.getString("deployment.runtime-name"));
        root.get(new String[]{"request-properties", "runtime-name", "required"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "runtime-name", "nillable"}).set(false);
        DeploymentDescription.getDeploymentContentParamDescription(root, bundle2);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getUndeployDeploymentOperation(Locale locale) {
        ResourceBundle bundle2 = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("undeploy");
        root.get("description").set(bundle2.getString("deployment.undeploy"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getRedeployDeploymentOperation(Locale locale) {
        ResourceBundle bundle2 = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("redeploy");
        root.get("description").set(bundle2.getString("deployment.redeploy"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    private static void getDeploymentContentParamDescription(ModelNode root, ResourceBundle bundle2) {
        root.get(new String[]{"request-properties", "content", "type"}).set(ModelType.LIST);
        root.get(new String[]{"request-properties", "content", "description"}).set(bundle2.getString("deployment.content"));
        root.get(new String[]{"request-properties", "content", "required"}).set(true);
        root.get(new String[]{"request-properties", "content", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "content", "value-type", "input-stream-index", "type"}).set(ModelType.INT);
        root.get(new String[]{"request-properties", "content", "value-type", "input-stream-index", "description"}).set(bundle2.getString("deployment.inputstream"));
        root.get(new String[]{"request-properties", "content", "value-type", "input-stream-index", "required"}).set(false);
        root.get(new String[]{"request-properties", "content", "value-type", "input-stream-index", "min"}).set(0);
        root.get(new String[]{"request-properties", "content", "value-type", "input-stream-index", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "content", "value-type", "hash", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"request-properties", "content", "value-type", "hash", "description"}).set(bundle2.getString("deployment.hash"));
        root.get(new String[]{"request-properties", "content", "value-type", "hash", "required"}).set(false);
        root.get(new String[]{"request-properties", "content", "value-type", "hash", "min-length"}).set(20);
        root.get(new String[]{"request-properties", "content", "value-type", "hash", "max-length"}).set(20);
        root.get(new String[]{"request-properties", "content", "value-type", "hash", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "content", "value-type", "bytes", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"request-properties", "content", "value-type", "bytes", "description"}).set(bundle2.getString("deployment.bytes"));
        root.get(new String[]{"request-properties", "content", "value-type", "bytes", "required"}).set(false);
        root.get(new String[]{"request-properties", "content", "value-type", "bytes", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "content", "value-type", "bytes", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "content", "value-type", "url", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "content", "value-type", "url", "description"}).set(bundle2.getString("deployment.url"));
        root.get(new String[]{"request-properties", "content", "value-type", "url", "required"}).set(false);
        root.get(new String[]{"request-properties", "content", "value-type", "url", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "content", "value-type", "url", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "content", "value-type", "path", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "content", "value-type", "path", "description"}).set(bundle2.getString("deployment.path"));
        root.get(new String[]{"request-properties", "content", "value-type", "path", "required"}).set(false);
        root.get(new String[]{"request-properties", "content", "value-type", "path", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "content", "value-type", "path", "nillable"}).set(false);
        root.get(new String[]{"request-properties", "content", "value-type", "relative-to", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "content", "value-type", "relative-to", "description"}).set(bundle2.getString("deployment.relative-to"));
        root.get(new String[]{"request-properties", "content", "value-type", "relative-to", "required"}).set(false);
        root.get(new String[]{"request-properties", "content", "value-type", "relative-to", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "content", "value-type", "relative-to", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "content", "value-type", "archive", "type"}).set(ModelType.BOOLEAN);
        root.get(new String[]{"request-properties", "content", "value-type", "archive", "description"}).set(bundle2.getString("deployment.archive"));
        root.get(new String[]{"request-properties", "content", "value-type", "archive", "required"}).set(false);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static void main(String[] args) {
        System.out.println(DeploymentDescription.getDeploymentDescription(null, true, true, false));
        System.out.println(DeploymentDescription.getAddDeploymentOperation(null, true));
        System.out.println(DeploymentDescription.getDeployDeploymentOperation(null));
        System.out.println(DeploymentDescription.getFullReplaceDeploymentOperation(null));
        System.out.println(DeploymentDescription.getRedeployDeploymentOperation(null));
        System.out.println(DeploymentDescription.getReplaceDeploymentOperation(null));
        System.out.println(DeploymentDescription.getUndeployDeploymentOperation(null));
        System.out.println(DeploymentDescription.getUploadDeploymentBytesOperation(null));
        System.out.println(DeploymentDescription.getUploadDeploymentURLOperation(null));
    }
}

