/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementBatchIdManager;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementResponseHandler;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;

public class RemoteProxyController
implements ProxyController,
ManagementOperationHandler {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final PathAddress pathAddress;
    private final ManagementChannel channel;
    private final ExecutorService executorService;
    private final Map<Integer, ExecuteRequestContext> activeRequests = Collections.synchronizedMap(new HashMap());
    private final ProxyOperationAddressTranslator addressTranslator;

    private RemoteProxyController(ExecutorService executorService, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator, ManagementChannel channel) {
        this.pathAddress = pathAddress;
        this.channel = channel;
        this.executorService = executorService;
        this.addressTranslator = addressTranslator;
        channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleClose(Channel closed, IOException exception) {
                RemoteProxyController.this.closed.set(true);
                Map map = RemoteProxyController.this.activeRequests;
                synchronized (map) {
                    for (ExecuteRequestContext context : RemoteProxyController.this.activeRequests.values()) {
                        context.setError(ControllerMessages.MESSAGES.channelClosed());
                    }
                    RemoteProxyController.this.activeRequests.clear();
                }
            }
        });
    }

    public static RemoteProxyController create(ExecutorService executorService, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator, ManagementChannel channel) {
        return new RemoteProxyController(executorService, pathAddress, addressTranslator, channel);
    }

    @Override
    public PathAddress getProxyNodeAddress() {
        return this.pathAddress;
    }

    public ManagementRequestHandler getRequestHandler(byte id) {
        if (id == 72) {
            return new HandleReportRequestHandler();
        }
        if (id == 73) {
            return new OperationFailedRequestHandler();
        }
        if (id == 74) {
            return new OperationCompletedRequestHandler();
        }
        if (id == 75) {
            return new OperationPreparedRequestHandler();
        }
        if (id == 76) {
            return new ReadAttachmentInputStreamRequestHandler();
        }
        return null;
    }

    @Override
    public void execute(ModelNode operation, OperationMessageHandler handler, final ProxyController.ProxyOperationControl control, OperationAttachments attachments) {
        int batchId = ManagementBatchIdManager.DEFAULT.createBatchId();
        final CountDownLatch prepareOrFailedLatch = new CountDownLatch(1);
        final AtomicBoolean failed = new AtomicBoolean(false);
        ExecuteRequest request = new ExecuteRequest(batchId, this.getOperationForProxy(operation), handler, new ProxyController.ProxyOperationControl(){

            @Override
            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                control.operationPrepared(transaction, result);
                prepareOrFailedLatch.countDown();
            }

            @Override
            public void operationFailed(ModelNode response) {
                control.operationFailed(response);
                failed.set(true);
                prepareOrFailedLatch.countDown();
            }

            @Override
            public void operationCompleted(ModelNode response) {
                control.operationCompleted(response);
            }
        }, attachments){

            @Override
            protected void setError(Exception e) {
                super.setError(e);
                if (failed.compareAndSet(false, true)) {
                    control.operationFailed(new ModelNode().get("outcome").set("failed"));
                }
                prepareOrFailedLatch.countDown();
            }
        };
        try {
            request.executeForResult(this.executorService, this.getChannelStrategy());
            prepareOrFailedLatch.await();
        }
        catch (Exception e) {
            try {
                ManagementBatchIdManager.DEFAULT.freeBatchId(batchId);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            this.activeRequests.remove(batchId);
            throw new RuntimeException(e);
        }
    }

    private ManagementClientChannelStrategy getChannelStrategy() {
        return ManagementClientChannelStrategy.create((ManagementChannel)this.channel);
    }

    private ModelNode getOperationForProxy(ModelNode op) {
        PathAddress translated;
        PathAddress addr = PathAddress.pathAddress(op.get("address"));
        if (addr.equals(translated = this.addressTranslator.translateAddress(addr))) {
            return op;
        }
        ModelNode proxyOp = op.clone();
        proxyOp.get("address").set(translated.toModelNode());
        return proxyOp;
    }

    private static class ExecuteRequestContext {
        final ExecuteRequest request;
        final OperationMessageHandler messageHandler;
        final ProxyController.ProxyOperationControl control;
        final OperationAttachments attachments;
        final CountDownLatch controlCompletedLatch = new CountDownLatch(1);

        public ExecuteRequestContext(ExecuteRequest request, OperationMessageHandler messageHandler, ProxyController.ProxyOperationControl control, OperationAttachments attachments) {
            this.request = request;
            this.messageHandler = messageHandler;
            this.control = control;
            this.attachments = attachments;
        }

        public OperationMessageHandler getMessageHandler() {
            return this.messageHandler;
        }

        public ProxyController.ProxyOperationControl getControl() {
            return this.control;
        }

        public OperationAttachments getAttachments() {
            return this.attachments;
        }

        void awaitControlCompleted() throws InterruptedException {
            this.controlCompletedLatch.await();
        }

        void setControlCompleted() {
            this.controlCompletedLatch.countDown();
        }

        synchronized void setError(String error) {
            this.controlCompletedLatch.countDown();
            this.request.setError(new Exception(error));
        }

        CloseHandler<Channel> getRequestCloseHandler() {
            return new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    ExecuteRequestContext.this.setError(ControllerMessages.MESSAGES.channelClosed());
                }
            };
        }
    }

    private class OperationPreparedRequestHandler
    extends ProxyOperationControlRequestHandler {
        private OperationPreparedRequestHandler() {
        }

        @Override
        void handle(final int batchId, ProxyController.ProxyOperationControl control, ModelNode response) {
            control.operationPrepared(new ModelController.OperationTransaction(){

                @Override
                public void rollback() {
                    this.done(false);
                }

                @Override
                public void commit() {
                    this.done(true);
                }

                private void done(boolean commit) {
                    final byte status = commit ? (byte)112 : 113;
                    try {
                        new ManagementRequest<Void>(batchId){

                            protected byte getRequestCode() {
                                return 78;
                            }

                            protected void writeRequest(int protocolVersion, FlushableDataOutput output) throws IOException {
                                output.write((int)status);
                            }

                            protected ManagementResponseHandler<Void> getResponseHandler() {
                                return ManagementResponseHandler.EMPTY_RESPONSE;
                            }
                        }.executeForResult(RemoteProxyController.this.executorService, RemoteProxyController.this.getChannelStrategy());
                    }
                    catch (Exception e) {
                        OperationPreparedRequestHandler.this.requestContext.setError(e.getMessage());
                    }
                    try {
                        OperationPreparedRequestHandler.this.requestContext.awaitControlCompleted();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw ControllerMessages.MESSAGES.transactionTimeout(commit ? "commit" : "rollback");
                    }
                }
            }, response);
        }
    }

    private class OperationCompletedRequestHandler
    extends ProxyOperationControlRequestHandler {
        private OperationCompletedRequestHandler() {
        }

        @Override
        void handle(int batchId, ProxyController.ProxyOperationControl control, ModelNode response) {
            ExecuteRequestContext context = (ExecuteRequestContext)RemoteProxyController.this.activeRequests.remove(batchId);
            ManagementBatchIdManager.DEFAULT.freeBatchId(batchId);
            control.operationCompleted(response);
            context.setControlCompleted();
        }
    }

    private class OperationFailedRequestHandler
    extends ProxyOperationControlRequestHandler {
        private OperationFailedRequestHandler() {
        }

        @Override
        void handle(int batchId, ProxyController.ProxyOperationControl control, ModelNode response) {
            RemoteProxyController.this.activeRequests.remove(batchId);
            ManagementBatchIdManager.DEFAULT.freeBatchId(batchId);
            control.operationFailed(response);
        }
    }

    private abstract class ProxyOperationControlRequestHandler
    extends ManagementRequestHandler {
        volatile ExecuteRequestContext requestContext;
        int batchId;
        ModelNode response;

        private ProxyOperationControlRequestHandler() {
        }

        protected void readRequest(DataInput input) throws IOException {
            this.batchId = this.getHeader().getBatchId();
            ProtocolUtils.expectHeader((DataInput)input, (int)100);
            this.response = new ModelNode();
            this.response.readExternal(input);
        }

        protected void processRequest() throws RequestProcessingException {
            this.requestContext = (ExecuteRequestContext)RemoteProxyController.this.activeRequests.get(this.batchId);
            if (this.requestContext == null) {
                throw ControllerMessages.MESSAGES.noActiveRequestForProxyOperation(this.batchId);
            }
            this.handle(this.batchId, this.requestContext.getControl(), this.response);
        }

        abstract void handle(int var1, ProxyController.ProxyOperationControl var2, ModelNode var3);
    }

    private class ReadAttachmentInputStreamRequestHandler
    extends ManagementRequestHandler {
        InputStream attachmentInput;
        byte[] bytes;

        private ReadAttachmentInputStreamRequestHandler() {
        }

        protected void readRequest(DataInput input) throws IOException {
            int batchId = this.getHeader().getBatchId();
            ProtocolUtils.expectHeader((DataInput)input, (int)102);
            int index = input.readInt();
            ExecuteRequestContext requestContext = (ExecuteRequestContext)RemoteProxyController.this.activeRequests.get(batchId);
            if (requestContext == null) {
                throw ControllerMessages.MESSAGES.noActiveRequestForReadingInputStreamReport(batchId);
            }
            InputStream in = (InputStream)requestContext.getAttachments().getInputStreams().get(index);
            this.attachmentInput = in != null ? new BufferedInputStream(in) : null;
        }

        protected void processRequest() throws RequestProcessingException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                if (this.attachmentInput != null) {
                    int i = this.attachmentInput.read();
                    while (i != -1) {
                        bout.write(i);
                        i = this.attachmentInput.read();
                    }
                }
            }
            catch (IOException e) {
                throw new RequestProcessingException((Throwable)e);
            }
            this.bytes = bout.toByteArray();
        }

        protected void writeResponse(FlushableDataOutput output) throws IOException {
            output.write(103);
            output.writeInt(this.bytes.length);
            output.write(104);
            output.write(this.bytes);
        }
    }

    private class HandleReportRequestHandler
    extends ManagementRequestHandler {
        int batchId;
        MessageSeverity severity;
        String message;

        private HandleReportRequestHandler() {
        }

        protected void readRequest(DataInput input) throws IOException {
            this.batchId = this.getHeader().getBatchId();
            ProtocolUtils.expectHeader((DataInput)input, (int)98);
            this.severity = Enum.valueOf(MessageSeverity.class, input.readUTF());
            ProtocolUtils.expectHeader((DataInput)input, (int)99);
            this.message = input.readUTF();
        }

        protected void processRequest() throws RequestProcessingException {
            ExecuteRequestContext requestContext = (ExecuteRequestContext)RemoteProxyController.this.activeRequests.get(this.batchId);
            if (requestContext == null) {
                throw ControllerMessages.MESSAGES.noActiveRequestForHandlingReport(this.batchId);
            }
            requestContext.getMessageHandler().handleReport(this.severity, this.message);
        }
    }

    private class ExecuteRequest
    extends ManagementRequest<Void> {
        private final ExecuteRequestContext executeRequestContext;
        private final ModelNode operation;

        ExecuteRequest(int batchId, ModelNode operation, OperationMessageHandler messageHandler, ProxyController.ProxyOperationControl control, OperationAttachments attachments) {
            super(batchId);
            this.operation = operation;
            this.executeRequestContext = new ExecuteRequestContext(this, messageHandler, control, attachments);
        }

        protected byte getRequestCode() {
            return 71;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeRequest(int protocolVersion, FlushableDataOutput output) throws IOException {
            boolean success = false;
            RemoteProxyController.this.activeRequests.put(this.getBatchId(), this.executeRequestContext);
            try {
                List streams;
                output.write(97);
                this.operation.writeExternal((DataOutput)output);
                output.write(101);
                int inputStreamLength = 0;
                if (this.executeRequestContext.getAttachments() != null && (streams = this.executeRequestContext.getAttachments().getInputStreams()) != null) {
                    inputStreamLength = streams.size();
                }
                output.writeInt(inputStreamLength);
                success = true;
            }
            finally {
                if (!success) {
                    ManagementBatchIdManager.DEFAULT.freeBatchId(this.getBatchId());
                }
            }
        }

        protected ManagementResponseHandler<Void> getResponseHandler() {
            return ManagementResponseHandler.EMPTY_RESPONSE;
        }

        protected void setError(Exception e) {
            super.setError(e);
        }

        protected CloseHandler<Channel> getRequestCloseHandler() {
            return this.executeRequestContext.getRequestCloseHandler();
        }
    }
}

