/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ConfigurationFilePersistenceResource;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.XmlConfigurationPersister;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class BackupXmlConfigurationPersister
extends XmlConfigurationPersister {
    ConfigurationFile configurationFile;
    private final AtomicBoolean successfulBoot = new AtomicBoolean();

    public BackupXmlConfigurationPersister(ConfigurationFile file, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser) {
        super(file.getBootFile(), rootElement, rootParser, rootDeparser);
        this.configurationFile = file;
    }

    @Override
    public void registerAdditionalRootElement(QName anotherRoot, XMLElementReader<List<ModelNode>> parser) {
        super.registerAdditionalRootElement(anotherRoot, parser);
    }

    @Override
    public void successfulBoot() throws ConfigurationPersistenceException {
        if (this.successfulBoot.compareAndSet(false, true)) {
            this.configurationFile.successfulBoot();
        }
    }

    @Override
    public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        if (!this.successfulBoot.get()) {
            return new ConfigurationPersister.PersistenceResource(){

                @Override
                public void commit() {
                }

                @Override
                public void rollback() {
                }
            };
        }
        return new ConfigurationFilePersistenceResource(model, this.configurationFile, (AbstractConfigurationPersister)this);
    }

    @Override
    public String snapshot() throws ConfigurationPersistenceException {
        return this.configurationFile.snapshot();
    }

    @Override
    public ConfigurationPersister.SnapshotInfo listSnapshots() {
        return this.configurationFile.listSnapshots();
    }

    @Override
    public void deleteSnapshot(String name) {
        this.configurationFile.deleteSnapshot(name);
    }
}

