/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.SecurityActions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class SystemPropertyRemoveHandler
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "remove";
    public static final SystemPropertyRemoveHandler INSTANCE = new SystemPropertyRemoveHandler();

    public static ModelNode getOperation(ModelNode address, String name) {
        ModelNode op = Util.getEmptyOperation(OPERATION_NAME, address);
        op.get("name").set(name);
        return op;
    }

    private SystemPropertyRemoveHandler() {
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ModelNode opAddr = operation.require("address");
        String name = PathAddress.pathAddress(opAddr).getLastElement().getValue();
        SecurityActions.clearSystemProperty(name);
    }

    @Override
    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
        ModelNode opAddr = operation.require("address");
        String name = PathAddress.pathAddress(opAddr).getLastElement().getValue();
        SecurityActions.setSystemProperty(name, model.get("value").asString());
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getRemoveSystemPropertyOperation(locale);
    }
}

