/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.SecurityActions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class SystemPropertyAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final SystemPropertyAddHandler INSTANCE_WITH_BOOTTIME = new SystemPropertyAddHandler(true);
    public static final SystemPropertyAddHandler INSTANCE_WITHOUT_BOOTTIME = new SystemPropertyAddHandler(false);
    private final ParametersValidator validator = new ParametersValidator();
    private final boolean useBoottime;

    public static ModelNode getOperation(ModelNode address, String value) {
        return SystemPropertyAddHandler.getOperation(address, value, null);
    }

    public static ModelNode getOperation(ModelNode address, String value, Boolean boottime) {
        ModelNode op = Util.getEmptyOperation(OPERATION_NAME, address);
        if (value == null) {
            op.get("value").set(new ModelNode());
        } else {
            op.get("value").set(value);
        }
        if (boottime != null) {
            op.get("boot-time").set(boottime.booleanValue());
        }
        return op;
    }

    private SystemPropertyAddHandler(boolean useBoottime) {
        this.useBoottime = useBoottime;
        this.validator.registerValidator("value", new StringLengthValidator(0, true));
        if (useBoottime) {
            this.validator.registerValidator("boot-time", new ModelTypeValidator(ModelType.BOOLEAN, true));
        }
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        String value;
        this.validator.validate(operation);
        String string = value = operation.get("value").isDefined() ? operation.get("value").asString() : null;
        if (value == null) {
            model.get("value").set(new ModelNode());
        } else {
            model.get("value").set(value);
        }
        if (this.useBoottime) {
            boolean boottime = operation.get("boot-time").isDefined() ? operation.get("boot-time").asBoolean() : true;
            model.get("boot-time").set(boottime);
        }
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        String name = PathAddress.pathAddress(operation.get("address")).getLastElement().getValue();
        String value = operation.get("value").isDefined() ? operation.get("value").asString() : null;
        SecurityActions.setSystemProperty(name, value);
    }

    @Override
    protected boolean requiresRuntimeVerification() {
        return false;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getAddSystemPropertyOperation(locale, this.useBoottime);
    }
}

