/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.regex.Pattern;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.dmr.Property;

public class PathElement {
    private static final String WILDCARD_VALUE = "*";
    private final String key;
    private final String value;
    private final boolean multiTarget;
    private final int hashCode;
    private static final Pattern VALID_KEY_PATTERN = Pattern.compile("\\*|[_a-zA-Z](?:[-_a-zA-Z0-9]*[_a-zA-Z0-9])?");
    private static final Pattern VALID_VALUE_PATTERN = Pattern.compile("\\*|[^*\\p{Space}\\p{Cntrl}]+");

    public static PathElement pathElement(String key) {
        return new PathElement(key);
    }

    public static PathElement pathElement(String key, String value) {
        return new PathElement(key, value);
    }

    PathElement(String key) {
        this(key, WILDCARD_VALUE);
    }

    PathElement(String key, String value) {
        if (key == null || !VALID_KEY_PATTERN.matcher(key).matches()) {
            throw ControllerMessages.MESSAGES.invalidKey(key);
        }
        if (value == null || !VALID_VALUE_PATTERN.matcher(value).matches()) {
            throw ControllerMessages.MESSAGES.invalidValue(value);
        }
        boolean multiTarget = false;
        if (key.equals(WILDCARD_VALUE)) {
            this.key = WILDCARD_VALUE;
            multiTarget = true;
        } else {
            this.key = key;
        }
        if (value.equals(WILDCARD_VALUE)) {
            this.value = WILDCARD_VALUE;
            multiTarget = true;
        } else if (value.charAt(0) == '[' && value.charAt(value.length() - 1) == ']') {
            this.value = value.substring(1, value.length() - 1);
            multiTarget |= value.indexOf(44) != -1;
        } else {
            this.value = value;
        }
        this.multiTarget = multiTarget;
        this.hashCode = key.hashCode() * 19 + value.hashCode();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean matches(Property property) {
        return property.getName().equals(this.key) && (this.value == WILDCARD_VALUE || property.getValue().asString().equals(this.value));
    }

    public boolean isWildcard() {
        return WILDCARD_VALUE == this.value;
    }

    public boolean isMultiTarget() {
        return this.multiTarget;
    }

    public String[] getSegments() {
        return this.value.split(",");
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        return other instanceof PathElement && this.equals((PathElement)other);
    }

    public boolean equals(PathElement other) {
        return this == other || other != null && other.key.equals(this.key) && other.value.equals(this.value);
    }

    public String toString() {
        return "\"" + this.key + "\" => \"" + this.value + "\"";
    }
}

