/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.staxmapper.XMLElementWriter;

public final class ExtensionContextImpl
implements ExtensionContext {
    private final ExtensionContext.ProcessType processType;
    private final ManagementResourceRegistration profileRegistration;
    private final SubsystemXmlWriterRegistry writerRegistry;
    private final ManagementResourceRegistration subsystemDeploymentRegistration;

    public ExtensionContextImpl(ManagementResourceRegistration profileRegistration, ManagementResourceRegistration deploymentOverrideRegistration, SubsystemXmlWriterRegistry writerRegistry, ExtensionContext.ProcessType processType) {
        PathAddress subdepAddress;
        ManagementResourceRegistration subdeployments;
        if (profileRegistration == null) {
            throw ControllerMessages.MESSAGES.nullVar("profileRegistration");
        }
        if (writerRegistry == null) {
            throw ControllerMessages.MESSAGES.nullVar("writerRegistry");
        }
        this.processType = processType;
        this.profileRegistration = profileRegistration;
        this.writerRegistry = writerRegistry;
        this.subsystemDeploymentRegistration = deploymentOverrideRegistration != null ? ((subdeployments = deploymentOverrideRegistration.getSubModel(subdepAddress = PathAddress.pathAddress(PathElement.pathElement("subdeployment")))) == null ? deploymentOverrideRegistration : new DeploymentManagementResourceRegistration(deploymentOverrideRegistration, subdeployments)) : null;
    }

    @Override
    public ExtensionContext.ProcessType getProcessType() {
        return this.processType;
    }

    @Override
    public SubsystemRegistration registerSubsystem(final String name) throws IllegalArgumentException {
        if (name == null) {
            throw ControllerMessages.MESSAGES.nullVar("name");
        }
        return new SubsystemRegistration(){

            @Override
            public ManagementResourceRegistration registerSubsystemModel(DescriptionProvider descriptionProvider) {
                if (descriptionProvider == null) {
                    throw ControllerMessages.MESSAGES.nullVar("descriptionProvider");
                }
                PathElement pathElement = PathElement.pathElement("subsystem", name);
                return this.registerSubsystemModel(new SimpleResourceDefinition(pathElement, descriptionProvider));
            }

            @Override
            public ManagementResourceRegistration registerSubsystemModel(ResourceDefinition resourceDefinition) {
                if (resourceDefinition == null) {
                    throw ControllerMessages.MESSAGES.nullVar("descriptionProviderFactory");
                }
                return ExtensionContextImpl.this.profileRegistration.registerSubModel(resourceDefinition);
            }

            @Override
            public ManagementResourceRegistration registerDeploymentModel(DescriptionProvider descriptionProvider) {
                if (descriptionProvider == null) {
                    throw ControllerMessages.MESSAGES.nullVar("descriptionProvider");
                }
                PathElement pathElement = PathElement.pathElement("subsystem", name);
                return this.registerDeploymentModel(new SimpleResourceDefinition(pathElement, descriptionProvider));
            }

            @Override
            public ManagementResourceRegistration registerDeploymentModel(ResourceDefinition resourceDefinition) {
                if (resourceDefinition == null) {
                    throw ControllerMessages.MESSAGES.nullVar("descriptionProviderFactory");
                }
                return ExtensionContextImpl.this.subsystemDeploymentRegistration.registerSubModel(resourceDefinition);
            }

            @Override
            public void registerXMLElementWriter(XMLElementWriter<SubsystemMarshallingContext> writer) {
                ExtensionContextImpl.this.writerRegistry.registerSubsystemWriter(name, writer);
            }
        };
    }

    private static class DeploymentManagementResourceRegistration
    implements ManagementResourceRegistration {
        private final ManagementResourceRegistration deployments;
        private final ManagementResourceRegistration subdeployments;

        private DeploymentManagementResourceRegistration(ManagementResourceRegistration deployments, ManagementResourceRegistration subdeployments) {
            this.deployments = deployments;
            this.subdeployments = subdeployments;
        }

        @Override
        public boolean isRuntimeOnly() {
            return this.deployments.isRuntimeOnly();
        }

        @Override
        public boolean isRemote() {
            return this.deployments.isRemote();
        }

        @Override
        public OperationStepHandler getOperationHandler(PathAddress address, String operationName) {
            return this.deployments.getOperationHandler(address, operationName);
        }

        @Override
        public DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
            return this.deployments.getOperationDescription(address, operationName);
        }

        @Override
        public Set<OperationEntry.Flag> getOperationFlags(PathAddress address, String operationName) {
            return this.deployments.getOperationFlags(address, operationName);
        }

        @Override
        public OperationEntry getOperationEntry(PathAddress address, String operationName) {
            return this.deployments.getOperationEntry(address, operationName);
        }

        @Override
        public Set<String> getAttributeNames(PathAddress address) {
            return this.deployments.getAttributeNames(address);
        }

        @Override
        public AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
            return this.deployments.getAttributeAccess(address, attributeName);
        }

        @Override
        public Set<String> getChildNames(PathAddress address) {
            return this.deployments.getChildNames(address);
        }

        @Override
        public Set<PathElement> getChildAddresses(PathAddress address) {
            return this.deployments.getChildAddresses(address);
        }

        @Override
        public DescriptionProvider getModelDescription(PathAddress address) {
            return this.deployments.getModelDescription(address);
        }

        @Override
        public Map<String, OperationEntry> getOperationDescriptions(PathAddress address, boolean inherited) {
            return this.deployments.getOperationDescriptions(address, inherited);
        }

        @Override
        public ProxyController getProxyController(PathAddress address) {
            return this.deployments.getProxyController(address);
        }

        @Override
        public Set<ProxyController> getProxyControllers(PathAddress address) {
            return this.deployments.getProxyControllers(address);
        }

        @Override
        public ManagementResourceRegistration getSubModel(PathAddress address) {
            return this.deployments.getSubModel(address);
        }

        @Override
        public ManagementResourceRegistration registerSubModel(PathElement address, DescriptionProvider descriptionProvider) {
            ManagementResourceRegistration depl = this.deployments.registerSubModel(address, descriptionProvider);
            ManagementResourceRegistration subdepl = this.subdeployments.registerSubModel(address, descriptionProvider);
            return new DeploymentManagementResourceRegistration(depl, subdepl);
        }

        @Override
        public ManagementResourceRegistration registerSubModel(ResourceDefinition resourceDefinition) {
            ManagementResourceRegistration depl = this.deployments.registerSubModel(resourceDefinition);
            ManagementResourceRegistration subdepl = this.subdeployments.registerSubModel(resourceDefinition);
            return new DeploymentManagementResourceRegistration(depl, subdepl);
        }

        @Override
        public void registerSubModel(PathElement address, ManagementResourceRegistration subModel) {
            this.deployments.registerSubModel(address, subModel);
            this.subdeployments.registerSubModel(address, subModel);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, EnumSet<OperationEntry.Flag> flags) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, flags);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, flags);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, entryType);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, entryType);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType, EnumSet<OperationEntry.Flag> flags) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, entryType, flags);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, entryType, flags);
        }

        @Override
        public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, AttributeAccess.Storage storage) {
            this.deployments.registerReadWriteAttribute(attributeName, readHandler, writeHandler, storage);
            this.subdeployments.registerReadWriteAttribute(attributeName, readHandler, writeHandler, storage);
        }

        @Override
        public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, EnumSet<AttributeAccess.Flag> flags) {
            this.deployments.registerReadWriteAttribute(attributeName, readHandler, writeHandler, flags);
            this.subdeployments.registerReadWriteAttribute(attributeName, readHandler, writeHandler, flags);
        }

        @Override
        public void registerReadWriteAttribute(AttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
            this.deployments.registerReadWriteAttribute(definition, readHandler, writeHandler);
            this.subdeployments.registerReadWriteAttribute(definition, readHandler, writeHandler);
        }

        @Override
        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, AttributeAccess.Storage storage) {
            this.deployments.registerReadOnlyAttribute(attributeName, readHandler, storage);
            this.subdeployments.registerReadOnlyAttribute(attributeName, readHandler, storage);
        }

        @Override
        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, EnumSet<AttributeAccess.Flag> flags) {
            this.deployments.registerReadOnlyAttribute(attributeName, readHandler, flags);
            this.subdeployments.registerReadOnlyAttribute(attributeName, readHandler, flags);
        }

        @Override
        public void registerReadOnlyAttribute(AttributeDefinition definition, OperationStepHandler readHandler) {
            this.deployments.registerReadOnlyAttribute(definition, readHandler);
            this.subdeployments.registerReadOnlyAttribute(definition, readHandler);
        }

        @Override
        public void registerMetric(String attributeName, OperationStepHandler metricHandler) {
            this.deployments.registerMetric(attributeName, metricHandler);
            this.subdeployments.registerMetric(attributeName, metricHandler);
        }

        @Override
        public void registerMetric(AttributeDefinition definition, OperationStepHandler metricHandler) {
            this.deployments.registerMetric(definition, metricHandler);
            this.subdeployments.registerMetric(definition, metricHandler);
        }

        @Override
        public void registerMetric(String attributeName, OperationStepHandler metricHandler, EnumSet<AttributeAccess.Flag> flags) {
            this.deployments.registerMetric(attributeName, metricHandler, flags);
            this.subdeployments.registerMetric(attributeName, metricHandler, flags);
        }

        @Override
        public void registerProxyController(PathElement address, ProxyController proxyController) {
            this.deployments.registerProxyController(address, proxyController);
            this.subdeployments.registerProxyController(address, proxyController);
        }

        @Override
        public void unregisterProxyController(PathElement address) {
            this.deployments.unregisterProxyController(address);
            this.subdeployments.unregisterProxyController(address);
        }
    }
}

