/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandler;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementResponseHandler;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.as.protocol.old.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;

public class TransactionalModelControllerOperationHandler
extends AbstractModelControllerOperationHandler {
    private Map<Integer, ExecuteRequestContext> activeTransactions = Collections.synchronizedMap(new HashMap());

    public TransactionalModelControllerOperationHandler(ExecutorService executorService, ModelController controller) {
        super(executorService, controller);
    }

    @Override
    public ManagementRequestHandler getRequestHandler(byte id) {
        if (id == 71) {
            return new ExecuteRequestHandler();
        }
        if (id == 78) {
            return new CompleteTxOperationHandler();
        }
        if (id == 79) {
            return new PingRequestHandler();
        }
        return null;
    }

    private class ExecuteRequestContext {
        final ManagementChannel channel;
        final int batchId;
        final CountDownLatch preparedOrFailedLatch = new CountDownLatch(1);
        final CountDownLatch txCompletedLatch = new CountDownLatch(1);
        final HandleableCloseable.Key closableKey;
        volatile ModelController.OperationTransaction activeTx;
        volatile String error;

        public ExecuteRequestContext(ManagementChannel channel, int batchId) {
            this.channel = channel;
            this.batchId = batchId;
            this.closableKey = channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    ExecuteRequestContext.this.setError("Channel Closed");
                }
            });
        }

        ManagementChannel getChannel() {
            return this.channel;
        }

        int getBatchId() {
            return this.batchId;
        }

        void awaitPreparedOrFailed() throws InterruptedException {
            this.preparedOrFailedLatch.await();
        }

        void setPreparedOrFailed() {
            this.preparedOrFailedLatch.countDown();
            this.closableKey.remove();
        }

        void setActiveTX(ModelController.OperationTransaction tx) {
            this.activeTx = tx;
        }

        void awaitTxCompleted() throws InterruptedException {
            this.txCompletedLatch.await();
            if (this.error != null) {
                throw new RuntimeException(this.error);
            }
        }

        void setTxCompleted(boolean commit) {
            if (commit) {
                this.activeTx.commit();
            } else {
                this.activeTx.rollback();
            }
            this.txCompletedLatch.countDown();
            if (this.error != null) {
                throw new RuntimeException(this.error);
            }
        }

        synchronized void setError(String error) {
            this.error = error;
            TransactionalModelControllerOperationHandler.this.activeTransactions.remove(this.batchId);
            this.preparedOrFailedLatch.countDown();
            this.txCompletedLatch.countDown();
        }
    }

    private class ProxyOperationControlProxy
    implements ProxyController.ProxyOperationControl {
        final ExecuteRequestContext executeRequestContext;

        public ProxyOperationControlProxy(ExecuteRequestContext executeRequestContext) {
            this.executeRequestContext = executeRequestContext;
        }

        @Override
        public void operationPrepared(final ModelController.OperationTransaction transaction, ModelNode result) {
            try {
                new OperationStatusRequest(this.executeRequestContext.getBatchId(), result){

                    protected byte getRequestCode() {
                        return 75;
                    }

                    @Override
                    protected void writeRequest(int protocolVersion, FlushableDataOutput output) throws IOException {
                        ProxyOperationControlProxy.this.executeRequestContext.setActiveTX(transaction);
                        TransactionalModelControllerOperationHandler.this.activeTransactions.put(ProxyOperationControlProxy.this.executeRequestContext.getBatchId(), ProxyOperationControlProxy.this.executeRequestContext);
                        super.writeRequest(protocolVersion, output);
                    }

                    @Override
                    protected ManagementResponseHandler<Void> getResponseHandler() {
                        return new ManagementResponseHandler<Void>(){

                            protected Void readResponse(DataInput input) throws IOException {
                                return null;
                            }
                        };
                    }
                }.executeForResult(TransactionalModelControllerOperationHandler.this.executorService, TransactionalModelControllerOperationHandler.this.getChannelStrategy(this.executeRequestContext.getChannel()));
                this.executeRequestContext.setPreparedOrFailed();
            }
            catch (Exception e) {
                this.executeRequestContext.setError(e.getMessage());
                throw new RuntimeException(e);
            }
            try {
                this.executeRequestContext.awaitTxCompleted();
            }
            catch (InterruptedException e) {
                this.executeRequestContext.setError("Interrupted while waiting for request");
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void operationFailed(ModelNode response) {
            try {
                new OperationStatusRequest(this.executeRequestContext.getBatchId(), response){

                    protected byte getRequestCode() {
                        return 73;
                    }
                }.executeForResult(TransactionalModelControllerOperationHandler.this.executorService, TransactionalModelControllerOperationHandler.this.getChannelStrategy(this.executeRequestContext.getChannel()));
            }
            catch (Exception e) {
                this.executeRequestContext.setError(e.getMessage());
                throw new RuntimeException(e);
            }
            this.executeRequestContext.setPreparedOrFailed();
        }

        @Override
        public void operationCompleted(ModelNode response) {
            new OperationStatusRequest(this.executeRequestContext.getBatchId(), response){

                protected byte getRequestCode() {
                    return 74;
                }
            }.execute(TransactionalModelControllerOperationHandler.this.executorService, TransactionalModelControllerOperationHandler.this.getChannelStrategy(this.executeRequestContext.getChannel()));
        }

        private abstract class OperationStatusRequest
        extends ManagementRequest<Void> {
            private final ModelNode response;

            public OperationStatusRequest(int batchId, ModelNode response) {
                super(batchId);
                this.response = response;
            }

            protected void writeRequest(int protocolVersion, FlushableDataOutput output) throws IOException {
                output.write(100);
                this.response.writeExternal((DataOutput)output);
            }

            protected ManagementResponseHandler<Void> getResponseHandler() {
                return ManagementResponseHandler.EMPTY_RESPONSE;
            }
        }
    }

    private class CompleteTxOperationHandler
    extends ManagementRequestHandler {
        byte commitOrRollback;

        private CompleteTxOperationHandler() {
        }

        protected void readRequest(DataInput input) throws IOException {
            this.commitOrRollback = input.readByte();
        }

        protected void processRequest() throws RequestProcessingException {
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)TransactionalModelControllerOperationHandler.this.activeTransactions.get(this.getHeader().getBatchId());
            if (executeRequestContext == null) {
                throw new RequestProcessingException("No active tx found for id " + this.getHeader().getBatchId());
            }
            executeRequestContext.setTxCompleted(this.commitOrRollback == 112);
        }

        protected void writeResponse(FlushableDataOutput output) throws IOException {
            super.writeResponse(output);
        }
    }

    private class ExecuteRequestHandler
    extends ManagementRequestHandler {
        private ModelNode operation = new ModelNode();
        private int attachmentsLength;
        private ExecuteRequestContext executeRequestContext;

        private ExecuteRequestHandler() {
        }

        protected void readRequest(DataInput input) throws IOException {
            this.executeRequestContext = new ExecuteRequestContext(this.getChannel(), this.getHeader().getBatchId());
            ProtocolUtils.expectHeader((DataInput)input, (int)97);
            this.operation.readExternal(input);
            ProtocolUtils.expectHeader((DataInput)input, (int)101);
            this.attachmentsLength = input.readInt();
        }

        protected void processRequest() throws RequestProcessingException {
            TransactionalModelControllerOperationHandler.this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    ModelNode result;
                    AbstractModelControllerOperationHandler.OperationMessageHandlerProxy messageHandlerProxy = new AbstractModelControllerOperationHandler.OperationMessageHandlerProxy(ExecuteRequestHandler.this.getChannel(), ExecuteRequestHandler.this.executeRequestContext.getBatchId());
                    ProxyOperationControlProxy control = new ProxyOperationControlProxy(ExecuteRequestHandler.this.executeRequestContext);
                    AbstractModelControllerOperationHandler.OperationAttachmentsProxy attachmentsProxy = new AbstractModelControllerOperationHandler.OperationAttachmentsProxy(ExecuteRequestHandler.this.getChannel(), ExecuteRequestHandler.this.executeRequestContext.getBatchId(), ExecuteRequestHandler.this.attachmentsLength);
                    try {
                        result = TransactionalModelControllerOperationHandler.this.controller.execute(ExecuteRequestHandler.this.operation, messageHandlerProxy, control, attachmentsProxy);
                    }
                    catch (Exception e) {
                        ModelNode failure = new ModelNode();
                        failure.get("outcome").set("failed");
                        failure.get("failure-description").set(e.getClass().getName() + ":" + e.getMessage());
                        control.operationFailed(failure);
                        attachmentsProxy.shutdown(e);
                        return;
                    }
                    if (result.hasDefined("failure-description")) {
                        control.operationFailed(result);
                    } else {
                        try {
                            ExecuteRequestHandler.this.executeRequestContext.awaitTxCompleted();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            ExecuteRequestHandler.this.executeRequestContext.setError("Error waiting for Tx commit/rollback");
                        }
                        control.operationCompleted(result);
                    }
                }
            });
            try {
                this.executeRequestContext.awaitPreparedOrFailed();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.executeRequestContext.setError(e.getMessage());
                throw new RequestProcessingException("Thread was interrupted waiting for the operation to prepare/fail");
            }
        }
    }

    private static class PingRequestHandler
    extends ManagementRequestHandler {
        private PingRequestHandler() {
        }
    }
}

