/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.CommonXml;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class StandaloneXml
extends CommonXml {
    public StandaloneXml(ModuleLoader loader) {
        super(loader);
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operationList) throws XMLStreamException {
        ModelNode address = new ModelNode().setEmptyList();
        if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.DOMAIN_1_0 || Element.forName(reader.getLocalName()) != Element.SERVER) {
            throw ParseUtils.unexpectedElement(reader);
        }
        this.readServerElement(reader, address, operationList);
    }

    private void readServerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        String serverName = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri(reader.getAttributeNamespace(i))) {
                case NONE: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            serverName = value;
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName(reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, list, i);
                            continue block11;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (serverName == null) {
            serverName = this.getDefaultName();
        }
        this.setServerName(address, list, serverName);
        Element element = ParseUtils.nextElement(reader);
        if (element == Element.EXTENSIONS) {
            this.parseExtensions(reader, address, list);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, list, true);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, list, true);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.MANAGEMENT) {
            this.parseManagement(reader, address, list, true);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.PROFILE) {
            this.parseServerProfile(reader, address, list);
            element = ParseUtils.nextElement(reader);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, list, true);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.SOCKET_BINDING_GROUP) {
            this.parseSocketBindingGroup(reader, interfaceNames, address, list);
            element = ParseUtils.nextElement(reader);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, list, true);
            element = ParseUtils.nextElement(reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseSocketBindingGroup(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        HashSet<String> socketBindings = new HashSet<String>();
        String name = null;
        ModelNode defaultInterface = null;
        ModelNode portOffset = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.DEFAULT_INTERFACE);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    required.remove((Object)attribute);
                    continue block13;
                }
                case DEFAULT_INTERFACE: {
                    defaultInterface = ParseUtils.parsePossibleExpression(value);
                    required.remove((Object)attribute);
                    continue block13;
                }
                case PORT_OFFSET: {
                    portOffset = ParseUtils.parsePossibleExpression(value);
                    if (portOffset.getType() == ModelType.EXPRESSION) continue block13;
                    try {
                        int offset = Integer.parseInt(value);
                        if (offset >= 0) continue block13;
                        throw new XMLStreamException(portOffset + " is not a valid " + attribute.getLocalName() + " -- must be greater than zero", reader.getLocation());
                    }
                    catch (NumberFormatException e) {
                        if (Util.isExpression(value)) continue block13;
                        throw new XMLStreamException(portOffset + " is not a valid " + attribute.getLocalName(), reader.getLocation(), e);
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired(reader, required);
        }
        ModelNode groupAddress = address.clone().add("socket-binding-group", name);
        ModelNode op = Util.getEmptyOperation("add", groupAddress);
        op.get("default-interface").set(defaultInterface);
        op.get("port-offset").set(portOffset == null ? new ModelNode().set(0) : portOffset);
        updates.add(op);
        block14: while (reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SOCKET_BINDING: {
                            String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                            if (socketBindings.contains(bindingName)) {
                                throw new XMLStreamException("socket-binding " + bindingName + " already declared", reader.getLocation());
                            }
                            socketBindings.add(bindingName);
                            continue block14;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseServerProfile(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> configuredSubsystemTypes = new HashSet<String>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.UNKNOWN) {
                throw ParseUtils.unexpectedElement(reader);
            }
            if (Element.forName(reader.getLocalName()) != Element.SUBSYSTEM) {
                throw ParseUtils.unexpectedElement(reader);
            }
            if (!configuredSubsystemTypes.add(reader.getNamespaceURI())) {
                throw new XMLStreamException("Duplicate subsystem declaration", reader.getLocation());
            }
            ArrayList subsystems = new ArrayList();
            reader.handleAny(subsystems);
            for (ModelNode update : subsystems) {
                if (!update.has("address")) {
                    Logger.getLogger((String)"missing address").error((Object)update);
                }
                ModelNode subsystemAddress = address.clone();
                for (Property path : update.get("address").asPropertyList()) {
                    subsystemAddress.add(path.getName(), path.getValue().asString());
                }
                update.get("address").set(subsystemAddress);
                list.add(update);
            }
        }
    }

    private void setServerName(ModelNode address, List<ModelNode> operationList, String value) {
        if (value.length() > 0) {
            ModelNode update = Util.getWriteAttributeOperation(address, "name", value);
            operationList.add(update);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        ModelNode modelNode = context.getModelNode();
        writer.writeStartDocument();
        writer.writeStartElement(Element.SERVER.getLocalName());
        if (modelNode.hasDefined("name")) {
            StandaloneXml.writeAttribute(writer, Attribute.NAME, modelNode.get("name").asString());
        }
        writer.writeDefaultNamespace(Namespace.CURRENT.getUriString());
        this.writeNamespaces(writer, modelNode);
        this.writeSchemaLocation(writer, modelNode);
        if (modelNode.hasDefined("extension")) {
            this.writeExtensions(writer, modelNode.get("extension"));
        }
        if (modelNode.hasDefined("system-property")) {
            this.writeProperties(writer, modelNode.get("system-property"), Element.SYSTEM_PROPERTIES, true);
        }
        if (modelNode.hasDefined("path")) {
            this.writePaths(writer, modelNode.get("path"));
        }
        if (modelNode.hasDefined("core-service") && modelNode.get("core-service").hasDefined("management")) {
            this.writeManagement(writer, modelNode.get(new String[]{"core-service", "management"}), true);
        }
        this.writeServerProfile(writer, context);
        if (modelNode.hasDefined("interface")) {
            this.writeInterfaces(writer, modelNode.get("interface"));
        }
        if (modelNode.hasDefined("socket-binding-group")) {
            Set groups = modelNode.get("socket-binding-group").keys();
            if (groups.size() > 1) {
                throw new IllegalStateException(String.format("Model contains multiple %s nodes", "socket-binding-group"));
            }
            for (String group : groups) {
                this.writeSocketBindingGroup(writer, modelNode.get(new String[]{"socket-binding-group", group}), true);
            }
        }
        if (modelNode.hasDefined("deployment")) {
            this.writeServerDeployments(writer, modelNode.get("deployment"));
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private void writeServerDeployments(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        Set deploymentNames = modelNode.keys();
        if (deploymentNames.size() > 0) {
            boolean deploymentWritten = false;
            for (String uniqueName : deploymentNames) {
                ModelNode deployment = modelNode.get(uniqueName);
                if (deployment.hasDefined("persistent") && !deployment.get("persistent").asBoolean()) continue;
                if (!deploymentWritten) {
                    writer.writeStartElement(Element.DEPLOYMENTS.getLocalName());
                    deploymentWritten = true;
                }
                String runtimeName = deployment.get("runtime-name").asString();
                boolean enabled = deployment.get("enabled").asBoolean();
                writer.writeStartElement(Element.DEPLOYMENT.getLocalName());
                StandaloneXml.writeAttribute(writer, Attribute.NAME, uniqueName);
                StandaloneXml.writeAttribute(writer, Attribute.RUNTIME_NAME, runtimeName);
                if (!enabled) {
                    StandaloneXml.writeAttribute(writer, Attribute.ENABLED, "false");
                }
                List contentItems = deployment.require("content").asList();
                for (ModelNode contentItem : contentItems) {
                    StandaloneXml.writeContentItem(writer, contentItem);
                }
                writer.writeEndElement();
            }
            if (deploymentWritten) {
                writer.writeEndElement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServerProfile(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        ModelNode profileNode = context.getModelNode();
        writer.writeStartElement(Element.PROFILE.getLocalName());
        Set subsystemNames = profileNode.get("subsystem").keys();
        if (subsystemNames.size() > 0) {
            String defaultNamespace = writer.getNamespaceContext().getNamespaceURI("");
            for (String subsystemName : subsystemNames) {
                try {
                    ModelNode subsystem = profileNode.get(new String[]{"subsystem", subsystemName});
                    XMLElementWriter<SubsystemMarshallingContext> subsystemWriter = context.getSubsystemWriter(subsystemName);
                    if (subsystemWriter == null) continue;
                    subsystemWriter.writeContent(writer, (Object)new SubsystemMarshallingContext(subsystem, writer));
                }
                finally {
                    writer.setDefaultNamespace(defaultNamespace);
                }
            }
        }
        writer.writeEndElement();
    }
}

