/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class PathDescription {
    public static final String RELATIVE_TO = "relative-to";
    private static final String RESOURCE_NAME = PathDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getNamedPathDescription(Locale locale) {
        ResourceBundle bundle = PathDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("named_path"));
        PathDescription.populatePath(root, bundle, false);
        return root;
    }

    public static ModelNode getSpecifiedPathDescription(Locale locale) {
        ResourceBundle bundle = PathDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("specified_path"));
        PathDescription.populatePath(root, bundle, true);
        return root;
    }

    private static void populatePath(ModelNode root, ResourceBundle bundle, boolean specified) {
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        root.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("path.name"));
        root.get(new String[]{"attributes", "name", "required"}).set(true);
        root.get(new String[]{"attributes", "name", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "name", "tail-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "path", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "path", "description"}).set(bundle.getString("path.path"));
        root.get(new String[]{"attributes", "path", "required"}).set(specified);
        root.get(new String[]{"attributes", "path", "min-length"}).set(1);
        root.get(new String[]{"attributes", "path", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "path", "tail-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", RELATIVE_TO, "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", RELATIVE_TO, "description"}).set(bundle.getString("path.relative-to"));
        root.get(new String[]{"attributes", RELATIVE_TO, "required"}).set(false);
        root.get(new String[]{"attributes", RELATIVE_TO, "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", RELATIVE_TO, "tail-comment-allowed"}).set(false);
        root.get("operations").setEmptyObject();
    }

    public static ModelNode getNamedPathAddOperation(Locale locale) {
        ResourceBundle bundle = PathDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle.getString("path.add"));
        root.get(new String[]{"request-properties", "path", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "path", "description"}).set(bundle.getString("path.add.path"));
        root.get(new String[]{"request-properties", "path", "required"}).set(false);
        root.get(new String[]{"request-properties", "path", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "path", "nillable"}).set(true);
        root.get(new String[]{"request-properties", RELATIVE_TO, "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", RELATIVE_TO, "description"}).set(bundle.getString("path.add.relative-to"));
        root.get(new String[]{"request-properties", RELATIVE_TO, "required"}).set(false);
        root.get(new String[]{"request-properties", RELATIVE_TO, "nillable"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getSpecifiedPathAddOperation(Locale locale) {
        ModelNode root = PathDescription.getNamedPathAddOperation(locale);
        root.get(new String[]{"request-properties", "path", "required"}).set(true);
        root.get(new String[]{"request-properties", "path", "nillable"}).set(false);
        return root;
    }

    public static ModelNode getPathRemoveOperation(Locale locale) {
        ResourceBundle bundle = PathDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle.getString("path.remove"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static void main(String[] args) {
        ModelNode node = PathDescription.getNamedPathDescription(null);
        node.get(new String[]{"operations", "add"}).set(PathDescription.getNamedPathAddOperation(null));
        node.get(new String[]{"operations", "remove"}).set(PathDescription.getPathRemoveOperation(null));
        System.out.println(node);
        node = PathDescription.getSpecifiedPathDescription(null);
        node.get(new String[]{"operations", "add"}).set(PathDescription.getSpecifiedPathAddOperation(null));
        node.get(new String[]{"operations", "remove"}).set(PathDescription.getPathRemoveOperation(null));
        System.out.println(node);
    }
}

