/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public abstract class AbstractModelUpdateHandler
implements OperationStepHandler {
    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        this.updateModel(operation, resource);
        final ModelNode model = resource.getModel();
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ArrayList controllers = new ArrayList();
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    AbstractModelUpdateHandler.this.performRuntime(context, operation, model, verificationHandler, controllers);
                    if (AbstractModelUpdateHandler.this.requiresRuntimeVerification()) {
                        context.addStep(verificationHandler, OperationContext.Stage.VERIFY);
                    }
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        AbstractModelUpdateHandler.this.rollbackRuntime(context, operation, model, controllers);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected void updateModel(ModelNode operation, Resource resource) throws OperationFailedException {
        this.updateModel(operation, resource.getModel());
    }

    protected abstract void updateModel(ModelNode var1, ModelNode var2) throws OperationFailedException;

    protected boolean requiresRuntime(OperationContext context) {
        return context.getType() == OperationContext.Type.SERVER;
    }

    protected boolean requiresRuntimeVerification() {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        for (ServiceController<?> controller : controllers) {
            context.removeService(controller.getName());
        }
    }
}

