/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.SystemPropertyAddHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class SystemPropertyRemoveHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove-system-property";
    public static final SystemPropertyRemoveHandler INSTANCE = new SystemPropertyRemoveHandler();
    private final ParameterValidator typeValidator = new StringLengthValidator(1);

    public static ModelNode getOperation(ModelNode address, String name) {
        ModelNode op = Util.getEmptyOperation(OPERATION_NAME, address);
        op.get("name").set(name);
        return op;
    }

    protected SystemPropertyRemoveHandler() {
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode param = operation.get("name");
        this.typeValidator.validateParameter("name", param);
        ModelNode properties = context.getSubModel().get("system-properties");
        ModelNode toRemove = null;
        ModelNode newMap = new ModelNode().setEmptyObject();
        String name = param.asString();
        if (properties.isDefined()) {
            for (Property property : properties.asPropertyList()) {
                if (!name.equals(property.getName())) {
                    toRemove = newMap.get(property.getName()).set(property.getValue());
                    continue;
                }
                toRemove = property.getValue();
            }
        }
        if (toRemove != null) {
            properties.set(newMap);
            String value = toRemove.isDefined() ? toRemove.asString() : null;
            ModelNode compensating = SystemPropertyAddHandler.getOperation(operation.get("address"), name, value);
            return this.removeSystemProperty(name, context, resultHandler, compensating);
        }
        throw new OperationFailedException(new ModelNode().set("No property with " + name + "found"));
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getRemoveSystemPropertyOperation(locale);
    }

    protected OperationResult removeSystemProperty(String name, OperationContext context, ResultHandler resultHandler, ModelNode compensating) {
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensating);
    }
}

