/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.JVMAddHandler;
import org.jboss.as.controller.operations.common.JVMRemoveHandler;
import org.jboss.as.controller.operations.common.SystemPropertyAddHandler;
import org.jboss.as.controller.operations.common.SystemPropertyRemoveHandler;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.dmr.ModelNode;

public final class JVMHandlers {
    public static final String JVM_AGENT_LIB = "agent-lib";
    public static final String JVM_AGENT_PATH = "agent-path";
    public static final String JVM_DEBUG_ENABLED = "debug-enabled";
    public static final String JVM_DEBUG_OPTIONS = "debug-options";
    public static final String JVM_ENV_CLASSPATH_IGNORED = "env-classpath-ignored";
    public static final String JVM_ENV_VARIABLES = "environment-variables";
    public static final String JVM_HEAP = "heap";
    public static final String JVM_JAVA_AGENT = "javaagent";
    public static final String JVM_JAVA_HOME = "java-home";
    public static final String JVM_OPTIONS = "jvm-options";
    public static final String JVM_OPTION = "jvm-option";
    public static final String JVM_PERMGEN = "permgen";
    public static final String JVM_STACK = "stack-size";
    public static final String JVM_SYSTEM_PROPERTIES = "system-properties";
    public static final String SIZE = "size";
    public static final String MAX_SIZE = "max-size";
    private static final OperationHandler writeHandler = WriteAttributeHandlers.WriteAttributeOperationHandler.INSTANCE;
    private static final OperationHandler booleanWriteHandler = new ModelUpdateOperationHandler(){

        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            try {
                String name = operation.require("name").asString();
                boolean value = operation.get("value").asBoolean();
                context.getSubModel().get(name).set(value);
                resultHandler.handleResultComplete();
            }
            catch (Exception e) {
                resultHandler.handleFailed(new ModelNode().set(e.getMessage()));
            }
            return new BasicOperationResult();
        }
    };

    public static void register(ModelNodeRegistration registration) {
        registration.registerOperationHandler("add", JVMAddHandler.INSTANCE, JVMAddHandler.INSTANCE, false);
        registration.registerOperationHandler("remove", JVMRemoveHandler.INSTANCE, JVMRemoveHandler.INSTANCE, false);
        registration.registerReadWriteAttribute(JVM_AGENT_LIB, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_AGENT_PATH, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_DEBUG_ENABLED, null, booleanWriteHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_DEBUG_OPTIONS, null, booleanWriteHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_ENV_CLASSPATH_IGNORED, null, booleanWriteHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_ENV_VARIABLES, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_HEAP, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_JAVA_AGENT, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_JAVA_HOME, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_PERMGEN, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute(JVM_STACK, null, writeHandler, AttributeAccess.Storage.CONFIGURATION);
        registration.registerOperationHandler("add-jvm-option", JVMOptionAddHandler.INSTANCE, JVMOptionAddHandler.INSTANCE, false);
        registration.registerOperationHandler("remove-jvm-option", JVMOptionRemoveHandler.INSTANCE, JVMOptionRemoveHandler.INSTANCE, false);
        registration.registerOperationHandler("add-system-property", SystemPropertyAddHandler.INSTANCE, SystemPropertyAddHandler.INSTANCE, false);
        registration.registerOperationHandler("remove-system-property", SystemPropertyRemoveHandler.INSTANCE, SystemPropertyRemoveHandler.INSTANCE, false);
    }

    private JVMHandlers() {
    }

    static final class JVMOptionRemoveHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        static final String OPERATION_NAME = "remove-jvm-option";
        static final JVMOptionRemoveHandler INSTANCE = new JVMOptionRemoveHandler();

        JVMOptionRemoveHandler() {
        }

        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode option = operation.require(JVMHandlers.JVM_OPTION);
            ModelNode compensatingOperation = new ModelNode();
            compensatingOperation.get("operation").set("add-jvm-option");
            compensatingOperation.get("address").set(operation.require("address"));
            compensatingOperation.get(JVMHandlers.JVM_OPTION).set(option);
            ModelNode subModel = context.getSubModel();
            if (subModel.hasDefined(JVMHandlers.JVM_OPTIONS)) {
                ModelNode values = subModel.get(JVMHandlers.JVM_OPTIONS);
                context.getSubModel().get(JVMHandlers.JVM_OPTIONS).setEmptyList();
                for (ModelNode value : values.asList()) {
                    if (value.equals(option)) continue;
                    subModel.get(JVMHandlers.JVM_OPTIONS).add(value);
                }
            }
            resultHandler.handleResultComplete();
            return new BasicOperationResult(compensatingOperation);
        }

        @Override
        public ModelNode getModelDescription(Locale locale) {
            return new ModelNode();
        }
    }

    static final class JVMOptionAddHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        static final String OPERATION_NAME = "add-jvm-option";
        static final JVMOptionAddHandler INSTANCE = new JVMOptionAddHandler();

        JVMOptionAddHandler() {
        }

        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode option = operation.require(JVMHandlers.JVM_OPTION);
            ModelNode compensatingOperation = new ModelNode();
            compensatingOperation.get("operation").set("remove-jvm-option");
            compensatingOperation.get("address").set(operation.require("address"));
            compensatingOperation.get(JVMHandlers.JVM_OPTION).set(option);
            context.getSubModel().get(JVMHandlers.JVM_OPTIONS).add(option);
            resultHandler.handleResultComplete();
            return new BasicOperationResult(compensatingOperation);
        }

        @Override
        public ModelNode getModelDescription(Locale locale) {
            return new ModelNode();
        }
    }
}

