/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ExtensionDescription;
import org.jboss.as.controller.operations.common.AbstractExtensionRemoveHandler;
import org.jboss.dmr.ModelNode;

public abstract class AbstractExtensionAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";

    public static ModelNode getAddExtensionOperation(ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        return op;
    }

    protected AbstractExtensionAddHandler() {
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress(opAddr);
        String module = address.getLastElement().getValue();
        context.getSubModel().get("module").set(module);
        this.installExtension(module, context);
        resultHandler.handleResultComplete();
        return new BasicOperationResult(AbstractExtensionRemoveHandler.getRemoveExtensionOperation(opAddr));
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return ExtensionDescription.getExtensionAddOperation(locale);
    }

    protected abstract void installExtension(String var1, OperationContext var2) throws OperationFailedException;
}

